<?php
/**
 * @link https://craftcms.com/
 * @copyright Copyright (c) Pixel & Tonic, Inc.
 * @license https://craftcms.github.io/license/
 */

namespace craft\elements\actions;

use Craft;
use craft\base\ElementAction;
use craft\base\ElementInterface;
use craft\helpers\Json;
use yii\base\Exception;

/**
 * CopyReferenceTag represents a Copy Reference Tag element action.
 *
 * @author Pixel & Tonic, Inc. <support@pixelandtonic.com>
 * @since 3.0.0
 */
class CopyReferenceTag extends ElementAction
{
    /**
     * @var string|null The element type associated with this action
     */
    public $elementType;

    /**
     * @inheritdoc
     */
    public function getTriggerLabel(): string
    {
        return Craft::t('app', 'Copy reference tag');
    }

    /**
     * @inheritdoc
     */
    public function getTriggerHtml()
    {
        $type = Json::encode(static::class);
        /** @var string|ElementInterface $elementType */
        $elementType = $this->elementType;

        if (($refHandle = $elementType::refHandle()) === null) {
            throw new Exception("Element type \"{$elementType}\" doesn't have a reference handle.");
        }

        $refHandleJs = Json::encode($refHandle);

        $js = <<<JS
(() => {
    new Craft.ElementActionTrigger({
        type: {$type},
        bulk: false,
        activate: function(\$selectedItems)
        {
            Craft.ui.createCopyTextPrompt({
                label: Craft.t('app', 'Copy the reference tag'),
                value: '{'+{$refHandleJs}+':'+\$selectedItems.find('.element').data('id')+'}',
            });
        }
    });
})();
JS;

        Craft::$app->getView()->registerJs($js);
        return null;
    }
}
