-- MySQL dump 10.13  Distrib 8.0.33, for Linux (x86_64)
--
-- Host: 127.0.0.1    Database: addons_wvtrust
-- ------------------------------------------------------
-- Server version	8.0.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` int NOT NULL AUTO_INCREMENT,
  `userId` int NOT NULL,
  `pluginId` int DEFAULT NULL,
  `heading` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `body` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `unread` tinyint(1) NOT NULL DEFAULT '1',
  `dateRead` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_msxtjyqfxfnatleszaxiuycdkmmiohdixtvc` (`userId`,`unread`,`dateRead`,`dateCreated`),
  KEY `idx_jeqknxzfofygddzzvlfhflhasbntbtyozivc` (`dateRead`),
  KEY `fk_yppjghvigghtzwpyusqyrxehhheecydeskte` (`pluginId`),
  CONSTRAINT `fk_hzlfhuftpfmirxxjjmuicpahdfffbsgpwfoa` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_yppjghvigghtzwpyusqyrxehhheecydeskte` FOREIGN KEY (`pluginId`) REFERENCES `plugins` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assetindexdata`
--

DROP TABLE IF EXISTS `assetindexdata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assetindexdata` (
  `id` int NOT NULL AUTO_INCREMENT,
  `sessionId` varchar(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '',
  `volumeId` int NOT NULL,
  `uri` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `size` bigint unsigned DEFAULT NULL,
  `timestamp` datetime DEFAULT NULL,
  `recordId` int DEFAULT NULL,
  `inProgress` tinyint(1) DEFAULT '0',
  `completed` tinyint(1) DEFAULT '0',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_dtpsocntirutmujrpmuwatjglukithnnfppg` (`sessionId`,`volumeId`),
  KEY `idx_dvfyzmlukghmsobrgsgepxvduejptjpnobjh` (`volumeId`),
  CONSTRAINT `fk_objpsqlnnjjmujsgyctxdzibdqaltgbjepzh` FOREIGN KEY (`volumeId`) REFERENCES `volumes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `id` int NOT NULL,
  `volumeId` int DEFAULT NULL,
  `folderId` int NOT NULL,
  `uploaderId` int DEFAULT NULL,
  `filename` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `kind` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'unknown',
  `width` int unsigned DEFAULT NULL,
  `height` int unsigned DEFAULT NULL,
  `size` bigint unsigned DEFAULT NULL,
  `focalPoint` varchar(13) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `deletedWithVolume` tinyint(1) DEFAULT NULL,
  `keptFile` tinyint(1) DEFAULT NULL,
  `dateModified` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_faybusoyrnehuqwazkqpunvvnuqlzfytvoiy` (`filename`,`folderId`),
  KEY `idx_lwxfdvfwipdfhxkaqxlareawehtntvbnyund` (`folderId`),
  KEY `idx_ohspllbzqmttfitfyedhvhtdswfuzfyhqcsh` (`volumeId`),
  KEY `fk_guwbqtdmfcqrcqyugzxnzdizbchowoouqnoq` (`uploaderId`),
  CONSTRAINT `fk_atgxehyoovypuqccuaioabducthmyiwmrhox` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_guwbqtdmfcqrcqyugzxnzdizbchowoouqnoq` FOREIGN KEY (`uploaderId`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_krbdkarcvcsiancsmliysoqjwibmmydkpgmk` FOREIGN KEY (`folderId`) REFERENCES `volumefolders` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_toerxvuwsghphxxzydytztnqbjrhuhkcyxzg` FOREIGN KEY (`volumeId`) REFERENCES `volumes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assettransformindex`
--

DROP TABLE IF EXISTS `assettransformindex`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assettransformindex` (
  `id` int NOT NULL AUTO_INCREMENT,
  `assetId` int NOT NULL,
  `filename` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `format` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `location` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `volumeId` int DEFAULT NULL,
  `fileExists` tinyint(1) NOT NULL DEFAULT '0',
  `inProgress` tinyint(1) NOT NULL DEFAULT '0',
  `error` tinyint(1) NOT NULL DEFAULT '0',
  `dateIndexed` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_ptnmibsfrlpmydaesyodpjcvmwbuibnwmnqu` (`volumeId`,`assetId`,`location`),
  KEY `idx_opbbggvegppnpcnpodbsiklbkxxdqsoopkgl` (`assetId`,`format`,`location`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assettransforms`
--

DROP TABLE IF EXISTS `assettransforms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assettransforms` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `handle` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `mode` enum('stretch','fit','crop') CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'crop',
  `position` enum('top-left','top-center','top-right','center-left','center-center','center-right','bottom-left','bottom-center','bottom-right') CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'center-center',
  `width` int unsigned DEFAULT NULL,
  `height` int unsigned DEFAULT NULL,
  `format` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `quality` int DEFAULT NULL,
  `interlace` enum('none','line','plane','partition') CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'none',
  `dimensionChangeTime` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_xrzyahgaqmgstfwxoejwnvlqojsoopcfelpg` (`name`),
  KEY `idx_znfxnrdhqpehmhgbgjsotdaxzzeeltbijfxu` (`handle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` int NOT NULL,
  `groupId` int NOT NULL,
  `parentId` int DEFAULT NULL,
  `deletedWithGroup` tinyint(1) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_vdfwgygieaxdiwxjdtbhqarzjrfsoecvycfs` (`groupId`),
  KEY `fk_nozuydkppayzwxsvhkzafkzzpehkweiwmhci` (`parentId`),
  CONSTRAINT `fk_iyoujrzcanzgpfcvliccrezscpfbiltnhqkk` FOREIGN KEY (`groupId`) REFERENCES `categorygroups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_nozuydkppayzwxsvhkzafkzzpehkweiwmhci` FOREIGN KEY (`parentId`) REFERENCES `categories` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_qohyddfyferigkxzbqjvagxcqqxeezozggyu` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `categorygroups`
--

DROP TABLE IF EXISTS `categorygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categorygroups` (
  `id` int NOT NULL AUTO_INCREMENT,
  `structureId` int NOT NULL,
  `fieldLayoutId` int DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `handle` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `defaultPlacement` enum('beginning','end') CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'end',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_zhwrniitdkjdwvhkpkeqhtgatlqcapdzjrox` (`name`),
  KEY `idx_ygtefzstrzhfyztymazahqvwhrqbkvfmqzcl` (`handle`),
  KEY `idx_zuykzlcfkzuloxjagottqhjexitwbjagzrjj` (`structureId`),
  KEY `idx_wfpzcxpnissrpjdktjrqtcjcpdxuznmdsuve` (`fieldLayoutId`),
  KEY `idx_pnborjvwhbnnjtggfftpvijkpooeyhdhjzwm` (`dateDeleted`),
  CONSTRAINT `fk_gacqubzgtpynwyqhjydqxbuvfjtdvrovqqqf` FOREIGN KEY (`structureId`) REFERENCES `structures` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_grcqyhzruvgrcuyfievcmnfzqjabtuuroena` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `categorygroups_sites`
--

DROP TABLE IF EXISTS `categorygroups_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categorygroups_sites` (
  `id` int NOT NULL AUTO_INCREMENT,
  `groupId` int NOT NULL,
  `siteId` int NOT NULL,
  `hasUrls` tinyint(1) NOT NULL DEFAULT '1',
  `uriFormat` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `template` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_ihbodxaxcpslxedxiywlreyqhujuxnpvicar` (`groupId`,`siteId`),
  KEY `idx_pssihjooyheybezsvlojcxnwjgtjfamtnkfr` (`siteId`),
  CONSTRAINT `fk_hawmqomrjaykqwvzxtzospxsmxtsrdcuytyx` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_mzodtlvkorvhtyxigguztuardljuteekembm` FOREIGN KEY (`groupId`) REFERENCES `categorygroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `changedattributes`
--

DROP TABLE IF EXISTS `changedattributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `changedattributes` (
  `elementId` int NOT NULL,
  `siteId` int NOT NULL,
  `attribute` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `propagated` tinyint(1) NOT NULL,
  `userId` int DEFAULT NULL,
  PRIMARY KEY (`elementId`,`siteId`,`attribute`),
  KEY `idx_qzekczovmysyacqkwgpxmvdljmikidieuhxt` (`elementId`,`siteId`,`dateUpdated`),
  KEY `fk_njtjjbykylaslifvznrxihdsynoyzuvwynwq` (`siteId`),
  KEY `fk_cawicrlwrcabzarqxphqkmapfxybroxthbdz` (`userId`),
  CONSTRAINT `fk_cawicrlwrcabzarqxphqkmapfxybroxthbdz` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_desbvwgapuarurhanjrfumpjydoltbdsfkgu` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_njtjjbykylaslifvznrxihdsynoyzuvwynwq` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `changedfields`
--

DROP TABLE IF EXISTS `changedfields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `changedfields` (
  `elementId` int NOT NULL,
  `siteId` int NOT NULL,
  `fieldId` int NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `propagated` tinyint(1) NOT NULL,
  `userId` int DEFAULT NULL,
  PRIMARY KEY (`elementId`,`siteId`,`fieldId`),
  KEY `idx_hfatjqlqcclkdmvafzviuqtrleqarfpaafbg` (`elementId`,`siteId`,`dateUpdated`),
  KEY `fk_qggrksjcftudzuivwjxgmwukdwtcxdcyfsfb` (`siteId`),
  KEY `fk_ktwzdhdisxeudyfkxvrctymnnwkwnwtyjhve` (`fieldId`),
  KEY `fk_dpssslsfguawjjpxtmcetgnymkqfmbbuvqhj` (`userId`),
  CONSTRAINT `fk_dpssslsfguawjjpxtmcetgnymkqfmbbuvqhj` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_ktwzdhdisxeudyfkxvrctymnnwkwnwtyjhve` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_qggrksjcftudzuivwjxgmwukdwtcxdcyfsfb` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_tcswkjqbruduostryzuhcxavnahnsdveufnl` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `content`
--

DROP TABLE IF EXISTS `content`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `content` (
  `id` int NOT NULL AUTO_INCREMENT,
  `elementId` int NOT NULL,
  `siteId` int NOT NULL,
  `title` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  `field_introduction_oldpmmwb` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `field_pagecopy_rbegzurr` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_ukaovcrqvctrqnzvhlcvymrolzhnaubfleii` (`elementId`,`siteId`),
  KEY `idx_ypkcukxsbospkwwxhkmqakvzjgemrsbsexyg` (`siteId`),
  KEY `idx_qljrnlrdchejffwfumrxaomueihjcqxxjwuo` (`title`),
  CONSTRAINT `fk_ktpxwdpfbjwatopftivmqldealvmczpbjmjk` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_mqwhptpuqrwgzllxzpswuxmoagzsuzmhmwbt` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=90 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `craftidtokens`
--

DROP TABLE IF EXISTS `craftidtokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `craftidtokens` (
  `id` int NOT NULL AUTO_INCREMENT,
  `userId` int NOT NULL,
  `accessToken` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `expiryDate` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fk_ugypxbbgmcyrasiyjzqeellcrphyfzzfffly` (`userId`),
  CONSTRAINT `fk_ugypxbbgmcyrasiyjzqeellcrphyfzzfffly` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `deprecationerrors`
--

DROP TABLE IF EXISTS `deprecationerrors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `deprecationerrors` (
  `id` int NOT NULL AUTO_INCREMENT,
  `key` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fingerprint` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `lastOccurrence` datetime NOT NULL,
  `file` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `line` smallint unsigned DEFAULT NULL,
  `message` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `traces` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_afgsklxplkvixrqygvxpppjrterxelvmsifo` (`key`,`fingerprint`)
) ENGINE=InnoDB AUTO_INCREMENT=247 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `drafts`
--

DROP TABLE IF EXISTS `drafts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `drafts` (
  `id` int NOT NULL AUTO_INCREMENT,
  `sourceId` int DEFAULT NULL,
  `creatorId` int DEFAULT NULL,
  `provisional` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `notes` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `trackChanges` tinyint(1) NOT NULL DEFAULT '0',
  `dateLastMerged` datetime DEFAULT NULL,
  `saved` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_mjdjitxperdugvqskvmqbxyaxdgaxpmawyxi` (`creatorId`,`provisional`),
  KEY `idx_ltkyvnakjasmqarjpjfcvrvdechosurvofzd` (`saved`),
  KEY `fk_ukxcffxvejonwmxqocfwbiyvwcffhennuumu` (`sourceId`),
  CONSTRAINT `fk_lhygpldtdanlwtvmhrrgnwjcemsotsautnsk` FOREIGN KEY (`creatorId`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_ukxcffxvejonwmxqocfwbiyvwcffhennuumu` FOREIGN KEY (`sourceId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elementindexsettings`
--

DROP TABLE IF EXISTS `elementindexsettings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `elementindexsettings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `settings` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_eazhsyxktgkhcitsmocgbiaugohcmlyokwvn` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elements`
--

DROP TABLE IF EXISTS `elements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `elements` (
  `id` int NOT NULL AUTO_INCREMENT,
  `canonicalId` int DEFAULT NULL,
  `draftId` int DEFAULT NULL,
  `revisionId` int DEFAULT NULL,
  `fieldLayoutId` int DEFAULT NULL,
  `type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `archived` tinyint(1) NOT NULL DEFAULT '0',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateLastMerged` datetime DEFAULT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_sblwedkckunfopyzxpfjliwxdddefadzknko` (`dateDeleted`),
  KEY `idx_iwdrpkyevnzovjxkvifxkwtejtohuiynrxhj` (`fieldLayoutId`),
  KEY `idx_svgvsicseajhlbbbnedbbkgezwjqdsnmmjvw` (`type`),
  KEY `idx_ozunmeyeovfjhrgfxuojbcgmpzhzackeoukc` (`enabled`),
  KEY `idx_mjvhmhrvdlbnirayukbzlcxjalngiwaxkbhn` (`archived`,`dateCreated`),
  KEY `idx_pivncvxnvneupunxoiumntoyrghcelxgidxx` (`archived`,`dateDeleted`,`draftId`,`revisionId`,`canonicalId`),
  KEY `idx_rdomlewdidwxzermtchwdxcknwwjglxsldxd` (`archived`,`dateDeleted`,`draftId`,`revisionId`,`canonicalId`,`enabled`),
  KEY `fk_igjcacugoucfmhgzkzlggzslzcykmodnugde` (`canonicalId`),
  KEY `fk_bevwpnfnwbelkfboslwczacllbrtyinvvdri` (`draftId`),
  KEY `fk_adweuorzzekacfmnzqevlaiglerfzbstoozm` (`revisionId`),
  CONSTRAINT `fk_adweuorzzekacfmnzqevlaiglerfzbstoozm` FOREIGN KEY (`revisionId`) REFERENCES `revisions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_bevwpnfnwbelkfboslwczacllbrtyinvvdri` FOREIGN KEY (`draftId`) REFERENCES `drafts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_igjcacugoucfmhgzkzlggzslzcykmodnugde` FOREIGN KEY (`canonicalId`) REFERENCES `elements` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_itqqwhjlwqlzxscoczepsomiaawpygpimguz` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=225 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elements_sites`
--

DROP TABLE IF EXISTS `elements_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `elements_sites` (
  `id` int NOT NULL AUTO_INCREMENT,
  `elementId` int NOT NULL,
  `siteId` int NOT NULL,
  `slug` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `uri` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_mheboxfuqhylsilforggbrvkbmkmzlgxtmuj` (`elementId`,`siteId`),
  KEY `idx_qryfcvkoubnszmrifswgowtmvqecbskgtjev` (`siteId`),
  KEY `idx_wutfkzemcwejqrmkohauwglpfqtsdyyeeaga` (`slug`,`siteId`),
  KEY `idx_sjksvliqfcjwbmcaamhdfchuzukvdwuxfxng` (`enabled`),
  KEY `idx_pwmxctiheuiulpejnktwpabsscmkdepknvtv` (`uri`,`siteId`),
  CONSTRAINT `fk_ogxjtjgsoslpxmerzqadnopzecihvrhqssbs` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_swmbrhqrjgtvdocvrwepmbrgekfwwxvkvynj` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=225 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `entries`
--

DROP TABLE IF EXISTS `entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `entries` (
  `id` int NOT NULL,
  `sectionId` int NOT NULL,
  `parentId` int DEFAULT NULL,
  `typeId` int NOT NULL,
  `authorId` int DEFAULT NULL,
  `postDate` datetime DEFAULT NULL,
  `expiryDate` datetime DEFAULT NULL,
  `deletedWithEntryType` tinyint(1) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_wgueierrorkuolaxulovsrxutriqzlqnjvzh` (`postDate`),
  KEY `idx_yslwpybgrhbgxqfopkqsjzkmzgcfprcgnjnf` (`expiryDate`),
  KEY `idx_kozqepasxgsacklceqdpbrtytruqxdadhphn` (`authorId`),
  KEY `idx_cyibwiuauauhnjxpygwbhlftxiuaokbyerml` (`sectionId`),
  KEY `idx_ojmzxujuumjeajozdcdauyeueyfbzdvbncqw` (`typeId`),
  KEY `fk_szljuzqrkqpzucpocqzeqwppiaibqpojugcm` (`parentId`),
  CONSTRAINT `fk_cczfgeqlbcovucpfyddjmqqafaqjsfvakqmv` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_ivjzqucnopqvbhfheijrpxnccmxuuzxrtjdq` FOREIGN KEY (`typeId`) REFERENCES `entrytypes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_mgsidhcourtxnnzlgiojcuprwwmdhdjorhkc` FOREIGN KEY (`authorId`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_srizjnwlwyzrfojdpklampdvizndsdrapphm` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_szljuzqrkqpzucpocqzeqwppiaibqpojugcm` FOREIGN KEY (`parentId`) REFERENCES `entries` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `entrytypes`
--

DROP TABLE IF EXISTS `entrytypes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `entrytypes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `sectionId` int NOT NULL,
  `fieldLayoutId` int DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `handle` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `hasTitleField` tinyint(1) NOT NULL DEFAULT '1',
  `titleTranslationMethod` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'site',
  `titleTranslationKeyFormat` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `titleFormat` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `sortOrder` smallint unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_znolvdogqkejctbtdwywazwvxabsjogqqsqd` (`name`,`sectionId`),
  KEY `idx_fsmfgvzpkbbuyioueclihkkcaquqaowzafnz` (`handle`,`sectionId`),
  KEY `idx_fdxzqippfqdbrwpqtectxxysqapurpxjuhvv` (`sectionId`),
  KEY `idx_ryccdfpudvfskypoglbpseqzukaezdtvvxzl` (`fieldLayoutId`),
  KEY `idx_alsyuefumcnyqkxciyzycimllyywrupmeayi` (`dateDeleted`),
  CONSTRAINT `fk_pykgoyysmfmsdnkkgvgjygacudajbjohcbrj` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_zqbmbtoymugaxiwyckcdgvxtwuipeghdnrxc` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fieldgroups`
--

DROP TABLE IF EXISTS `fieldgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fieldgroups` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_bdrcuhrleeguvtbnlrzezeeeehyonjdhlvzj` (`name`),
  KEY `idx_auvgymxfiaoifejkchinnkzvvatokkbuhthy` (`dateDeleted`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fieldlayoutfields`
--

DROP TABLE IF EXISTS `fieldlayoutfields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fieldlayoutfields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `layoutId` int NOT NULL,
  `tabId` int NOT NULL,
  `fieldId` int NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `sortOrder` smallint unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_gudefqfwxxdhgcbppvbotxuxmumotxutwihb` (`layoutId`,`fieldId`),
  KEY `idx_wwfdvutgyakfyrfkapicjghpmlszdlnztfar` (`sortOrder`),
  KEY `idx_rgphejrdzsxbwiokkgqkufojhhaqmomwdfvi` (`tabId`),
  KEY `idx_uardyjaykbgctjqrxtlkjttowdxyqrzwdfkx` (`fieldId`),
  CONSTRAINT `fk_biptdhtjwyozwbutrkuewbhjkadojwbvqaqs` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_ojilewwskeibxyznmodzksqdtohjchkvoelx` FOREIGN KEY (`tabId`) REFERENCES `fieldlayouttabs` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_qtyizogkvaloedcwdbwgfrlhanvdumducquz` FOREIGN KEY (`layoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fieldlayouts`
--

DROP TABLE IF EXISTS `fieldlayouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fieldlayouts` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_rsplskognvytrqqouupzzwfpvsuxfdfeglbc` (`dateDeleted`),
  KEY `idx_dveuwtsmgamxinzvrdkwpzsrtjwkcdonkbdu` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fieldlayouttabs`
--

DROP TABLE IF EXISTS `fieldlayouttabs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fieldlayouttabs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `layoutId` int NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `elements` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `sortOrder` smallint unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_tszflccenciycebguugjxyiejdrupviayuas` (`sortOrder`),
  KEY `idx_ulernhapokbuqfhyptfjxtfkhznpopdbngnu` (`layoutId`),
  CONSTRAINT `fk_mrbmadqvlxdgblpdarqetbczjfozcrpynfiy` FOREIGN KEY (`layoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fields`
--

DROP TABLE IF EXISTS `fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `groupId` int DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `handle` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `context` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'global',
  `columnSuffix` char(8) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `instructions` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `searchable` tinyint(1) NOT NULL DEFAULT '1',
  `translationMethod` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'none',
  `translationKeyFormat` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `settings` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_andkuharlzwuytzzzynakieeyygnwmqajypl` (`handle`,`context`),
  KEY `idx_ugyaddoffwrdbqfbhbtgevohmiekgdikyeei` (`groupId`),
  KEY `idx_kdnqhqgsxeiwgqgishnzbwzsaouobqgccsmj` (`context`),
  CONSTRAINT `fk_upcitnekvdvumfyuaerpeliwshdszwxfyjhd` FOREIGN KEY (`groupId`) REFERENCES `fieldgroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `globalsets`
--

DROP TABLE IF EXISTS `globalsets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `globalsets` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `handle` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fieldLayoutId` int DEFAULT NULL,
  `sortOrder` smallint unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_sfwchwyxqyptznxhxlafzyotxpqxzdkhcsuo` (`name`),
  KEY `idx_yekdsfgoefqldhumrxnbqfoekjospwbnjxxd` (`handle`),
  KEY `idx_kdplivgtqisyfzmhvxnjoflmenivorevfcyl` (`fieldLayoutId`),
  KEY `idx_djvsxtdkaslqtnjbtmekaskeifptbzvbtweg` (`sortOrder`),
  CONSTRAINT `fk_dufhqgoserrtvfdciveyxjsguzmfrvnswyui` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_xgujdlomxfhbzksvammrgosueejltzyxqnzo` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gqlschemas`
--

DROP TABLE IF EXISTS `gqlschemas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gqlschemas` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `scope` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `isPublic` tinyint(1) NOT NULL DEFAULT '0',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gqltokens`
--

DROP TABLE IF EXISTS `gqltokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gqltokens` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `accessToken` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `expiryDate` datetime DEFAULT NULL,
  `lastUsed` datetime DEFAULT NULL,
  `schemaId` int DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_yvwxrcimkbmmjlaoxjfxzoapwmmssolxhkvq` (`accessToken`),
  UNIQUE KEY `idx_pfuxcltfnivklassyrpinjsnyqtxgzqdhivy` (`name`),
  KEY `fk_rybzuxivvtchjjncmdmfsqclcaasicjhcetp` (`schemaId`),
  CONSTRAINT `fk_rybzuxivvtchjjncmdmfsqclcaasicjhcetp` FOREIGN KEY (`schemaId`) REFERENCES `gqlschemas` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `info`
--

DROP TABLE IF EXISTS `info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `info` (
  `id` int NOT NULL AUTO_INCREMENT,
  `version` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `schemaVersion` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `maintenance` tinyint(1) NOT NULL DEFAULT '0',
  `configVersion` char(12) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '000000000000',
  `fieldVersion` char(12) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '000000000000',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `matrixblocks`
--

DROP TABLE IF EXISTS `matrixblocks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `matrixblocks` (
  `id` int NOT NULL,
  `ownerId` int NOT NULL,
  `fieldId` int NOT NULL,
  `typeId` int NOT NULL,
  `sortOrder` smallint unsigned DEFAULT NULL,
  `deletedWithOwner` tinyint(1) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_gfthpeqqnqaqhfwltinbbqlauiapctwjlwoi` (`ownerId`),
  KEY `idx_bphdxjmezynczvlmrvcgiytfmtztwsfeelsf` (`fieldId`),
  KEY `idx_pcozqhfpjvaseyozlaastugkwguimseyukaf` (`typeId`),
  KEY `idx_zrmucgegnovsgpusdshebtgeasenvpsxjtvu` (`sortOrder`),
  CONSTRAINT `fk_jhqckblzwuhrwncuhryygiialnvvcfjtwkzu` FOREIGN KEY (`ownerId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_svbohqhmyxnjhmkhbcsclfmqomvoryqjcpcp` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_yffetqsjlyobzxtchxvonmfandbmknfckocx` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_yremgkyudfdulievdieyqvuskqvgujygqgpt` FOREIGN KEY (`typeId`) REFERENCES `matrixblocktypes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `matrixblocktypes`
--

DROP TABLE IF EXISTS `matrixblocktypes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `matrixblocktypes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `fieldId` int NOT NULL,
  `fieldLayoutId` int DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `handle` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `sortOrder` smallint unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_eoptrkhfftagldudkxktntdopynjswvxjppy` (`name`,`fieldId`),
  KEY `idx_odlkdoxzoabmfnyxhymbnxdsifgajvnjwlxy` (`handle`,`fieldId`),
  KEY `idx_lzuxfrjzaxhzwsgroquzjsyqbvoclnspripb` (`fieldId`),
  KEY `idx_ilhhsdzgfcdmbwzpvskvjjkdqvfwhmizlskz` (`fieldLayoutId`),
  CONSTRAINT `fk_lcyhhlzmpgipbnuzoowazoapxnvnhmalddcs` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_magokknjtpwovkfjzpyxwxxroohsyvprvlfw` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `matrixcontent_pagelinks`
--

DROP TABLE IF EXISTS `matrixcontent_pagelinks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `matrixcontent_pagelinks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `elementId` int NOT NULL,
  `siteId` int NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  `field_link_path_jdjmkifc` varchar(400) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `field_link_linkname_dotldesy` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `field_link_description_czvzkzmw` varchar(800) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_fgfnejlcgxkldrzeszomysyqhzhqfyhalays` (`elementId`,`siteId`),
  KEY `fk_lwtiiyjdlslwxxgdkkzkfpjqndmjwcmjjewl` (`siteId`),
  CONSTRAINT `fk_ayacdjicwkbcjnicibxholsifrwlgnxtlvwu` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_lwtiiyjdlslwxxgdkkzkfpjqndmjwcmjjewl` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=96 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `matrixcontent_serviceproviders`
--

DROP TABLE IF EXISTS `matrixcontent_serviceproviders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `matrixcontent_serviceproviders` (
  `id` int NOT NULL AUTO_INCREMENT,
  `elementId` int NOT NULL,
  `siteId` int NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  `field_vendor_businessType_dkbjfaab` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `field_vendor_contactDetails_epbvbqny` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `field_vendor_businessName_ixuxkuzm` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_catlpmobpoqirdehryrvgjxbadhfsaoujnsz` (`elementId`,`siteId`),
  KEY `fk_ltjnbvzrwwyunkkbjbzdxxqupinbmbloucbv` (`siteId`),
  CONSTRAINT `fk_ltjnbvzrwwyunkkbjbzdxxqupinbmbloucbv` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_rmlwnjpqxfpznlhrtsaewivjhjdbxegekcor` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `track` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `applyTime` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_klzqfbziuzfgbqzptkzeovyrkvaasueamzvg` (`track`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=199 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `plugins`
--

DROP TABLE IF EXISTS `plugins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `plugins` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `version` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `schemaVersion` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `installDate` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_ovkmhhieozvcgeahbqahobymykkbuapiuwig` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `projectconfig`
--

DROP TABLE IF EXISTS `projectconfig`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `projectconfig` (
  `path` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `value` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `queue`
--

DROP TABLE IF EXISTS `queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `queue` (
  `id` int NOT NULL AUTO_INCREMENT,
  `channel` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'queue',
  `job` longblob NOT NULL,
  `description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `timePushed` int NOT NULL,
  `ttr` int NOT NULL,
  `delay` int NOT NULL DEFAULT '0',
  `priority` int unsigned NOT NULL DEFAULT '1024',
  `dateReserved` datetime DEFAULT NULL,
  `timeUpdated` int DEFAULT NULL,
  `progress` smallint NOT NULL DEFAULT '0',
  `progressLabel` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `attempt` int DEFAULT NULL,
  `fail` tinyint(1) DEFAULT '0',
  `dateFailed` datetime DEFAULT NULL,
  `error` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `idx_jlkfsjchebuyejnifizyusbmbwaslzaijivv` (`channel`,`fail`,`timeUpdated`,`timePushed`),
  KEY `idx_mrlmeqiorbbskiduewqzstflvipgzhqdztxk` (`channel`,`fail`,`timeUpdated`,`delay`)
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `relations`
--

DROP TABLE IF EXISTS `relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `relations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `fieldId` int NOT NULL,
  `sourceId` int NOT NULL,
  `sourceSiteId` int DEFAULT NULL,
  `targetId` int NOT NULL,
  `sortOrder` smallint unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_ljjaugqlhkzkggzktcpmnpqbluzlcaxdqqdn` (`fieldId`,`sourceId`,`sourceSiteId`,`targetId`),
  KEY `idx_kamszxrcouwgfyuoaljzivjtdhplkffpwfjj` (`sourceId`),
  KEY `idx_xnpjcfxsmewcoedibhpyuyqrghapzkfyjwuf` (`targetId`),
  KEY `idx_iwpyujikthspmczyuebsrqxujurtsdndgovy` (`sourceSiteId`),
  CONSTRAINT `fk_kzqbpgqkwcykpzsvnhoiwvpymvpmihekuynx` FOREIGN KEY (`sourceId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_qxhiltsrhpwylyiwcvjawcdkgccwtevxnphg` FOREIGN KEY (`sourceSiteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_sgqlgxxksrkawnpdnjgiahmgorhwjyvmywmh` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `resourcepaths`
--

DROP TABLE IF EXISTS `resourcepaths`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `resourcepaths` (
  `hash` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `path` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `sourceId` int NOT NULL,
  `creatorId` int DEFAULT NULL,
  `num` int NOT NULL,
  `notes` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_nvcpkeioigjejceydarakcvatrlxnmgihqcr` (`sourceId`,`num`),
  KEY `fk_fsddcxpdvofcmlpltkwkyziairadjcpqmqws` (`creatorId`),
  CONSTRAINT `fk_fsddcxpdvofcmlpltkwkyziairadjcpqmqws` FOREIGN KEY (`creatorId`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_tdtzmoyjmvirfmpespzvkttnydzbmsumihau` FOREIGN KEY (`sourceId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `searchindex`
--

DROP TABLE IF EXISTS `searchindex`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `searchindex` (
  `elementId` int NOT NULL,
  `attribute` varchar(25) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fieldId` int NOT NULL,
  `siteId` int NOT NULL,
  `keywords` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`elementId`,`attribute`,`fieldId`,`siteId`),
  FULLTEXT KEY `idx_wiwtcvvvemlzapkgnseomxpdnfzombjcarof` (`keywords`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sections`
--

DROP TABLE IF EXISTS `sections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sections` (
  `id` int NOT NULL AUTO_INCREMENT,
  `structureId` int DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `handle` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `type` enum('single','channel','structure') CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'channel',
  `enableVersioning` tinyint(1) NOT NULL DEFAULT '0',
  `propagationMethod` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'all',
  `defaultPlacement` enum('beginning','end') CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'end',
  `previewTargets` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_tqbwcjefqoopkpiipjfnpznuemfhfvicozud` (`handle`),
  KEY `idx_dgnpwnvnakftbimsgvnkdifxqwgzgirrsrjf` (`name`),
  KEY `idx_kqcajskuztobcjyfoadmmlenyozndluqdgnq` (`structureId`),
  KEY `idx_sexnyyabqlspshsxydchxpccdakmhzeptgfg` (`dateDeleted`),
  CONSTRAINT `fk_ckxfftcolgigieibayhrmztumykbfdpkerbb` FOREIGN KEY (`structureId`) REFERENCES `structures` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sections_sites`
--

DROP TABLE IF EXISTS `sections_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sections_sites` (
  `id` int NOT NULL AUTO_INCREMENT,
  `sectionId` int NOT NULL,
  `siteId` int NOT NULL,
  `hasUrls` tinyint(1) NOT NULL DEFAULT '1',
  `uriFormat` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `template` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `enabledByDefault` tinyint(1) NOT NULL DEFAULT '1',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_vewilqhefdfqtywveotvcmmzuhklmbgqnoyh` (`sectionId`,`siteId`),
  KEY `idx_voscyzvdhrdsgethvgdgxyroaonkdxpgihwx` (`siteId`),
  CONSTRAINT `fk_ooltsqbglvqxiexhdhzxzkxjivyspkuiihdj` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_qxlacbzirjfbuhjnhcdixttxnsglfabevhox` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequences`
--

DROP TABLE IF EXISTS `sequences`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequences` (
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `next` int unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `userId` int NOT NULL,
  `token` char(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_kvclhpevavvvonpptfldhqkclvfwvrtzzzqf` (`uid`),
  KEY `idx_cnzjyaakzrgomlchgohcmxyabowczqqmffqa` (`token`),
  KEY `idx_gpkrqkogoyhpysnhjngfartfzgqdwjywxcve` (`dateUpdated`),
  KEY `idx_sgsdfqgifujwaegbcqtzwrhstygjszdnwcuw` (`userId`),
  CONSTRAINT `fk_lquxeszedhiowkodxfmblaizwmdusjdkezjj` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `shunnedmessages`
--

DROP TABLE IF EXISTS `shunnedmessages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shunnedmessages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `userId` int NOT NULL,
  `message` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `expiryDate` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_arzveqdkyoenphunjsuakdidtagobtrayloe` (`userId`,`message`),
  CONSTRAINT `fk_yammpvkovijwpciwejaytdbhmriesqmhbama` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sitegroups`
--

DROP TABLE IF EXISTS `sitegroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sitegroups` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_txscbuhpigchzvphkxrcqgpclhjditahifiu` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sites`
--

DROP TABLE IF EXISTS `sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sites` (
  `id` int NOT NULL AUTO_INCREMENT,
  `groupId` int NOT NULL,
  `primary` tinyint(1) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `handle` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `language` varchar(12) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `hasUrls` tinyint(1) NOT NULL DEFAULT '0',
  `baseUrl` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `sortOrder` smallint unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_cwwpitelnkqaalbztynhiamehgvmvyawaktk` (`dateDeleted`),
  KEY `idx_sekvhvrdgbtgyhemmdpisbcmfmiaybggpntq` (`handle`),
  KEY `idx_dpmbrzsiehcpricwvjmmiiuipgibgqqubymh` (`sortOrder`),
  KEY `fk_fosdemjjwuihqughicttonoqgwidlorhanlk` (`groupId`),
  CONSTRAINT `fk_fosdemjjwuihqughicttonoqgwidlorhanlk` FOREIGN KEY (`groupId`) REFERENCES `sitegroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `structureelements`
--

DROP TABLE IF EXISTS `structureelements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `structureelements` (
  `id` int NOT NULL AUTO_INCREMENT,
  `structureId` int NOT NULL,
  `elementId` int DEFAULT NULL,
  `root` int unsigned DEFAULT NULL,
  `lft` int unsigned NOT NULL,
  `rgt` int unsigned NOT NULL,
  `level` smallint unsigned NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_tdfhgvpxitvyrmqjnptnlifxaikrjxfbuqmw` (`structureId`,`elementId`),
  KEY `idx_chvuhqgmncajkamqivxuwjxloegzdddjaafh` (`root`),
  KEY `idx_cznktbsuyhyywpchbmjoizfrvsylzhyarhjb` (`lft`),
  KEY `idx_cdmydfunvkkitsnknewnxzwzzrtrmcgcgejq` (`rgt`),
  KEY `idx_hnwlktxkmoskjvxmyjauvbiadzrzizrkuzml` (`level`),
  KEY `idx_ctfeeuuatfivucuiuzjfgydjrvghlsmpdqbb` (`elementId`),
  CONSTRAINT `fk_xurmjceyifackelinusfmbrtajeghhmuarbf` FOREIGN KEY (`structureId`) REFERENCES `structures` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `structures`
--

DROP TABLE IF EXISTS `structures`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `structures` (
  `id` int NOT NULL AUTO_INCREMENT,
  `maxLevels` smallint unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_onliwrexolmtsplxmggpxhdezsepugtnlsjp` (`dateDeleted`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `systemmessages`
--

DROP TABLE IF EXISTS `systemmessages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `systemmessages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `language` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `key` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `subject` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `body` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_pjrjrhwzxsumbqzwojtsqitbjnokqnhijqqc` (`key`,`language`),
  KEY `idx_oiytpapvjkugvnvgfpaanhdefydxtlvikbee` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `taggroups`
--

DROP TABLE IF EXISTS `taggroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `taggroups` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `handle` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fieldLayoutId` int DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_mkdfltyvgroxbxnttwlsaeqxlssmkoxafnvn` (`name`),
  KEY `idx_wtgjbetlsyozqgipjclyojlbrmvaqnnlkevq` (`handle`),
  KEY `idx_hhskcwljddlildnvtbcqmjrjtvovulzeysbp` (`dateDeleted`),
  KEY `fk_gqguueejanqfesgwvvmdmjskbjdldqtrtntd` (`fieldLayoutId`),
  CONSTRAINT `fk_gqguueejanqfesgwvvmdmjskbjdldqtrtntd` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` int NOT NULL,
  `groupId` int NOT NULL,
  `deletedWithGroup` tinyint(1) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_eesalumveiokzowcrmiinbuwkchsdhaqwmob` (`groupId`),
  CONSTRAINT `fk_joslsziztdbyblwijfahbqiurgfuyyqeutan` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_qkhqfimyceuarruzqyzimjqqvsxglirrnzol` FOREIGN KEY (`groupId`) REFERENCES `taggroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `templatecacheelements`
--

DROP TABLE IF EXISTS `templatecacheelements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `templatecacheelements` (
  `id` int NOT NULL AUTO_INCREMENT,
  `cacheId` int NOT NULL,
  `elementId` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_aovzumqrlpmrspzukbdpatyqtivtrfmikqlx` (`cacheId`),
  KEY `idx_dwbecijnurutzhdkpczvwsovwwkmbldqwtbc` (`elementId`),
  CONSTRAINT `fk_hdsxtqtyozzijqwuxfxztsyphyqywsrvkidw` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_reiuckuxksvywumfcdsbyopxthjjigocxmkc` FOREIGN KEY (`cacheId`) REFERENCES `templatecaches` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `templatecachequeries`
--

DROP TABLE IF EXISTS `templatecachequeries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `templatecachequeries` (
  `id` int NOT NULL AUTO_INCREMENT,
  `cacheId` int NOT NULL,
  `type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `query` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_jqepvevqjytykowxhkhlwvspwijdfyzdicpf` (`cacheId`),
  KEY `idx_gtlwaelwdscuwhsygiunzuksylugaxfimzlw` (`type`),
  CONSTRAINT `fk_ppnmcdbqmapyohmrxnyaqqmtcttkbyjfrclw` FOREIGN KEY (`cacheId`) REFERENCES `templatecaches` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `templatecaches`
--

DROP TABLE IF EXISTS `templatecaches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `templatecaches` (
  `id` int NOT NULL AUTO_INCREMENT,
  `siteId` int NOT NULL,
  `cacheKey` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `path` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `expiryDate` datetime NOT NULL,
  `body` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_iixpguexctzncrvsxibcjjpmnmvxijtwsgsd` (`cacheKey`,`siteId`,`expiryDate`,`path`),
  KEY `idx_hjtlvnoapqhsvkputntidpkhyetqfppclknj` (`cacheKey`,`siteId`,`expiryDate`),
  KEY `idx_tjbotlvlpsfasgdkwwxnacuygycapbceemlx` (`siteId`),
  CONSTRAINT `fk_ymdasnzakxhphootyorpyhhybgbansrhxcis` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tokens`
--

DROP TABLE IF EXISTS `tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tokens` (
  `id` int NOT NULL AUTO_INCREMENT,
  `token` char(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `route` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `usageLimit` tinyint unsigned DEFAULT NULL,
  `usageCount` tinyint unsigned DEFAULT NULL,
  `expiryDate` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_qztpwaapmudqbnkwvwraoeexoedtccbjrdqu` (`token`),
  KEY `idx_zqzikshpxxdlinmksdqjtgnconimsiuhwqxg` (`expiryDate`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `usergroups`
--

DROP TABLE IF EXISTS `usergroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `usergroups` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `handle` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_huzhpusxnxgabodshxjjjygdcdzxcdurqasj` (`handle`),
  KEY `idx_ugeogntrzrpaqotjitmyhkgyvfdfchrgdxgm` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `usergroups_users`
--

DROP TABLE IF EXISTS `usergroups_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `usergroups_users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `groupId` int NOT NULL,
  `userId` int NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_dowrbusneutiracqzkohplaqicrojrilpwdu` (`groupId`,`userId`),
  KEY `idx_etvzxpevnrszzkjkslpxumfdcrpuyvanrnwk` (`userId`),
  CONSTRAINT `fk_tqeyfqelsedajuhfvuvjpkeelvaklbgvzcjl` FOREIGN KEY (`groupId`) REFERENCES `usergroups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_ufiuxarbyetqqtfamzprnjpjyzmdjnbtxyud` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpermissions`
--

DROP TABLE IF EXISTS `userpermissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `userpermissions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_aereiiyffnyepooxqkkfldnauxzzwqwmzhlt` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpermissions_usergroups`
--

DROP TABLE IF EXISTS `userpermissions_usergroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `userpermissions_usergroups` (
  `id` int NOT NULL AUTO_INCREMENT,
  `permissionId` int NOT NULL,
  `groupId` int NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_ymdwslvcgofzsbcsyegksfdasxvhasrsxjwe` (`permissionId`,`groupId`),
  KEY `idx_dgmqjbmkiaryjjnkcyvvcaottfbrzdwvvaqq` (`groupId`),
  CONSTRAINT `fk_ctclmmlyydkqsijquxondywhrbssnwhghnij` FOREIGN KEY (`permissionId`) REFERENCES `userpermissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_mrkmnapatrwhcatgetzakxesaanmnycwmlbd` FOREIGN KEY (`groupId`) REFERENCES `usergroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpermissions_users`
--

DROP TABLE IF EXISTS `userpermissions_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `userpermissions_users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `permissionId` int NOT NULL,
  `userId` int NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_bagmuqidvvpyssxdnfsfjsvcfwqxlacxmuin` (`permissionId`,`userId`),
  KEY `idx_tkamnmlhlusvszqrfgtxbiggrxhvoulncboi` (`userId`),
  CONSTRAINT `fk_gvfzgbgpiahwuqkuxqxfhyhbpiuacgpalbie` FOREIGN KEY (`permissionId`) REFERENCES `userpermissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_lvvrfmzsbtonfurxxmrfmuzuuotipixzvdfj` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpreferences`
--

DROP TABLE IF EXISTS `userpreferences`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `userpreferences` (
  `userId` int NOT NULL AUTO_INCREMENT,
  `preferences` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`userId`),
  CONSTRAINT `fk_ybxqbgdriytzpndjeoctiwrcqkgwxtiktvmc` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` int NOT NULL,
  `username` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `photoId` int DEFAULT NULL,
  `firstName` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `lastName` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `password` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `admin` tinyint(1) NOT NULL DEFAULT '0',
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `suspended` tinyint(1) NOT NULL DEFAULT '0',
  `pending` tinyint(1) NOT NULL DEFAULT '0',
  `lastLoginDate` datetime DEFAULT NULL,
  `lastLoginAttemptIp` varchar(45) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `invalidLoginWindowStart` datetime DEFAULT NULL,
  `invalidLoginCount` tinyint unsigned DEFAULT NULL,
  `lastInvalidLoginDate` datetime DEFAULT NULL,
  `lockoutDate` datetime DEFAULT NULL,
  `hasDashboard` tinyint(1) NOT NULL DEFAULT '0',
  `verificationCode` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `verificationCodeIssuedDate` datetime DEFAULT NULL,
  `unverifiedEmail` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `passwordResetRequired` tinyint(1) NOT NULL DEFAULT '0',
  `lastPasswordChangeDate` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_bcegrcmosrtktlisibyhmswnsjcsembzfneq` (`uid`),
  KEY `idx_rotbptkxpvervazsetreejeshhholtknkaeq` (`verificationCode`),
  KEY `idx_sossejgquzoylimryeprgoospsaiyedjntlu` (`email`),
  KEY `idx_jkwgsixnbtyrewttitgivsfxirfpgvrgotlk` (`username`),
  KEY `fk_flspaucgjycicaidoefdqwevuohhwcurjqyl` (`photoId`),
  CONSTRAINT `fk_flspaucgjycicaidoefdqwevuohhwcurjqyl` FOREIGN KEY (`photoId`) REFERENCES `assets` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_poumizuopsjflkmbnxokduhwmswevkslkyng` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `volumefolders`
--

DROP TABLE IF EXISTS `volumefolders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumefolders` (
  `id` int NOT NULL AUTO_INCREMENT,
  `parentId` int DEFAULT NULL,
  `volumeId` int DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `path` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_tgahgejizwbjusajqmmzhqagivafjihbztij` (`name`,`parentId`,`volumeId`),
  KEY `idx_mjtwgifecjpszuiconqfewgpacezyuwjqdec` (`parentId`),
  KEY `idx_azrodqonlteezzmprqlnbtuyarogyutgkxsm` (`volumeId`),
  CONSTRAINT `fk_kvyscyiwysrvxapizsvelzinpirrvyvypkxp` FOREIGN KEY (`parentId`) REFERENCES `volumefolders` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_vauhgjtsapmzakucqtkpksegbnstzahhfwdp` FOREIGN KEY (`volumeId`) REFERENCES `volumes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `fieldLayoutId` int DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `handle` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `hasUrls` tinyint(1) NOT NULL DEFAULT '1',
  `url` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `titleTranslationMethod` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT 'site',
  `titleTranslationKeyFormat` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `settings` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `sortOrder` smallint unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_tvolabkhlssmkixhetxbwjiefehlosaegogr` (`name`),
  KEY `idx_bwboxxpmombbsfggpgexmpqcbljgqzskwicw` (`handle`),
  KEY `idx_ilaufzbvljuvzbuqejafqaoxfimbqtppqphk` (`fieldLayoutId`),
  KEY `idx_urppbwljdolcjciorxvjtwhyzxdirfwbaypo` (`dateDeleted`),
  CONSTRAINT `fk_ehpqrkmkqzaldtzcybltvwwqxjroolrcyavp` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` int NOT NULL AUTO_INCREMENT,
  `userId` int NOT NULL,
  `type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `sortOrder` smallint unsigned DEFAULT NULL,
  `colspan` tinyint DEFAULT NULL,
  `settings` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_zujdxjamgzxplzqmtbdrdrfcvelqgmkquwsc` (`userId`),
  CONSTRAINT `fk_iirpiiqfblaequxoeoxjokasglknommgqksy` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping routines for database 'addons_wvtrust'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-04-25 22:35:53
-- MySQL dump 10.13  Distrib 8.0.33, for Linux (x86_64)
--
-- Host: 127.0.0.1    Database: addons_wvtrust
-- ------------------------------------------------------
-- Server version	8.0.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `assets` VALUES (49,1,3,1,'logo.svg','image',1485,1446,102286,NULL,NULL,NULL,'2022-07-04 04:01:56','2022-07-04 04:01:56','2022-07-04 04:01:56','aa8ef0d6-d9d4-40db-9e51-22c5cca591ca'),(145,2,4,1,'mainpage.jpg','image',1000,397,76093,NULL,0,0,'2022-10-29 07:08:20','2022-10-29 07:08:20','2022-10-29 07:08:20','96f3ba4b-9dd3-47c8-8d7a-f9f6baff75fc'),(200,2,4,1,'Unit-D.jpg','image',693,225,55151,NULL,NULL,NULL,'2022-12-01 07:21:46','2022-12-01 07:21:46','2022-12-01 07:22:06','d906e614-5783-4b6e-baeb-9e8687112e25'),(205,2,8,1,'Unit-D.jpg','image',693,225,55151,NULL,NULL,NULL,'2022-12-01 07:51:00','2022-12-01 07:51:00','2022-12-01 07:51:00','a3cc6a8a-37a2-4c81-aa78-098e2b483045');
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `assettransforms`
--

LOCK TABLES `assettransforms` WRITE;
/*!40000 ALTER TABLE `assettransforms` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `assettransforms` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `categorygroups`
--

LOCK TABLES `categorygroups` WRITE;
/*!40000 ALTER TABLE `categorygroups` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `categorygroups` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `categorygroups_sites`
--

LOCK TABLES `categorygroups_sites` WRITE;
/*!40000 ALTER TABLE `categorygroups_sites` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `categorygroups_sites` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `changedattributes`
--

LOCK TABLES `changedattributes` WRITE;
/*!40000 ALTER TABLE `changedattributes` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `changedattributes` VALUES (76,1,'authorId','2022-07-07 05:44:53',0,1),(76,1,'slug','2022-07-07 05:43:02',0,1),(76,1,'title','2022-08-04 02:46:56',0,1),(76,1,'uri','2022-07-07 05:47:44',0,1),(78,1,'authorId','2022-07-07 05:44:54',0,1),(78,1,'uri','2022-07-07 05:44:54',0,1),(130,1,'fieldLayoutId','2022-10-29 07:10:22',0,1),(130,1,'slug','2022-11-30 03:54:14',0,1),(130,1,'title','2022-11-30 03:35:20',0,1),(130,1,'typeId','2022-10-29 07:10:22',0,1),(130,1,'uri','2022-10-29 06:08:59',0,1),(132,1,'slug','2022-11-30 03:53:59',0,1),(132,1,'title','2022-11-30 03:33:27',0,1),(132,1,'uri','2022-10-29 06:08:59',0,1),(199,1,'slug','2022-12-01 07:17:54',0,1),(199,1,'title','2022-12-01 07:17:54',0,1),(199,1,'uri','2022-12-01 07:17:54',0,1),(217,1,'enabled','2023-04-25 01:55:40',0,1);
/*!40000 ALTER TABLE `changedattributes` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `changedfields`
--

LOCK TABLES `changedfields` WRITE;
/*!40000 ALTER TABLE `changedfields` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `changedfields` VALUES (2,1,1,'2022-11-30 04:49:18',0,1),(2,1,3,'2023-01-19 15:27:32',0,1),(15,1,4,'2022-07-05 02:12:53',0,1),(15,1,5,'2022-08-05 02:17:34',0,1),(15,1,6,'2022-07-04 04:35:25',0,1),(32,1,2,'2023-04-18 05:25:56',0,1),(76,1,2,'2023-04-19 03:21:49',0,1),(78,1,2,'2022-07-07 05:44:54',0,1),(90,1,4,'2022-07-07 05:48:34',0,1),(90,1,6,'2022-08-30 05:09:24',0,1),(132,1,2,'2022-12-01 07:51:27',0,1),(132,1,11,'2022-12-01 07:51:27',0,1),(132,1,15,'2022-12-01 07:51:27',0,1),(188,1,13,'2022-12-01 07:51:27',0,1),(199,1,2,'2023-02-16 07:39:05',0,1),(214,1,11,'2023-04-25 01:57:11',0,1),(215,1,13,'2023-04-25 01:57:04',0,1),(215,1,14,'2023-04-25 01:57:11',0,1),(216,1,1,'2023-04-25 01:56:15',0,1),(216,1,3,'2023-04-25 01:55:40',0,1),(217,1,5,'2023-04-25 01:55:03',0,1),(218,1,6,'2023-04-19 02:24:04',0,1),(221,1,11,'2023-04-19 02:38:45',0,1);
/*!40000 ALTER TABLE `changedfields` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `content`
--

LOCK TABLES `content` WRITE;
/*!40000 ALTER TABLE `content` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `content` VALUES (1,1,1,NULL,'2022-07-04 01:44:27','2022-07-04 01:44:27','2c0d42c4-e902-4a88-b0ce-58846a8f52dd',NULL,NULL),(2,2,1,'Homepage','2022-07-04 02:21:22','2023-01-19 15:27:32','25a56c94-62e4-4d10-b923-407fd3017bde','<br />\n<figure><div class=\"row\">\n <div class=\"col-md-3\">\n<img src=\"{asset:49:url||https://wvtrust.atweb.space/images/uploads/homepage/logo.svg}\" class=\"image-fluid\" alt=\"111 Wellness Space\" /></div>\n</div></figure>',NULL),(3,3,1,'Homepage','2022-07-04 02:21:22','2022-07-04 02:21:22','42e5651c-5883-4fe6-9779-287c6ed7363a',NULL,NULL),(4,4,1,'Homepage','2022-07-04 02:27:09','2022-07-04 02:27:09','575a8527-7483-4fbc-a331-242dc565923b',NULL,NULL),(6,6,1,'Homepage','2022-07-04 02:27:32','2022-07-04 02:27:32','ec4286a5-e361-48ab-97da-514c89050e37','<p>This is my basic introduction</p>',NULL),(8,8,1,'Homepage','2022-07-04 03:01:54','2022-07-04 03:01:54','613d6c09-2393-4306-bca1-685fc7a047d2','<p>WV Trust. Home Page <br /></p>',NULL),(9,9,1,'Homepage','2022-07-04 03:07:06','2022-07-04 03:07:06','1da5a7d1-31fd-4e56-a26d-0ac3b9933108','<p>WV Trust. Home Page <br /></p>',NULL),(11,16,1,'Homepage','2022-07-04 03:07:53','2022-07-04 03:07:53','b7963c85-b3e9-4179-94a9-15f45aa0a774','<p>WV Trust. Home Page <br /></p>',NULL),(13,20,1,'Homepage','2022-07-04 03:22:10','2022-07-04 03:22:10','52b1daf1-b578-4449-863d-406c9a5c9079','<p>WV Trust. Home Page <br /></p>',NULL),(15,24,1,'Homepage','2022-07-04 03:25:00','2022-07-04 03:25:00','60108579-7ba2-41c6-9b95-de88d037b759','<p>WV Trust. Home Page <br /></p>',NULL),(17,28,1,'Homepage','2022-07-04 03:33:42','2022-07-04 03:33:42','8512d010-ea81-4c4f-8f76-e26e8ed9167d','<p>WV Trust. Home Page <br /></p>',NULL),(18,30,1,'ContentPage','2022-07-04 03:42:17','2022-07-04 03:42:17','4fc4835d-9c92-4a00-b2d4-bda15ba824b5',NULL,NULL),(19,31,1,'ContentPage','2022-07-04 03:42:17','2022-07-04 03:42:17','e9bdb396-aefd-4dfc-a418-470f48cf58cc',NULL,NULL),(20,32,1,'Maintainece','2022-07-04 03:47:00','2023-04-18 05:25:56','3eb9ccfd-b1c5-4e67-973b-77388798c90f',NULL,'<p>Repair and Maintenance Issues</p>\n<p> Send Email to admin AT \"wesvault.com\" with \n </p>\n<p><br /></p>\n<ol>\n <li>What is the issue?</li>\n <li>Where is the problem, area of the property?<br />- Unit and rough area where <br /></li>\n <li>How it happen?<ol><li>When was it discovered<br /></li></ol></li>\n <li>Include pictures</li><li>Add olivers contact<br /></li>\n </ol>'),(23,46,1,'Homepage','2022-07-04 03:49:16','2022-07-04 03:49:16','394d6136-2820-4050-af3a-54bb8950a2ff','<p>WV Trust. Home Page <br /></p>',NULL),(24,49,1,'Logo','2022-07-04 04:01:56','2022-07-04 04:01:56','4b1bd5db-4869-4fba-a8cc-2b6257ea0c96',NULL,NULL),(26,53,1,'Homepage','2022-07-04 04:03:28','2022-07-04 04:03:28','b9b21127-b006-4d4a-85da-bd125f21878c','<p>WV Trust. Home Page <br /></p>\n<figure><div class=\"row\">\n <div class=\"col-md-4\">\n<img src=\"{asset:49:url||http://wvtrust.atweb.space/images/uploads/homepage/logo.svg}\" alt=\"111 Wellness Space\" /></div></div></figure>',NULL),(28,59,1,'Homepage','2022-07-04 04:04:15','2022-07-04 04:04:15','935ef3f0-3275-4f84-aa52-266872722b19','<p>Our Brands <br /></p>\n<figure><div class=\"row\">\n <div class=\"col-md-6\">\n<img src=\"{asset:49:url||http://wvtrust.atweb.space/images/uploads/homepage/logo.svg}\" alt=\"111 Wellness Space\" /></div>\n</div>\n</figure>',NULL),(30,65,1,'Homepage','2022-07-04 04:35:25','2022-07-04 04:35:25','a19ec96b-a604-4366-bca3-122ce7391bb1','<p>Our Brands <br /></p>\n<figure><div class=\"row\">\n <div class=\"col-md-6\">\n<img src=\"{asset:49:url||http://wvtrust.atweb.space/images/uploads/homepage/logo.svg}\" alt=\"111 Wellness Space\" /></div>\n</div>\n</figure>',NULL),(33,72,1,'Homepage','2022-07-05 02:12:53','2022-07-05 02:12:53','201340e4-f98e-459a-a774-dece443950f2','<p>Our Brands <br /></p>\n<figure><div class=\"row\">\n <div class=\"col-md-6\">\n<img src=\"{asset:49:url||http://wvtrust.atweb.space/images/uploads/homepage/logo.svg}\" alt=\"111 Wellness Space\" /></div>\n</div></figure>',NULL),(35,76,1,'Billing Information For WV Trust','2022-07-07 05:39:33','2023-04-19 03:21:49','555de854-b361-4f4e-90da-e00ee46af360',NULL,'<h4>Our Billing Information</h4>\n<p><br /></p>\n<p><strong>WESVAULT HOLDINGS PTY LTD</strong><br />ATF THE WV REALTY TRUST<br /></p>\n<p>5 RIVERS ST<br />BIBRA LAKE WA 6163 <br /></p>\n<p><strong><br /></strong></p>\n<p><strong>Via Email:<br /></strong><br />1) <br /></p>\n<p>Email- admin \'AT\' wesvault.com <br /></p>\n<p>2) Due to high spam virus levels, please put \"WVTrust Invoice\"<br /></p>\n<p>Subject: WVTrust Invoice - [subject]<br /><br />3) Attn: Jenn</p>\n<p><strong><br /></strong><strong>Include the following information</strong></p>\n<ol><li>Property Address</li><li>Unit if available <br /></li><li>Invoice</li><li>Type [repair / admin / others] <br /><br /><br /></li></ol>\n<p>We pay every Tuesday</p>\n<p><strong><br /></strong></p>\n<p><strong>Hotmail/Microsoft/Outlook Issue For Invoicing</strong></p>\n<p>If you are not getting our invoices. </p>\n<ul>\n<li>Click on \"<strong>Options</strong>\" in the upper right corner of your Hotmail screen.</li>\n<li>Then click the link for \"<strong>Safe and Blocked Senders</strong>\" in the body of the page under Junk e-mail.</li>\n<li>Click the \"<strong>Safe Senders</strong>\" link and enter the email address you want to whitelist.</li>\n<li>Click \"<strong>Add</strong>\" to put it on your list.</li>\n</ul>'),(36,77,1,'Billing Information','2022-07-07 05:43:54','2022-07-07 05:43:54','edf504ca-0dc6-4ff1-9d16-e5a825d77423',NULL,'<p><strong>Our Billing Information </strong></p>\n<p>WESVAULT HOLDINGS PTY LTD<br />ATF THE WV REALTY TRUST<br /></p>\n<p>5 RIVERS ST<br />BIBRA LAKE WA 6163</p>\n<p><strong>Via Email:</strong><br /><br />admin \'AT\' wesvault.com <br />Subject: Invoice [subject]<br /><strong><br />Include the following information</strong></p><ol><li>Property Address</li><li>Unit if available <br /></li><li>Invoice</li><li>Type [repair / admin / others] <br /></li></ol>\n\n<p>We pay every Tuesday. </p>'),(37,78,1,NULL,'2022-07-07 05:44:03','2022-07-07 05:44:54','5e99c70e-57c9-4be2-8c7f-79b4f1e498ce',NULL,NULL),(38,79,1,'Billing Information','2022-07-07 05:44:53','2022-07-07 05:44:53','37fefecf-fa7b-4444-a70f-de559f66e1b3',NULL,'<p><strong>Our Billing Information </strong></p>\n<p>WESVAULT HOLDINGS PTY LTD<br />ATF THE WV REALTY TRUST<br /></p>\n<p>5 RIVERS ST<br />BIBRA LAKE WA 6163</p>\n<p><strong>Via Email:</strong><br /><br />admin \'AT\' wesvault.com <br />Subject: Invoice [subject]<br /><strong><br />Include the following information</strong></p><ol><li>Property Address</li><li>Unit if available <br /></li><li>Invoice</li><li>Type [repair / admin / others] <br /></li></ol>\n\n<p>We pay every Tuesday. </p>'),(40,81,1,'Billing Information','2022-07-07 05:45:10','2022-07-07 05:45:10','91557567-a9d6-490b-8013-1590d00b61c5',NULL,'<p><strong>Our Billing Information </strong></p>\n<p>WESVAULT HOLDINGS PTY LTD<br />ATF THE WV REALTY TRUST<br /></p>\n<p>5 RIVERS ST<br />BIBRA LAKE WA 6163</p>\n<p><strong>Via Email:</strong><br /><br />admin \'AT\' wesvault.com <br />Subject: Invoice [subject]<br /><strong><br />Include the following information</strong></p>\n<ol><li>Property Address</li><li>Unit if available <br /></li><li>Invoice</li><li>Type [repair / admin / others] <br /></li></ol>\n<p>We pay every Tuesday. </p>'),(42,91,1,'Homepage','2022-07-07 05:45:36','2022-07-07 05:45:36','dbb1eec9-2756-459f-b78e-9e3da34149d3','<p>Our Brands <br /></p>\n<figure><div class=\"row\">\n <div class=\"col-md-6\">\n<img src=\"{asset:49:url||http://wvtrust.atweb.space/images/uploads/homepage/logo.svg}\" alt=\"111 Wellness Space\" /></div>\n</div></figure>',NULL),(44,96,1,'Billing Information','2022-07-07 05:46:27','2022-07-07 05:46:27','dca57ea7-58e6-476d-9e2a-1c10b457a228',NULL,'<p><strong>Our Billing Information </strong></p>\n<p>WESVAULT HOLDINGS PTY LTD<br />ATF THE WV REALTY TRUST<br /></p>\n<p>5 RIVERS ST<br />BIBRA LAKE WA 6163</p>\n<p><strong>Via Email:</strong><br /><br />admin \'AT\' wesvault.com <br />Subject: Invoice [subject]<br /><strong><br />Include the following information</strong></p>\n<ol><li>Property Address</li><li>Unit if available <br /></li><li>Invoice</li><li>Type [repair / admin / others] <br /></li></ol>\n<p>We pay every Tuesday. </p>'),(45,97,1,'Billing Information','2022-07-07 05:47:44','2022-07-07 05:47:44','482461c8-6e51-4ba7-9d10-a42208681e39',NULL,'<h4>Our Billing Information </h4>\n<p><br /></p>\n<p>WESVAULT HOLDINGS PTY LTD<br />ATF THE WV REALTY TRUST<br /></p>\n<p>5 RIVERS ST<br />BIBRA LAKE WA 6163</p>\n<p><strong><br /></strong></p>\n<p><strong>Via Email:</strong><br /><br />admin \'AT\' wesvault.com <br />Subject: Invoice [subject]<br /><strong><br /></strong></p>\n<p><strong><br /></strong></p>\n<p><strong>Include the following information</strong></p>\n<ol><li>Property Address</li><li>Unit if available <br /></li><li>Invoice</li><li>Type [repair / admin / others] <br /></li></ol>\n<p>We pay every Tuesday. </p>'),(47,102,1,'Homepage','2022-07-07 05:48:34','2022-07-07 05:48:34','f5446902-e2e6-493b-a9da-c8ca8732b7b6','<p>Our Brands <br /></p>\n<figure><div class=\"row\">\n <div class=\"col-md-6\">\n<img src=\"{asset:49:url||http://wvtrust.atweb.space/images/uploads/homepage/logo.svg}\" alt=\"111 Wellness Space\" /></div>\n</div></figure>',NULL),(49,107,1,'Billing Information For WV Trust','2022-08-04 02:46:56','2022-08-04 02:46:56','629ccb95-6b2e-4953-abb2-2b631f04c6e1',NULL,'<h4>Our Billing Information </h4>\n<p><br /></p>\n<p><strong>WESVAULT HOLDINGS PTY LTD</strong><br />ATF THE WV REALTY TRUST<br /></p>\n<p>5 RIVERS ST<br />BIBRA LAKE WA 6163</p>\n<p><strong><br /></strong></p>\n<p><strong>Via Email:<br /></strong><br />1)</p>\n<p>Email- admin \'AT\' wesvault.com <br /></p>\n<p>2) Due to high spam virus levels, please put \"WVTrust Invoice\"<br /></p>\n<p>Subject: WVTrust Invoice - [subject]<br /><br />3) Attn: Jenn</p>\n<p><strong><br /></strong><strong>Include the following information</strong></p>\n\n\n<ol><li>Property Address</li><li>Unit if available <br /></li><li>Invoice</li><li>Type [repair / admin / others] <br /><br /><br /></li></ol>\n<p>We pay every Tuesday </p>'),(51,112,1,'Homepage','2022-08-05 02:17:34','2022-08-05 02:17:34','71cc2aed-bdff-4df3-8e5c-df1900fc9685','<p>Our Brands <br /></p>\n<figure><div class=\"row\">\n <div class=\"col-md-6\">\n<img src=\"{asset:49:url||http://wvtrust.atweb.space/images/uploads/homepage/logo.svg}\" alt=\"111 Wellness Space\" /></div>\n</div></figure>',NULL),(54,121,1,'Homepage','2022-08-30 05:09:24','2022-08-30 05:09:24','468b4f25-20f3-4c9f-8390-de847e1c27c6','<p>Our Brands <br /></p>\n<figure><div class=\"row\">\n <div class=\"col-md-6\">\n<img src=\"{asset:49:url||http://wvtrust.atweb.space/images/uploads/homepage/logo.svg}\" alt=\"111 Wellness Space\" /></div>\n</div></figure>',NULL),(56,129,1,'Billing Information For WV Trust','2022-10-12 01:46:56','2022-10-12 01:46:56','91654744-9ed1-4549-b06f-80d45ce0c5de',NULL,'<h4>Our Billing Information</h4>\n<p><br /></p>\n<p><strong>WESVAULT HOLDINGS PTY LTD</strong><br />ATF THE WV REALTY TRUST<br /></p>\n<p>5 RIVERS ST<br />BIBRA LAKE WA 6163</p>\n<p><strong><br /></strong></p>\n<p><strong>Via Email:<br /></strong><br />1)</p>\n<p>Email- admin \'AT\' wesvault.com <br /></p>\n<p>2) Due to high spam virus levels, please put \"WVTrust Invoice\"<br /></p>\n<p>Subject: WVTrust Invoice - [subject]<br /><br />3) Attn: Jenn</p>\n<p><strong><br /></strong><strong>Include the following information</strong></p>\n<ol><li>Property Address</li><li>Unit if available <br /></li><li>Invoice</li><li>Type [repair / admin / others] <br /><br /><br /></li></ol>\n<p>We pay every Tuesday</p>\n<p><strong><br /></strong></p>\n<p><strong>Hotmail/Microsoft/Outlook Issue For Invoicing</strong></p>\n<p>If you are not getting our invoices. </p><ul>\n<li>Click on \"<strong>Options</strong>\" in the upper right corner of your Hotmail screen.</li>\n<li>Then click the link for \"<strong>Safe and Blocked Senders</strong>\" in the body of the page under Junk e-mail.</li>\n<li>Click the \"<strong>Safe Senders</strong>\" link and enter the email address you want to whitelist.</li>\n<li>Click \"<strong>Add</strong>\" to put it on your list.</li>\n</ul>'),(57,130,1,'1/5 Nasmyth Road, Rockingham','2022-10-29 06:06:57','2022-11-30 03:54:14','97d5b158-7b96-404a-a642-368dab91dbea',NULL,NULL),(58,131,1,'South','2022-10-29 06:07:07','2022-10-29 06:07:07','9420fd03-08df-4e6c-9ac8-6aafcc84aeb2',NULL,NULL),(59,132,1,'111 Medina Avenue, Medina','2022-10-29 06:07:11','2022-12-01 07:51:27','49b7e770-d94b-4bc0-a450-e1fc603364b9',NULL,'<p>Medina<br /></p>'),(60,133,1,'More South','2022-10-29 06:07:29','2022-10-29 06:07:29','f66a8488-e688-4bac-b58f-3a1143b10625',NULL,NULL),(62,145,1,'Mainpage','2022-10-29 07:08:20','2022-10-29 07:08:20','3b127c14-333f-4ad7-97ef-be6eade458b1',NULL,NULL),(66,159,1,'Homepage','2022-11-30 03:41:26','2022-11-30 03:41:26','384c5fa6-f240-4145-9618-8500abcaa580','<p>Our Brands <br /></p>\n<figure><div class=\"row\">\n <div class=\"col-md-6\">\n<img src=\"{asset:49:url||http://wvtrust.atweb.space/images/uploads/homepage/logo.svg}\" class=\"image-fluid\" alt=\"111 Wellness Space\" /></div>\n</div></figure>',NULL),(68,167,1,'Homepage','2022-11-30 03:41:53','2022-11-30 03:41:53','12e4565e-e1e5-491e-8bfe-6270762149d4','<p>Our Brands <br /></p>\n<figure><div class=\"row\">\n <div class=\"col-md-3\">\n<img src=\"{asset:49:url||http://wvtrust.atweb.space/images/uploads/homepage/logo.svg}\" class=\"image-fluid\" alt=\"111 Wellness Space\" /></div>\n</div></figure>',NULL),(75,195,1,'Homepage','2022-11-30 04:49:18','2022-11-30 04:49:18','e80c75ee-8904-411a-813f-59a6e1fa1a97','<br />\n<figure><div class=\"row\">\n <div class=\"col-md-3\">\n<img src=\"{asset:49:url||http://wvtrust.atweb.space/images/uploads/homepage/logo.svg}\" class=\"image-fluid\" alt=\"111 Wellness Space\" /></div>\n</div></figure>',NULL),(76,199,1,'1/5 Nasmyth, Rockingham','2022-12-01 07:17:31','2023-02-16 07:39:05','ec8dd67d-9031-4d4d-b480-56b04b080fc9',NULL,'<p>This is a property</p>'),(77,200,1,'111 Medina Ave','2022-12-01 07:21:46','2022-12-01 07:22:06','309712b0-5703-4d51-ac89-d6f9c4fa5bf7',NULL,NULL),(80,205,1,'Unit D','2022-12-01 07:51:00','2022-12-01 07:51:00','2598f850-db09-4f28-9d19-f90c018c5ef6',NULL,NULL),(82,210,1,'Homepage','2023-01-19 15:27:32','2023-01-19 15:27:32','a5c54e48-d4e3-4c30-be3f-c3d6a2ef8bf0','<br />\n<figure><div class=\"row\">\n <div class=\"col-md-3\">\n<img src=\"{asset:49:url||https://wvtrust.atweb.space/images/uploads/homepage/logo.svg}\" class=\"image-fluid\" alt=\"111 Wellness Space\" /></div>\n</div></figure>',NULL),(84,214,1,'1/5 Nasmyth, Rockingham','2023-02-16 07:39:27','2023-04-25 01:57:11','41c414a8-2642-46e7-99f2-7dc15db7a9e3',NULL,'<p>This is a property</p>'),(85,216,1,'Homepage','2023-03-14 04:04:27','2023-04-25 01:56:15','41bda0a2-d1c7-42f1-bd2b-a4f27deab8a0','<p>These are our brands<br /></p>\n<figure><div class=\"row\">\n <div class=\"col-md-3\">\n<img src=\"{asset:49:url||https://wvtrust.atweb.space/images/uploads/homepage/logo.svg}\" class=\"image-fluid\" alt=\"111 Wellness Space\" /></div>\n</div></figure>',NULL),(88,221,1,'111 Medina Avenue, Medina','2023-04-19 02:38:45','2023-04-19 02:38:45','93f10b3d-1299-478c-8ffd-a1e4bb98f097',NULL,'<p>Medina<br /></p>'),(89,224,1,'Billing Information For WV Trust','2023-04-19 03:21:49','2023-04-19 03:21:49','9e0d00e4-012e-4d23-86ed-4e507936f1e8',NULL,'<h4>Our Billing Information</h4>\n<p><br /></p>\n<p><strong>WESVAULT HOLDINGS PTY LTD</strong><br />ATF THE WV REALTY TRUST<br /></p>\n<p>5 RIVERS ST<br />BIBRA LAKE WA 6163 <br /></p>\n<p><strong><br /></strong></p>\n<p><strong>Via Email:<br /></strong><br />1) <br /></p>\n<p>Email- admin \'AT\' wesvault.com <br /></p>\n<p>2) Due to high spam virus levels, please put \"WVTrust Invoice\"<br /></p>\n<p>Subject: WVTrust Invoice - [subject]<br /><br />3) Attn: Jenn</p>\n<p><strong><br /></strong><strong>Include the following information</strong></p>\n<ol><li>Property Address</li><li>Unit if available <br /></li><li>Invoice</li><li>Type [repair / admin / others] <br /><br /><br /></li></ol>\n<p>We pay every Tuesday</p>\n<p><strong><br /></strong></p>\n<p><strong>Hotmail/Microsoft/Outlook Issue For Invoicing</strong></p>\n<p>If you are not getting our invoices. </p>\n<ul>\n<li>Click on \"<strong>Options</strong>\" in the upper right corner of your Hotmail screen.</li>\n<li>Then click the link for \"<strong>Safe and Blocked Senders</strong>\" in the body of the page under Junk e-mail.</li>\n<li>Click the \"<strong>Safe Senders</strong>\" link and enter the email address you want to whitelist.</li>\n<li>Click \"<strong>Add</strong>\" to put it on your list.</li>\n</ul>');
/*!40000 ALTER TABLE `content` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `craftidtokens`
--

LOCK TABLES `craftidtokens` WRITE;
/*!40000 ALTER TABLE `craftidtokens` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `craftidtokens` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `deprecationerrors`
--

LOCK TABLES `deprecationerrors` WRITE;
/*!40000 ALTER TABLE `deprecationerrors` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `deprecationerrors` VALUES (1,'includeCssFile','/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Parser.php:184','2022-10-29 05:59:41','/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Parser.php',184,'`{% includeCssFile` %} is now deprecated. Use `{% css \"/url/to/file.css\" %}` instead.','[{\"objectClass\":\"craft\\\\services\\\\Deprecator\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/twig/tokenparsers/RegisterResourceTokenParser.php\",\"line\":89,\"class\":\"craft\\\\services\\\\Deprecator\",\"method\":\"log\",\"args\":\"\\\"includeCssFile\\\", \\\"`{% includeCssFile` %} is now deprecated. Use `{% css \\\"/url/to/f...\\\"\"},{\"objectClass\":\"craft\\\\web\\\\twig\\\\tokenparsers\\\\RegisterResourceTokenParser\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Parser.php\",\"line\":184,\"class\":\"craft\\\\web\\\\twig\\\\tokenparsers\\\\RegisterResourceTokenParser\",\"method\":\"parse\",\"args\":\"Twig\\\\Token\"},{\"objectClass\":\"Twig\\\\Parser\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Parser.php\",\"line\":97,\"class\":\"Twig\\\\Parser\",\"method\":\"subparse\",\"args\":\"null, false\"},{\"objectClass\":\"Twig\\\\Parser\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Environment.php\",\"line\":562,\"class\":\"Twig\\\\Parser\",\"method\":\"parse\",\"args\":\"Twig\\\\TokenStream\"},{\"objectClass\":\"craft\\\\web\\\\twig\\\\Environment\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Environment.php\",\"line\":594,\"class\":\"Twig\\\\Environment\",\"method\":\"parse\",\"args\":\"Twig\\\\TokenStream\"},{\"objectClass\":\"craft\\\\web\\\\twig\\\\Environment\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/twig/Environment.php\",\"line\":60,\"class\":\"Twig\\\\Environment\",\"method\":\"compileSource\",\"args\":\"Twig\\\\Source\"},{\"objectClass\":\"craft\\\\web\\\\twig\\\\Environment\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Environment.php\",\"line\":408,\"class\":\"craft\\\\web\\\\twig\\\\Environment\",\"method\":\"compileSource\",\"args\":\"Twig\\\\Source\"},{\"objectClass\":\"craft\\\\web\\\\twig\\\\Environment\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Environment.php\",\"line\":381,\"class\":\"Twig\\\\Environment\",\"method\":\"loadClass\",\"args\":\"\\\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7...\\\", \\\"layouts/_main.twig\\\", null\"},{\"objectClass\":\"craft\\\\web\\\\twig\\\\Environment\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/twig/Environment.php\",\"line\":41,\"class\":\"Twig\\\\Environment\",\"method\":\"loadTemplate\",\"args\":\"\\\"layouts/_main.twig\\\", null\"},{\"objectClass\":\"craft\\\\web\\\\twig\\\\Environment\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":333,\"class\":\"craft\\\\web\\\\twig\\\\Environment\",\"method\":\"loadTemplate\",\"args\":\"\\\"layouts/_main.twig\\\", null\"},{\"objectClass\":\"__TwigTemplate_d48de2043bb44f9870f707cf5c09b356170e2d3aa584341c699e275c23d3aa71\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/06/065fbba7d99f48d7b183095e6de3a525f3e62d9dbc77db24a07b91683fdd1a66.php\",\"line\":42,\"class\":\"Twig\\\\Template\",\"method\":\"loadTemplate\",\"args\":\"\\\"layouts/_main.twig\\\", \\\"property\\\", 1\"},{\"objectClass\":\"__TwigTemplate_d48de2043bb44f9870f707cf5c09b356170e2d3aa584341c699e275c23d3aa71\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_d48de2043bb44f9870f707cf5c09b356170e2d3aa584341c699e275c23d3aa71\",\"method\":\"doDisplay\",\"args\":\"[\\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, \\\"currentUser\\\" => craft\\\\elements\\\\User, \\\"siteName\\\" => \\\"WV Trust\\\", ...], [\\\"content\\\" => [__TwigTemplate_d48de2043bb44f9870f707cf5c09b356170e2d3aa584341c699e275c23d3aa71, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d48de2043bb44f9870f707cf5c09b356170e2d3aa584341c699e275c23d3aa71\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, \\\"currentUser\\\" => craft\\\\elements\\\\User, \\\"siteName\\\" => \\\"WV Trust\\\", ...], [\\\"content\\\" => [__TwigTemplate_d48de2043bb44f9870f707cf5c09b356170e2d3aa584341c699e275c23d3aa71, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d48de2043bb44f9870f707cf5c09b356170e2d3aa584341c699e275c23d3aa71\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":390,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[]\"},{\"objectClass\":\"__TwigTemplate_d48de2043bb44f9870f707cf5c09b356170e2d3aa584341c699e275c23d3aa71\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/TemplateWrapper.php\",\"line\":45,\"class\":\"Twig\\\\Template\",\"method\":\"render\",\"args\":\"[], []\"},{\"objectClass\":\"Twig\\\\TemplateWrapper\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Environment.php\",\"line\":318,\"class\":\"Twig\\\\TemplateWrapper\",\"method\":\"render\",\"args\":\"[]\"},{\"objectClass\":\"craft\\\\web\\\\twig\\\\Environment\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":408,\"class\":\"Twig\\\\Environment\",\"method\":\"render\",\"args\":\"\\\"property\\\", []\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":461,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderTemplate\",\"args\":\"\\\"property\\\", []\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Controller.php\",\"line\":201,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderPageTemplate\",\"args\":\"\\\"property\\\", [], \\\"site\\\"\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/controllers/TemplatesController.php\",\"line\":102,\"class\":\"craft\\\\web\\\\Controller\",\"method\":\"renderTemplate\",\"args\":\"\\\"property\\\", []\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":null,\"line\":null,\"class\":\"craft\\\\controllers\\\\TemplatesController\",\"method\":\"actionRender\",\"args\":\"\\\"property\\\", []\"},{\"objectClass\":null,\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/InlineAction.php\",\"line\":57,\"class\":null,\"method\":\"call_user_func_array\",\"args\":\"[craft\\\\controllers\\\\TemplatesController, \\\"actionRender\\\"], [\\\"property\\\", []]\"},{\"objectClass\":\"yii\\\\base\\\\InlineAction\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Controller.php\",\"line\":178,\"class\":\"yii\\\\base\\\\InlineAction\",\"method\":\"runWithParams\",\"args\":\"[\\\"template\\\" => \\\"property\\\", \\\"p\\\" => \\\"property/\\\"]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Module.php\",\"line\":552,\"class\":\"yii\\\\base\\\\Controller\",\"method\":\"runAction\",\"args\":\"\\\"render\\\", [\\\"template\\\" => \\\"property\\\", \\\"p\\\" => \\\"property/\\\"]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":293,\"class\":\"yii\\\\base\\\\Module\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"property\\\", \\\"p\\\" => \\\"property/\\\"]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/web/Application.php\",\"line\":103,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"property\\\", \\\"p\\\" => \\\"property/\\\"]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":278,\"class\":\"yii\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Application.php\",\"line\":384,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/web/index.php\",\"line\":12,\"class\":\"yii\\\\base\\\\Application\",\"method\":\"run\",\"args\":null}]','2022-10-29 05:59:41','2022-10-29 05:59:41','34dbcd17-fa34-4f5b-acd0-892448f42a63'),(6,'ElementQuery::getIterator()','/home/addons/atweb.space/sub/wvtrust/cms/templates/index.twig:17','2022-07-04 03:27:36','/home/addons/atweb.space/sub/wvtrust/cms/templates/index.twig',17,'Looping through element queries directly has been deprecated. Use the `all()` function to fetch the query results before looping over them.','[{\"objectClass\":\"craft\\\\services\\\\Deprecator\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/elements/db/ElementQuery.php\",\"line\":605,\"class\":\"craft\\\\services\\\\Deprecator\",\"method\":\"log\",\"args\":\"\\\"ElementQuery::getIterator()\\\", \\\"Looping through element queries directly has been deprecated. Us...\\\"\"},{\"objectClass\":\"craft\\\\elements\\\\db\\\\MatrixBlockQuery\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/b9/b96eebe1127cc0fea3f9fb125cc1b63185884cb90f9deed117244fbc533a3951.php\",\"line\":78,\"class\":\"craft\\\\elements\\\\db\\\\ElementQuery\",\"method\":\"getIterator\",\"args\":null},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":182,\"class\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"method\":\"block_content\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/d1/d1e3f93dfb9c550cb38f749be29bbc3d4a90ba76876797e7fcec55d6e6726ba4.php\",\"line\":67,\"class\":\"Twig\\\\Template\",\"method\":\"displayBlock\",\"args\":\"\\\"content\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/b9/b96eebe1127cc0fea3f9fb125cc1b63185884cb90f9deed117244fbc533a3951.php\",\"line\":43,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":390,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/TemplateWrapper.php\",\"line\":45,\"class\":\"Twig\\\\Template\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], []\"},{\"objectClass\":\"Twig\\\\TemplateWrapper\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Environment.php\",\"line\":318,\"class\":\"Twig\\\\TemplateWrapper\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\twig\\\\Environment\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":408,\"class\":\"Twig\\\\Environment\",\"method\":\"render\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":461,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Controller.php\",\"line\":201,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderPageTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], \\\"site\\\"\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/controllers/TemplatesController.php\",\"line\":102,\"class\":\"craft\\\\web\\\\Controller\",\"method\":\"renderTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":null,\"line\":null,\"class\":\"craft\\\\controllers\\\\TemplatesController\",\"method\":\"actionRender\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":null,\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/InlineAction.php\",\"line\":57,\"class\":null,\"method\":\"call_user_func_array\",\"args\":\"[craft\\\\controllers\\\\TemplatesController, \\\"actionRender\\\"], [\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"yii\\\\base\\\\InlineAction\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Controller.php\",\"line\":178,\"class\":\"yii\\\\base\\\\InlineAction\",\"method\":\"runWithParams\",\"args\":\"[\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Module.php\",\"line\":552,\"class\":\"yii\\\\base\\\\Controller\",\"method\":\"runAction\",\"args\":\"\\\"render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":293,\"class\":\"yii\\\\base\\\\Module\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/web/Application.php\",\"line\":103,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":278,\"class\":\"yii\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Application.php\",\"line\":384,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/web/index.php\",\"line\":12,\"class\":\"yii\\\\base\\\\Application\",\"method\":\"run\",\"args\":null}]','2022-07-04 03:27:36','2022-07-04 03:27:36','455d2bdc-b6c5-4c23-bba8-00d851bd9b04'),(7,'ElementQuery::getIterator()','/home/addons/atweb.space/sub/wvtrust/cms/templates/index.twig:16','2022-07-04 03:54:39','/home/addons/atweb.space/sub/wvtrust/cms/templates/index.twig',16,'Looping through element queries directly has been deprecated. Use the `all()` function to fetch the query results before looping over them.','[{\"objectClass\":\"craft\\\\services\\\\Deprecator\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/elements/db/ElementQuery.php\",\"line\":605,\"class\":\"craft\\\\services\\\\Deprecator\",\"method\":\"log\",\"args\":\"\\\"ElementQuery::getIterator()\\\", \\\"Looping through element queries directly has been deprecated. Us...\\\"\"},{\"objectClass\":\"craft\\\\elements\\\\db\\\\MatrixBlockQuery\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/b9/b96eebe1127cc0fea3f9fb125cc1b63185884cb90f9deed117244fbc533a3951.php\",\"line\":74,\"class\":\"craft\\\\elements\\\\db\\\\ElementQuery\",\"method\":\"getIterator\",\"args\":null},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":182,\"class\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"method\":\"block_content\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/d1/d1e3f93dfb9c550cb38f749be29bbc3d4a90ba76876797e7fcec55d6e6726ba4.php\",\"line\":85,\"class\":\"Twig\\\\Template\",\"method\":\"displayBlock\",\"args\":\"\\\"content\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/b9/b96eebe1127cc0fea3f9fb125cc1b63185884cb90f9deed117244fbc533a3951.php\",\"line\":43,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":390,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/TemplateWrapper.php\",\"line\":45,\"class\":\"Twig\\\\Template\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], []\"},{\"objectClass\":\"Twig\\\\TemplateWrapper\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Environment.php\",\"line\":318,\"class\":\"Twig\\\\TemplateWrapper\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\twig\\\\Environment\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":408,\"class\":\"Twig\\\\Environment\",\"method\":\"render\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":461,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Controller.php\",\"line\":201,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderPageTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], \\\"site\\\"\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/controllers/TemplatesController.php\",\"line\":102,\"class\":\"craft\\\\web\\\\Controller\",\"method\":\"renderTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":null,\"line\":null,\"class\":\"craft\\\\controllers\\\\TemplatesController\",\"method\":\"actionRender\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":null,\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/InlineAction.php\",\"line\":57,\"class\":null,\"method\":\"call_user_func_array\",\"args\":\"[craft\\\\controllers\\\\TemplatesController, \\\"actionRender\\\"], [\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"yii\\\\base\\\\InlineAction\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Controller.php\",\"line\":178,\"class\":\"yii\\\\base\\\\InlineAction\",\"method\":\"runWithParams\",\"args\":\"[\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Module.php\",\"line\":552,\"class\":\"yii\\\\base\\\\Controller\",\"method\":\"runAction\",\"args\":\"\\\"render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":293,\"class\":\"yii\\\\base\\\\Module\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/web/Application.php\",\"line\":103,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":278,\"class\":\"yii\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Application.php\",\"line\":384,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/web/index.php\",\"line\":12,\"class\":\"yii\\\\base\\\\Application\",\"method\":\"run\",\"args\":null}]','2022-07-04 03:54:39','2022-07-04 03:54:39','b1b156ed-9148-4d73-b54a-e37d1a37bdfe'),(24,'ElementQuery::getIterator()','/home/addons/atweb.space/sub/wvtrust/cms/templates/index.twig:13','2022-11-30 03:37:59','/home/addons/atweb.space/sub/wvtrust/cms/templates/index.twig',13,'Looping through element queries directly has been deprecated. Use the `all()` function to fetch the query results before looping over them.','[{\"objectClass\":\"craft\\\\services\\\\Deprecator\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/elements/db/ElementQuery.php\",\"line\":605,\"class\":\"craft\\\\services\\\\Deprecator\",\"method\":\"log\",\"args\":\"\\\"ElementQuery::getIterator()\\\", \\\"Looping through element queries directly has been deprecated. Us...\\\"\"},{\"objectClass\":\"craft\\\\elements\\\\db\\\\MatrixBlockQuery\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/b9/b96eebe1127cc0fea3f9fb125cc1b63185884cb90f9deed117244fbc533a3951.php\",\"line\":71,\"class\":\"craft\\\\elements\\\\db\\\\ElementQuery\",\"method\":\"getIterator\",\"args\":null},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":182,\"class\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"method\":\"block_content\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/d1/d1e3f93dfb9c550cb38f749be29bbc3d4a90ba76876797e7fcec55d6e6726ba4.php\",\"line\":88,\"class\":\"Twig\\\\Template\",\"method\":\"displayBlock\",\"args\":\"\\\"content\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/b9/b96eebe1127cc0fea3f9fb125cc1b63185884cb90f9deed117244fbc533a3951.php\",\"line\":43,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":390,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/TemplateWrapper.php\",\"line\":45,\"class\":\"Twig\\\\Template\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], []\"},{\"objectClass\":\"Twig\\\\TemplateWrapper\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Environment.php\",\"line\":318,\"class\":\"Twig\\\\TemplateWrapper\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\twig\\\\Environment\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":408,\"class\":\"Twig\\\\Environment\",\"method\":\"render\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":461,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Controller.php\",\"line\":201,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderPageTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], \\\"site\\\"\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/controllers/TemplatesController.php\",\"line\":102,\"class\":\"craft\\\\web\\\\Controller\",\"method\":\"renderTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":null,\"line\":null,\"class\":\"craft\\\\controllers\\\\TemplatesController\",\"method\":\"actionRender\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":null,\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/InlineAction.php\",\"line\":57,\"class\":null,\"method\":\"call_user_func_array\",\"args\":\"[craft\\\\controllers\\\\TemplatesController, \\\"actionRender\\\"], [\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"yii\\\\base\\\\InlineAction\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Controller.php\",\"line\":178,\"class\":\"yii\\\\base\\\\InlineAction\",\"method\":\"runWithParams\",\"args\":\"[\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Module.php\",\"line\":552,\"class\":\"yii\\\\base\\\\Controller\",\"method\":\"runAction\",\"args\":\"\\\"render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":293,\"class\":\"yii\\\\base\\\\Module\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/web/Application.php\",\"line\":103,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":278,\"class\":\"yii\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Application.php\",\"line\":384,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/web/index.php\",\"line\":12,\"class\":\"yii\\\\base\\\\Application\",\"method\":\"run\",\"args\":null}]','2022-11-30 03:37:59','2022-11-30 03:37:59','45cebde5-d779-4f2a-9986-d7555f91c8ba'),(46,'ElementQuery::getIterator()','/home/addons/atweb.space/sub/wvtrust/cms/templates/property/_entry.twig:10','2022-10-30 11:04:01','/home/addons/atweb.space/sub/wvtrust/cms/templates/property/_entry.twig',10,'Looping through element queries directly has been deprecated. Use the `all()` function to fetch the query results before looping over them.','[{\"objectClass\":\"craft\\\\services\\\\Deprecator\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/elements/db/ElementQuery.php\",\"line\":605,\"class\":\"craft\\\\services\\\\Deprecator\",\"method\":\"log\",\"args\":\"\\\"ElementQuery::getIterator()\\\", \\\"Looping through element queries directly has been deprecated. Us...\\\"\"},{\"objectClass\":\"craft\\\\elements\\\\db\\\\MatrixBlockQuery\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/fd/fde9493af9a0750402f58eeb02df211c87f1fe9c001d4e10256c80969d2adff5.php\",\"line\":69,\"class\":\"craft\\\\elements\\\\db\\\\ElementQuery\",\"method\":\"getIterator\",\"args\":null},{\"objectClass\":\"__TwigTemplate_52150fb8a6a32a37860ea3cf72bad7ff17e7ea3258136aabb2808664875c2508\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":182,\"class\":\"__TwigTemplate_52150fb8a6a32a37860ea3cf72bad7ff17e7ea3258136aabb2808664875c2508\",\"method\":\"block_content\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_52150fb8a6a32a37860ea3cf72bad7ff17e7ea3258136aabb2808664875c2508, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/d1/d1e3f93dfb9c550cb38f749be29bbc3d4a90ba76876797e7fcec55d6e6726ba4.php\",\"line\":88,\"class\":\"Twig\\\\Template\",\"method\":\"displayBlock\",\"args\":\"\\\"content\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_52150fb8a6a32a37860ea3cf72bad7ff17e7ea3258136aabb2808664875c2508, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_52150fb8a6a32a37860ea3cf72bad7ff17e7ea3258136aabb2808664875c2508, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_52150fb8a6a32a37860ea3cf72bad7ff17e7ea3258136aabb2808664875c2508, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/fd/fde9493af9a0750402f58eeb02df211c87f1fe9c001d4e10256c80969d2adff5.php\",\"line\":43,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_52150fb8a6a32a37860ea3cf72bad7ff17e7ea3258136aabb2808664875c2508, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_52150fb8a6a32a37860ea3cf72bad7ff17e7ea3258136aabb2808664875c2508\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_52150fb8a6a32a37860ea3cf72bad7ff17e7ea3258136aabb2808664875c2508\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_52150fb8a6a32a37860ea3cf72bad7ff17e7ea3258136aabb2808664875c2508, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_52150fb8a6a32a37860ea3cf72bad7ff17e7ea3258136aabb2808664875c2508\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_52150fb8a6a32a37860ea3cf72bad7ff17e7ea3258136aabb2808664875c2508, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_52150fb8a6a32a37860ea3cf72bad7ff17e7ea3258136aabb2808664875c2508\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":390,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"__TwigTemplate_52150fb8a6a32a37860ea3cf72bad7ff17e7ea3258136aabb2808664875c2508\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/TemplateWrapper.php\",\"line\":45,\"class\":\"Twig\\\\Template\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], []\"},{\"objectClass\":\"Twig\\\\TemplateWrapper\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Environment.php\",\"line\":318,\"class\":\"Twig\\\\TemplateWrapper\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\twig\\\\Environment\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":408,\"class\":\"Twig\\\\Environment\",\"method\":\"render\",\"args\":\"\\\"property/_entry.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":461,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderTemplate\",\"args\":\"\\\"property/_entry.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Controller.php\",\"line\":201,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderPageTemplate\",\"args\":\"\\\"property/_entry.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], \\\"site\\\"\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/controllers/TemplatesController.php\",\"line\":102,\"class\":\"craft\\\\web\\\\Controller\",\"method\":\"renderTemplate\",\"args\":\"\\\"property/_entry.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":null,\"line\":null,\"class\":\"craft\\\\controllers\\\\TemplatesController\",\"method\":\"actionRender\",\"args\":\"\\\"property/_entry.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":null,\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/InlineAction.php\",\"line\":57,\"class\":null,\"method\":\"call_user_func_array\",\"args\":\"[craft\\\\controllers\\\\TemplatesController, \\\"actionRender\\\"], [\\\"property/_entry.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"yii\\\\base\\\\InlineAction\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Controller.php\",\"line\":178,\"class\":\"yii\\\\base\\\\InlineAction\",\"method\":\"runWithParams\",\"args\":\"[\\\"template\\\" => \\\"property/_entry.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"p\\\" => \\\"property/south\\\"]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Module.php\",\"line\":552,\"class\":\"yii\\\\base\\\\Controller\",\"method\":\"runAction\",\"args\":\"\\\"render\\\", [\\\"template\\\" => \\\"property/_entry.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"p\\\" => \\\"property/south\\\"]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":293,\"class\":\"yii\\\\base\\\\Module\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"property/_entry.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"p\\\" => \\\"property/south\\\"]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/web/Application.php\",\"line\":103,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"property/_entry.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"p\\\" => \\\"property/south\\\"]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":278,\"class\":\"yii\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Application.php\",\"line\":384,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/web/index.php\",\"line\":12,\"class\":\"yii\\\\base\\\\Application\",\"method\":\"run\",\"args\":null}]','2022-10-30 11:04:01','2022-10-30 11:04:01','5abfc333-574c-41a4-9a54-957d07c16b1c'),(93,'ElementQuery::getIterator()','/home/addons/atweb.space/sub/wvtrust/cms/templates/index.twig:25','2022-11-30 03:41:55','/home/addons/atweb.space/sub/wvtrust/cms/templates/index.twig',25,'Looping through element queries directly has been deprecated. Use the `all()` function to fetch the query results before looping over them.','[{\"objectClass\":\"craft\\\\services\\\\Deprecator\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/elements/db/ElementQuery.php\",\"line\":605,\"class\":\"craft\\\\services\\\\Deprecator\",\"method\":\"log\",\"args\":\"\\\"ElementQuery::getIterator()\\\", \\\"Looping through element queries directly has been deprecated. Us...\\\"\"},{\"objectClass\":\"craft\\\\elements\\\\db\\\\MatrixBlockQuery\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/b9/b96eebe1127cc0fea3f9fb125cc1b63185884cb90f9deed117244fbc533a3951.php\",\"line\":83,\"class\":\"craft\\\\elements\\\\db\\\\ElementQuery\",\"method\":\"getIterator\",\"args\":null},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":182,\"class\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"method\":\"block_content\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/d1/d1e3f93dfb9c550cb38f749be29bbc3d4a90ba76876797e7fcec55d6e6726ba4.php\",\"line\":88,\"class\":\"Twig\\\\Template\",\"method\":\"displayBlock\",\"args\":\"\\\"content\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/b9/b96eebe1127cc0fea3f9fb125cc1b63185884cb90f9deed117244fbc533a3951.php\",\"line\":43,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":390,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/TemplateWrapper.php\",\"line\":45,\"class\":\"Twig\\\\Template\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], []\"},{\"objectClass\":\"Twig\\\\TemplateWrapper\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Environment.php\",\"line\":318,\"class\":\"Twig\\\\TemplateWrapper\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\twig\\\\Environment\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":408,\"class\":\"Twig\\\\Environment\",\"method\":\"render\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":461,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Controller.php\",\"line\":201,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderPageTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], \\\"site\\\"\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/controllers/TemplatesController.php\",\"line\":102,\"class\":\"craft\\\\web\\\\Controller\",\"method\":\"renderTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":null,\"line\":null,\"class\":\"craft\\\\controllers\\\\TemplatesController\",\"method\":\"actionRender\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":null,\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/InlineAction.php\",\"line\":57,\"class\":null,\"method\":\"call_user_func_array\",\"args\":\"[craft\\\\controllers\\\\TemplatesController, \\\"actionRender\\\"], [\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"yii\\\\base\\\\InlineAction\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Controller.php\",\"line\":178,\"class\":\"yii\\\\base\\\\InlineAction\",\"method\":\"runWithParams\",\"args\":\"[\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Module.php\",\"line\":552,\"class\":\"yii\\\\base\\\\Controller\",\"method\":\"runAction\",\"args\":\"\\\"render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":293,\"class\":\"yii\\\\base\\\\Module\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/web/Application.php\",\"line\":103,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":278,\"class\":\"yii\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Application.php\",\"line\":384,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/web/index.php\",\"line\":12,\"class\":\"yii\\\\base\\\\Application\",\"method\":\"run\",\"args\":null}]','2022-11-30 03:41:55','2022-11-30 03:41:55','dc25041e-e7cc-46d3-a14a-653930075668'),(98,'ElementQuery::getIterator()','/home/addons/atweb.space/sub/wvtrust/cms/templates/index.twig:27','2022-11-30 03:43:54','/home/addons/atweb.space/sub/wvtrust/cms/templates/index.twig',27,'Looping through element queries directly has been deprecated. Use the `all()` function to fetch the query results before looping over them.','[{\"objectClass\":\"craft\\\\services\\\\Deprecator\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/elements/db/ElementQuery.php\",\"line\":605,\"class\":\"craft\\\\services\\\\Deprecator\",\"method\":\"log\",\"args\":\"\\\"ElementQuery::getIterator()\\\", \\\"Looping through element queries directly has been deprecated. Us...\\\"\"},{\"objectClass\":\"craft\\\\elements\\\\db\\\\MatrixBlockQuery\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/b9/b96eebe1127cc0fea3f9fb125cc1b63185884cb90f9deed117244fbc533a3951.php\",\"line\":85,\"class\":\"craft\\\\elements\\\\db\\\\ElementQuery\",\"method\":\"getIterator\",\"args\":null},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":182,\"class\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"method\":\"block_content\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/d1/d1e3f93dfb9c550cb38f749be29bbc3d4a90ba76876797e7fcec55d6e6726ba4.php\",\"line\":88,\"class\":\"Twig\\\\Template\",\"method\":\"displayBlock\",\"args\":\"\\\"content\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/b9/b96eebe1127cc0fea3f9fb125cc1b63185884cb90f9deed117244fbc533a3951.php\",\"line\":43,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":390,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/TemplateWrapper.php\",\"line\":45,\"class\":\"Twig\\\\Template\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], []\"},{\"objectClass\":\"Twig\\\\TemplateWrapper\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Environment.php\",\"line\":318,\"class\":\"Twig\\\\TemplateWrapper\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\twig\\\\Environment\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":408,\"class\":\"Twig\\\\Environment\",\"method\":\"render\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":461,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Controller.php\",\"line\":201,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderPageTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], \\\"site\\\"\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/controllers/TemplatesController.php\",\"line\":102,\"class\":\"craft\\\\web\\\\Controller\",\"method\":\"renderTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":null,\"line\":null,\"class\":\"craft\\\\controllers\\\\TemplatesController\",\"method\":\"actionRender\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":null,\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/InlineAction.php\",\"line\":57,\"class\":null,\"method\":\"call_user_func_array\",\"args\":\"[craft\\\\controllers\\\\TemplatesController, \\\"actionRender\\\"], [\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"yii\\\\base\\\\InlineAction\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Controller.php\",\"line\":178,\"class\":\"yii\\\\base\\\\InlineAction\",\"method\":\"runWithParams\",\"args\":\"[\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Module.php\",\"line\":552,\"class\":\"yii\\\\base\\\\Controller\",\"method\":\"runAction\",\"args\":\"\\\"render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":293,\"class\":\"yii\\\\base\\\\Module\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/web/Application.php\",\"line\":103,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":278,\"class\":\"yii\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Application.php\",\"line\":384,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/web/index.php\",\"line\":12,\"class\":\"yii\\\\base\\\\Application\",\"method\":\"run\",\"args\":null}]','2022-11-30 03:43:54','2022-11-30 03:43:54','da37a10c-f855-4f7f-9d61-5194f8450550'),(99,'ElementQuery::getIterator()','/home/addons/atweb.space/sub/wvtrust/cms/templates/index.twig:26','2023-03-16 04:42:52','/home/addons/atweb.space/sub/wvtrust/cms/templates/index.twig',26,'Looping through element queries directly has been deprecated. Use the `all()` function to fetch the query results before looping over them.','[{\"objectClass\":\"craft\\\\services\\\\Deprecator\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/elements/db/ElementQuery.php\",\"line\":605,\"class\":\"craft\\\\services\\\\Deprecator\",\"method\":\"log\",\"args\":\"\\\"ElementQuery::getIterator()\\\", \\\"Looping through element queries directly has been deprecated. Us...\\\"\"},{\"objectClass\":\"craft\\\\elements\\\\db\\\\MatrixBlockQuery\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/e9/e942392574639bd42204688b60788e9a047ad48e9d620a4f7f12d21cb41ddb99.php\",\"line\":81,\"class\":\"craft\\\\elements\\\\db\\\\ElementQuery\",\"method\":\"getIterator\",\"args\":null},{\"objectClass\":\"__TwigTemplate_03c249c1837774b050898f68d2e8e8d8cc196ab570bd81be554ec4f4e2f4ccd4\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":182,\"class\":\"__TwigTemplate_03c249c1837774b050898f68d2e8e8d8cc196ab570bd81be554ec4f4e2f4ccd4\",\"method\":\"block_content\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_03c249c1837774b050898f68d2e8e8d8cc196ab570bd81be554ec4f4e2f4ccd4, \\\"block_content\\\"], \\\"javascripts\\\" => [__TwigTemplate_10212015e703fcdafd640064581d874282289249d0205c2c66d6ca425fb74ee1, \\\"block_javascripts\\\"]]\"},{\"objectClass\":\"__TwigTemplate_10212015e703fcdafd640064581d874282289249d0205c2c66d6ca425fb74ee1\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/1e/1e5e32a4e37922c0e4fad8f741205d3731a76df6d0f2d6a9fd9764ccf0d58058.php\",\"line\":183,\"class\":\"Twig\\\\Template\",\"method\":\"displayBlock\",\"args\":\"\\\"content\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_03c249c1837774b050898f68d2e8e8d8cc196ab570bd81be554ec4f4e2f4ccd4, \\\"block_content\\\"], \\\"javascripts\\\" => [__TwigTemplate_10212015e703fcdafd640064581d874282289249d0205c2c66d6ca425fb74ee1, \\\"block_javascripts\\\"]]\"},{\"objectClass\":\"__TwigTemplate_10212015e703fcdafd640064581d874282289249d0205c2c66d6ca425fb74ee1\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_10212015e703fcdafd640064581d874282289249d0205c2c66d6ca425fb74ee1\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_03c249c1837774b050898f68d2e8e8d8cc196ab570bd81be554ec4f4e2f4ccd4, \\\"block_content\\\"], \\\"javascripts\\\" => [__TwigTemplate_10212015e703fcdafd640064581d874282289249d0205c2c66d6ca425fb74ee1, \\\"block_javascripts\\\"]]\"},{\"objectClass\":\"__TwigTemplate_10212015e703fcdafd640064581d874282289249d0205c2c66d6ca425fb74ee1\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_03c249c1837774b050898f68d2e8e8d8cc196ab570bd81be554ec4f4e2f4ccd4, \\\"block_content\\\"], \\\"javascripts\\\" => [__TwigTemplate_10212015e703fcdafd640064581d874282289249d0205c2c66d6ca425fb74ee1, \\\"block_javascripts\\\"]]\"},{\"objectClass\":\"__TwigTemplate_10212015e703fcdafd640064581d874282289249d0205c2c66d6ca425fb74ee1\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/e9/e942392574639bd42204688b60788e9a047ad48e9d620a4f7f12d21cb41ddb99.php\",\"line\":43,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_03c249c1837774b050898f68d2e8e8d8cc196ab570bd81be554ec4f4e2f4ccd4, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_03c249c1837774b050898f68d2e8e8d8cc196ab570bd81be554ec4f4e2f4ccd4\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_03c249c1837774b050898f68d2e8e8d8cc196ab570bd81be554ec4f4e2f4ccd4\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_03c249c1837774b050898f68d2e8e8d8cc196ab570bd81be554ec4f4e2f4ccd4, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_03c249c1837774b050898f68d2e8e8d8cc196ab570bd81be554ec4f4e2f4ccd4\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_03c249c1837774b050898f68d2e8e8d8cc196ab570bd81be554ec4f4e2f4ccd4, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_03c249c1837774b050898f68d2e8e8d8cc196ab570bd81be554ec4f4e2f4ccd4\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":390,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"__TwigTemplate_03c249c1837774b050898f68d2e8e8d8cc196ab570bd81be554ec4f4e2f4ccd4\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/TemplateWrapper.php\",\"line\":45,\"class\":\"Twig\\\\Template\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], []\"},{\"objectClass\":\"Twig\\\\TemplateWrapper\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Environment.php\",\"line\":318,\"class\":\"Twig\\\\TemplateWrapper\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\twig\\\\Environment\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":408,\"class\":\"Twig\\\\Environment\",\"method\":\"render\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":461,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Controller.php\",\"line\":201,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderPageTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], \\\"site\\\"\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/controllers/TemplatesController.php\",\"line\":102,\"class\":\"craft\\\\web\\\\Controller\",\"method\":\"renderTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":null,\"line\":null,\"class\":\"craft\\\\controllers\\\\TemplatesController\",\"method\":\"actionRender\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":null,\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/InlineAction.php\",\"line\":57,\"class\":null,\"method\":\"call_user_func_array\",\"args\":\"[craft\\\\controllers\\\\TemplatesController, \\\"actionRender\\\"], [\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"yii\\\\base\\\\InlineAction\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Controller.php\",\"line\":178,\"class\":\"yii\\\\base\\\\InlineAction\",\"method\":\"runWithParams\",\"args\":\"[\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Module.php\",\"line\":552,\"class\":\"yii\\\\base\\\\Controller\",\"method\":\"runAction\",\"args\":\"\\\"render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":293,\"class\":\"yii\\\\base\\\\Module\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/web/Application.php\",\"line\":103,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":278,\"class\":\"yii\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Application.php\",\"line\":384,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/web/index.php\",\"line\":12,\"class\":\"yii\\\\base\\\\Application\",\"method\":\"run\",\"args\":null}]','2023-03-16 04:42:52','2023-03-16 04:42:52','a4f77e03-a4a1-4530-8aa0-44014851fe84'),(100,'ElementQuery::getIterator()','/home/addons/atweb.space/sub/wvtrust/cms/templates/index.twig:28','2023-01-19 14:53:41','/home/addons/atweb.space/sub/wvtrust/cms/templates/index.twig',28,'Looping through element queries directly has been deprecated. Use the `all()` function to fetch the query results before looping over them.','[{\"objectClass\":\"craft\\\\services\\\\Deprecator\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/elements/db/ElementQuery.php\",\"line\":605,\"class\":\"craft\\\\services\\\\Deprecator\",\"method\":\"log\",\"args\":\"\\\"ElementQuery::getIterator()\\\", \\\"Looping through element queries directly has been deprecated. Us...\\\"\"},{\"objectClass\":\"craft\\\\elements\\\\db\\\\MatrixBlockQuery\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/b9/b96eebe1127cc0fea3f9fb125cc1b63185884cb90f9deed117244fbc533a3951.php\",\"line\":103,\"class\":\"craft\\\\elements\\\\db\\\\ElementQuery\",\"method\":\"getIterator\",\"args\":null},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":182,\"class\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"method\":\"block_content\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"], \\\"javascripts\\\" => [__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca, \\\"block_javascripts\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/d1/d1e3f93dfb9c550cb38f749be29bbc3d4a90ba76876797e7fcec55d6e6726ba4.php\",\"line\":201,\"class\":\"Twig\\\\Template\",\"method\":\"displayBlock\",\"args\":\"\\\"content\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"], \\\"javascripts\\\" => [__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca, \\\"block_javascripts\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"], \\\"javascripts\\\" => [__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca, \\\"block_javascripts\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"], \\\"javascripts\\\" => [__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca, \\\"block_javascripts\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/b9/b96eebe1127cc0fea3f9fb125cc1b63185884cb90f9deed117244fbc533a3951.php\",\"line\":43,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":390,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/TemplateWrapper.php\",\"line\":45,\"class\":\"Twig\\\\Template\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], []\"},{\"objectClass\":\"Twig\\\\TemplateWrapper\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Environment.php\",\"line\":318,\"class\":\"Twig\\\\TemplateWrapper\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\twig\\\\Environment\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":408,\"class\":\"Twig\\\\Environment\",\"method\":\"render\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":461,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Controller.php\",\"line\":201,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderPageTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], \\\"site\\\"\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/controllers/TemplatesController.php\",\"line\":102,\"class\":\"craft\\\\web\\\\Controller\",\"method\":\"renderTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":null,\"line\":null,\"class\":\"craft\\\\controllers\\\\TemplatesController\",\"method\":\"actionRender\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":null,\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/InlineAction.php\",\"line\":57,\"class\":null,\"method\":\"call_user_func_array\",\"args\":\"[craft\\\\controllers\\\\TemplatesController, \\\"actionRender\\\"], [\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"yii\\\\base\\\\InlineAction\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Controller.php\",\"line\":178,\"class\":\"yii\\\\base\\\\InlineAction\",\"method\":\"runWithParams\",\"args\":\"[\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Module.php\",\"line\":552,\"class\":\"yii\\\\base\\\\Controller\",\"method\":\"runAction\",\"args\":\"\\\"render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":293,\"class\":\"yii\\\\base\\\\Module\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/web/Application.php\",\"line\":103,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":278,\"class\":\"yii\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Application.php\",\"line\":384,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/web/index.php\",\"line\":12,\"class\":\"yii\\\\base\\\\Application\",\"method\":\"run\",\"args\":null}]','2023-01-19 14:53:41','2023-01-19 14:53:41','cc293bab-aa30-4a7a-a359-96b491355a45'),(101,'ElementQuery::getIterator()','/home/addons/atweb.space/sub/wvtrust/cms/templates/index.twig:30','2022-11-30 06:38:08','/home/addons/atweb.space/sub/wvtrust/cms/templates/index.twig',30,'Looping through element queries directly has been deprecated. Use the `all()` function to fetch the query results before looping over them.','[{\"objectClass\":\"craft\\\\services\\\\Deprecator\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/elements/db/ElementQuery.php\",\"line\":605,\"class\":\"craft\\\\services\\\\Deprecator\",\"method\":\"log\",\"args\":\"\\\"ElementQuery::getIterator()\\\", \\\"Looping through element queries directly has been deprecated. Us...\\\"\"},{\"objectClass\":\"craft\\\\elements\\\\db\\\\MatrixBlockQuery\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/b9/b96eebe1127cc0fea3f9fb125cc1b63185884cb90f9deed117244fbc533a3951.php\",\"line\":105,\"class\":\"craft\\\\elements\\\\db\\\\ElementQuery\",\"method\":\"getIterator\",\"args\":null},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":182,\"class\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"method\":\"block_content\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/d1/d1e3f93dfb9c550cb38f749be29bbc3d4a90ba76876797e7fcec55d6e6726ba4.php\",\"line\":91,\"class\":\"Twig\\\\Template\",\"method\":\"displayBlock\",\"args\":\"\\\"content\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/b9/b96eebe1127cc0fea3f9fb125cc1b63185884cb90f9deed117244fbc533a3951.php\",\"line\":43,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":390,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/TemplateWrapper.php\",\"line\":45,\"class\":\"Twig\\\\Template\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], []\"},{\"objectClass\":\"Twig\\\\TemplateWrapper\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Environment.php\",\"line\":318,\"class\":\"Twig\\\\TemplateWrapper\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\twig\\\\Environment\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":408,\"class\":\"Twig\\\\Environment\",\"method\":\"render\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":461,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Controller.php\",\"line\":201,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderPageTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], \\\"site\\\"\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/controllers/TemplatesController.php\",\"line\":102,\"class\":\"craft\\\\web\\\\Controller\",\"method\":\"renderTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":null,\"line\":null,\"class\":\"craft\\\\controllers\\\\TemplatesController\",\"method\":\"actionRender\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":null,\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/InlineAction.php\",\"line\":57,\"class\":null,\"method\":\"call_user_func_array\",\"args\":\"[craft\\\\controllers\\\\TemplatesController, \\\"actionRender\\\"], [\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"yii\\\\base\\\\InlineAction\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Controller.php\",\"line\":178,\"class\":\"yii\\\\base\\\\InlineAction\",\"method\":\"runWithParams\",\"args\":\"[\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Module.php\",\"line\":552,\"class\":\"yii\\\\base\\\\Controller\",\"method\":\"runAction\",\"args\":\"\\\"render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":293,\"class\":\"yii\\\\base\\\\Module\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/web/Application.php\",\"line\":103,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":278,\"class\":\"yii\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Application.php\",\"line\":384,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/web/index.php\",\"line\":12,\"class\":\"yii\\\\base\\\\Application\",\"method\":\"run\",\"args\":null}]','2022-11-30 06:38:08','2022-11-30 06:38:08','a5275b4b-aca3-43c4-a86c-c682492707f1'),(102,'ElementQuery::getIterator()','/home/addons/atweb.space/sub/wvtrust/cms/templates/index.twig:32','2022-11-30 04:55:28','/home/addons/atweb.space/sub/wvtrust/cms/templates/index.twig',32,'Looping through element queries directly has been deprecated. Use the `all()` function to fetch the query results before looping over them.','[{\"objectClass\":\"craft\\\\services\\\\Deprecator\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/elements/db/ElementQuery.php\",\"line\":605,\"class\":\"craft\\\\services\\\\Deprecator\",\"method\":\"log\",\"args\":\"\\\"ElementQuery::getIterator()\\\", \\\"Looping through element queries directly has been deprecated. Us...\\\"\"},{\"objectClass\":\"craft\\\\elements\\\\db\\\\MatrixBlockQuery\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/b9/b96eebe1127cc0fea3f9fb125cc1b63185884cb90f9deed117244fbc533a3951.php\",\"line\":107,\"class\":\"craft\\\\elements\\\\db\\\\ElementQuery\",\"method\":\"getIterator\",\"args\":null},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":182,\"class\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"method\":\"block_content\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/d1/d1e3f93dfb9c550cb38f749be29bbc3d4a90ba76876797e7fcec55d6e6726ba4.php\",\"line\":91,\"class\":\"Twig\\\\Template\",\"method\":\"displayBlock\",\"args\":\"\\\"content\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/b9/b96eebe1127cc0fea3f9fb125cc1b63185884cb90f9deed117244fbc533a3951.php\",\"line\":43,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":390,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/TemplateWrapper.php\",\"line\":45,\"class\":\"Twig\\\\Template\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], []\"},{\"objectClass\":\"Twig\\\\TemplateWrapper\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Environment.php\",\"line\":318,\"class\":\"Twig\\\\TemplateWrapper\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\twig\\\\Environment\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":408,\"class\":\"Twig\\\\Environment\",\"method\":\"render\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":461,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Controller.php\",\"line\":201,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderPageTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], \\\"site\\\"\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/controllers/TemplatesController.php\",\"line\":102,\"class\":\"craft\\\\web\\\\Controller\",\"method\":\"renderTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":null,\"line\":null,\"class\":\"craft\\\\controllers\\\\TemplatesController\",\"method\":\"actionRender\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":null,\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/InlineAction.php\",\"line\":57,\"class\":null,\"method\":\"call_user_func_array\",\"args\":\"[craft\\\\controllers\\\\TemplatesController, \\\"actionRender\\\"], [\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"yii\\\\base\\\\InlineAction\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Controller.php\",\"line\":178,\"class\":\"yii\\\\base\\\\InlineAction\",\"method\":\"runWithParams\",\"args\":\"[\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Module.php\",\"line\":552,\"class\":\"yii\\\\base\\\\Controller\",\"method\":\"runAction\",\"args\":\"\\\"render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":293,\"class\":\"yii\\\\base\\\\Module\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/web/Application.php\",\"line\":103,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":278,\"class\":\"yii\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Application.php\",\"line\":384,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/web/index.php\",\"line\":12,\"class\":\"yii\\\\base\\\\Application\",\"method\":\"run\",\"args\":null}]','2022-11-30 04:55:28','2022-11-30 04:55:28','13265963-929e-45b0-96ff-5467986a3d5b'),(132,'ElementQuery::getIterator()','/home/addons/atweb.space/sub/wvtrust/cms/templates/index.twig:36','2023-01-19 14:55:29','/home/addons/atweb.space/sub/wvtrust/cms/templates/index.twig',36,'Looping through element queries directly has been deprecated. Use the `all()` function to fetch the query results before looping over them.','[{\"objectClass\":\"craft\\\\services\\\\Deprecator\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/elements/db/ElementQuery.php\",\"line\":605,\"class\":\"craft\\\\services\\\\Deprecator\",\"method\":\"log\",\"args\":\"\\\"ElementQuery::getIterator()\\\", \\\"Looping through element queries directly has been deprecated. Us...\\\"\"},{\"objectClass\":\"craft\\\\elements\\\\db\\\\MatrixBlockQuery\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/b9/b96eebe1127cc0fea3f9fb125cc1b63185884cb90f9deed117244fbc533a3951.php\",\"line\":111,\"class\":\"craft\\\\elements\\\\db\\\\ElementQuery\",\"method\":\"getIterator\",\"args\":null},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":182,\"class\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"method\":\"block_content\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"], \\\"javascripts\\\" => [__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca, \\\"block_javascripts\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/d1/d1e3f93dfb9c550cb38f749be29bbc3d4a90ba76876797e7fcec55d6e6726ba4.php\",\"line\":201,\"class\":\"Twig\\\\Template\",\"method\":\"displayBlock\",\"args\":\"\\\"content\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"], \\\"javascripts\\\" => [__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca, \\\"block_javascripts\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"], \\\"javascripts\\\" => [__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca, \\\"block_javascripts\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"], \\\"javascripts\\\" => [__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca, \\\"block_javascripts\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/b9/b96eebe1127cc0fea3f9fb125cc1b63185884cb90f9deed117244fbc533a3951.php\",\"line\":43,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":390,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/TemplateWrapper.php\",\"line\":45,\"class\":\"Twig\\\\Template\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], []\"},{\"objectClass\":\"Twig\\\\TemplateWrapper\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Environment.php\",\"line\":318,\"class\":\"Twig\\\\TemplateWrapper\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\twig\\\\Environment\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":408,\"class\":\"Twig\\\\Environment\",\"method\":\"render\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":461,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Controller.php\",\"line\":201,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderPageTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], \\\"site\\\"\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/controllers/TemplatesController.php\",\"line\":102,\"class\":\"craft\\\\web\\\\Controller\",\"method\":\"renderTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":null,\"line\":null,\"class\":\"craft\\\\controllers\\\\TemplatesController\",\"method\":\"actionRender\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":null,\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/InlineAction.php\",\"line\":57,\"class\":null,\"method\":\"call_user_func_array\",\"args\":\"[craft\\\\controllers\\\\TemplatesController, \\\"actionRender\\\"], [\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"yii\\\\base\\\\InlineAction\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Controller.php\",\"line\":178,\"class\":\"yii\\\\base\\\\InlineAction\",\"method\":\"runWithParams\",\"args\":\"[\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Module.php\",\"line\":552,\"class\":\"yii\\\\base\\\\Controller\",\"method\":\"runAction\",\"args\":\"\\\"render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":293,\"class\":\"yii\\\\base\\\\Module\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/web/Application.php\",\"line\":103,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":278,\"class\":\"yii\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Application.php\",\"line\":384,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/web/index.php\",\"line\":12,\"class\":\"yii\\\\base\\\\Application\",\"method\":\"run\",\"args\":null}]','2023-01-19 14:55:29','2023-01-19 14:55:29','402c7c59-11bf-49fb-8e91-5e860b8d5faf'),(133,'ElementQuery::getIterator()','/home/addons/atweb.space/sub/wvtrust/cms/templates/index.twig:74','2023-01-19 15:10:03','/home/addons/atweb.space/sub/wvtrust/cms/templates/index.twig',74,'Looping through element queries directly has been deprecated. Use the `all()` function to fetch the query results before looping over them.','[{\"objectClass\":\"craft\\\\services\\\\Deprecator\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/elements/db/ElementQuery.php\",\"line\":605,\"class\":\"craft\\\\services\\\\Deprecator\",\"method\":\"log\",\"args\":\"\\\"ElementQuery::getIterator()\\\", \\\"Looping through element queries directly has been deprecated. Us...\\\"\"},{\"objectClass\":\"craft\\\\elements\\\\db\\\\MatrixBlockQuery\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/b9/b96eebe1127cc0fea3f9fb125cc1b63185884cb90f9deed117244fbc533a3951.php\",\"line\":149,\"class\":\"craft\\\\elements\\\\db\\\\ElementQuery\",\"method\":\"getIterator\",\"args\":null},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":182,\"class\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"method\":\"block_content\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"], \\\"javascripts\\\" => [__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca, \\\"block_javascripts\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/d1/d1e3f93dfb9c550cb38f749be29bbc3d4a90ba76876797e7fcec55d6e6726ba4.php\",\"line\":185,\"class\":\"Twig\\\\Template\",\"method\":\"displayBlock\",\"args\":\"\\\"content\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"], \\\"javascripts\\\" => [__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca, \\\"block_javascripts\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"], \\\"javascripts\\\" => [__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca, \\\"block_javascripts\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"], \\\"javascripts\\\" => [__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca, \\\"block_javascripts\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/b9/b96eebe1127cc0fea3f9fb125cc1b63185884cb90f9deed117244fbc533a3951.php\",\"line\":43,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":390,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/TemplateWrapper.php\",\"line\":45,\"class\":\"Twig\\\\Template\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], []\"},{\"objectClass\":\"Twig\\\\TemplateWrapper\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Environment.php\",\"line\":318,\"class\":\"Twig\\\\TemplateWrapper\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\twig\\\\Environment\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":408,\"class\":\"Twig\\\\Environment\",\"method\":\"render\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":461,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Controller.php\",\"line\":201,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderPageTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], \\\"site\\\"\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/controllers/TemplatesController.php\",\"line\":102,\"class\":\"craft\\\\web\\\\Controller\",\"method\":\"renderTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":null,\"line\":null,\"class\":\"craft\\\\controllers\\\\TemplatesController\",\"method\":\"actionRender\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":null,\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/InlineAction.php\",\"line\":57,\"class\":null,\"method\":\"call_user_func_array\",\"args\":\"[craft\\\\controllers\\\\TemplatesController, \\\"actionRender\\\"], [\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"yii\\\\base\\\\InlineAction\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Controller.php\",\"line\":178,\"class\":\"yii\\\\base\\\\InlineAction\",\"method\":\"runWithParams\",\"args\":\"[\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Module.php\",\"line\":552,\"class\":\"yii\\\\base\\\\Controller\",\"method\":\"runAction\",\"args\":\"\\\"render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":293,\"class\":\"yii\\\\base\\\\Module\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/web/Application.php\",\"line\":103,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":278,\"class\":\"yii\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Application.php\",\"line\":384,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/web/index.php\",\"line\":12,\"class\":\"yii\\\\base\\\\Application\",\"method\":\"run\",\"args\":null}]','2023-01-19 15:10:03','2023-01-19 15:10:03','9f02aea5-27eb-49bf-975c-7bfd80ab7793'),(134,'ElementQuery::getIterator()','/home/addons/atweb.space/sub/wvtrust/cms/templates/index.twig:71','2023-01-19 14:58:27','/home/addons/atweb.space/sub/wvtrust/cms/templates/index.twig',71,'Looping through element queries directly has been deprecated. Use the `all()` function to fetch the query results before looping over them.','[{\"objectClass\":\"craft\\\\services\\\\Deprecator\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/elements/db/ElementQuery.php\",\"line\":605,\"class\":\"craft\\\\services\\\\Deprecator\",\"method\":\"log\",\"args\":\"\\\"ElementQuery::getIterator()\\\", \\\"Looping through element queries directly has been deprecated. Us...\\\"\"},{\"objectClass\":\"craft\\\\elements\\\\db\\\\MatrixBlockQuery\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/b9/b96eebe1127cc0fea3f9fb125cc1b63185884cb90f9deed117244fbc533a3951.php\",\"line\":146,\"class\":\"craft\\\\elements\\\\db\\\\ElementQuery\",\"method\":\"getIterator\",\"args\":null},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":182,\"class\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"method\":\"block_content\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"], \\\"javascripts\\\" => [__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca, \\\"block_javascripts\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/d1/d1e3f93dfb9c550cb38f749be29bbc3d4a90ba76876797e7fcec55d6e6726ba4.php\",\"line\":201,\"class\":\"Twig\\\\Template\",\"method\":\"displayBlock\",\"args\":\"\\\"content\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"], \\\"javascripts\\\" => [__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca, \\\"block_javascripts\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"], \\\"javascripts\\\" => [__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca, \\\"block_javascripts\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"], \\\"javascripts\\\" => [__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca, \\\"block_javascripts\\\"]]\"},{\"objectClass\":\"__TwigTemplate_987bdb4fab40f28ebcb89df0001e4b31f6bffefa6ad4dcdf7d2a0afb6936c8ca\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/b9/b96eebe1127cc0fea3f9fb125cc1b63185884cb90f9deed117244fbc533a3951.php\",\"line\":43,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":390,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"__TwigTemplate_d462d7f1610fe645ad6d4d2be0a0968dc19569b78653db51f40543a13600598c\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/TemplateWrapper.php\",\"line\":45,\"class\":\"Twig\\\\Template\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], []\"},{\"objectClass\":\"Twig\\\\TemplateWrapper\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Environment.php\",\"line\":318,\"class\":\"Twig\\\\TemplateWrapper\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\twig\\\\Environment\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":408,\"class\":\"Twig\\\\Environment\",\"method\":\"render\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":461,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Controller.php\",\"line\":201,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderPageTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], \\\"site\\\"\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/controllers/TemplatesController.php\",\"line\":102,\"class\":\"craft\\\\web\\\\Controller\",\"method\":\"renderTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":null,\"line\":null,\"class\":\"craft\\\\controllers\\\\TemplatesController\",\"method\":\"actionRender\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":null,\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/InlineAction.php\",\"line\":57,\"class\":null,\"method\":\"call_user_func_array\",\"args\":\"[craft\\\\controllers\\\\TemplatesController, \\\"actionRender\\\"], [\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"yii\\\\base\\\\InlineAction\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Controller.php\",\"line\":178,\"class\":\"yii\\\\base\\\\InlineAction\",\"method\":\"runWithParams\",\"args\":\"[\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Module.php\",\"line\":552,\"class\":\"yii\\\\base\\\\Controller\",\"method\":\"runAction\",\"args\":\"\\\"render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":293,\"class\":\"yii\\\\base\\\\Module\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/web/Application.php\",\"line\":103,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":278,\"class\":\"yii\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Application.php\",\"line\":384,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/web/index.php\",\"line\":12,\"class\":\"yii\\\\base\\\\Application\",\"method\":\"run\",\"args\":null}]','2023-01-19 14:58:27','2023-01-19 14:58:27','4ee8b5be-6315-4a14-be11-034d9dac07ed'),(141,'ElementQuery::getIterator()','/home/addons/atweb.space/sub/wvtrust/cms/templates/index.twig:75','2023-01-30 03:34:30','/home/addons/atweb.space/sub/wvtrust/cms/templates/index.twig',75,'Looping through element queries directly has been deprecated. Use the `all()` function to fetch the query results before looping over them.','[{\"objectClass\":\"craft\\\\services\\\\Deprecator\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/elements/db/ElementQuery.php\",\"line\":605,\"class\":\"craft\\\\services\\\\Deprecator\",\"method\":\"log\",\"args\":\"\\\"ElementQuery::getIterator()\\\", \\\"Looping through element queries directly has been deprecated. Us...\\\"\"},{\"objectClass\":\"craft\\\\elements\\\\db\\\\MatrixBlockQuery\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/15/15abeb4bde76aece21de01d4f07da433c68d10ee4b897d47cc87ddc66b667553.php\",\"line\":150,\"class\":\"craft\\\\elements\\\\db\\\\ElementQuery\",\"method\":\"getIterator\",\"args\":null},{\"objectClass\":\"__TwigTemplate_6a5ef995d4688fd460e9498cfe4938859ccdeae18e2aa9774250c05983ef08ba\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":182,\"class\":\"__TwigTemplate_6a5ef995d4688fd460e9498cfe4938859ccdeae18e2aa9774250c05983ef08ba\",\"method\":\"block_content\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_6a5ef995d4688fd460e9498cfe4938859ccdeae18e2aa9774250c05983ef08ba, \\\"block_content\\\"], \\\"javascripts\\\" => [__TwigTemplate_6e7a73c971b7a5aea36440d869ec24431b8332ca36bc343153725db5a54aef10, \\\"block_javascripts\\\"]]\"},{\"objectClass\":\"__TwigTemplate_6e7a73c971b7a5aea36440d869ec24431b8332ca36bc343153725db5a54aef10\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/e6/e60cd6cf532814e681c623bdb822ebee8e8a2a3bd4b018ec744590dd96fe5f1a.php\",\"line\":183,\"class\":\"Twig\\\\Template\",\"method\":\"displayBlock\",\"args\":\"\\\"content\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_6a5ef995d4688fd460e9498cfe4938859ccdeae18e2aa9774250c05983ef08ba, \\\"block_content\\\"], \\\"javascripts\\\" => [__TwigTemplate_6e7a73c971b7a5aea36440d869ec24431b8332ca36bc343153725db5a54aef10, \\\"block_javascripts\\\"]]\"},{\"objectClass\":\"__TwigTemplate_6e7a73c971b7a5aea36440d869ec24431b8332ca36bc343153725db5a54aef10\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_6e7a73c971b7a5aea36440d869ec24431b8332ca36bc343153725db5a54aef10\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_6a5ef995d4688fd460e9498cfe4938859ccdeae18e2aa9774250c05983ef08ba, \\\"block_content\\\"], \\\"javascripts\\\" => [__TwigTemplate_6e7a73c971b7a5aea36440d869ec24431b8332ca36bc343153725db5a54aef10, \\\"block_javascripts\\\"]]\"},{\"objectClass\":\"__TwigTemplate_6e7a73c971b7a5aea36440d869ec24431b8332ca36bc343153725db5a54aef10\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_6a5ef995d4688fd460e9498cfe4938859ccdeae18e2aa9774250c05983ef08ba, \\\"block_content\\\"], \\\"javascripts\\\" => [__TwigTemplate_6e7a73c971b7a5aea36440d869ec24431b8332ca36bc343153725db5a54aef10, \\\"block_javascripts\\\"]]\"},{\"objectClass\":\"__TwigTemplate_6e7a73c971b7a5aea36440d869ec24431b8332ca36bc343153725db5a54aef10\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/storage/runtime/compiled_templates/15/15abeb4bde76aece21de01d4f07da433c68d10ee4b897d47cc87ddc66b667553.php\",\"line\":43,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_6a5ef995d4688fd460e9498cfe4938859ccdeae18e2aa9774250c05983ef08ba, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_6a5ef995d4688fd460e9498cfe4938859ccdeae18e2aa9774250c05983ef08ba\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":405,\"class\":\"__TwigTemplate_6a5ef995d4688fd460e9498cfe4938859ccdeae18e2aa9774250c05983ef08ba\",\"method\":\"doDisplay\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_6a5ef995d4688fd460e9498cfe4938859ccdeae18e2aa9774250c05983ef08ba, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_6a5ef995d4688fd460e9498cfe4938859ccdeae18e2aa9774250c05983ef08ba\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":378,\"class\":\"Twig\\\\Template\",\"method\":\"displayWithErrorHandling\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry], \\\"craft\\\" => craft\\\\web\\\\twig\\\\variables\\\\CraftVariable, \\\"currentSite\\\" => craft\\\\models\\\\Site, ...], [\\\"content\\\" => [__TwigTemplate_6a5ef995d4688fd460e9498cfe4938859ccdeae18e2aa9774250c05983ef08ba, \\\"block_content\\\"]]\"},{\"objectClass\":\"__TwigTemplate_6a5ef995d4688fd460e9498cfe4938859ccdeae18e2aa9774250c05983ef08ba\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Template.php\",\"line\":390,\"class\":\"Twig\\\\Template\",\"method\":\"display\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"__TwigTemplate_6a5ef995d4688fd460e9498cfe4938859ccdeae18e2aa9774250c05983ef08ba\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/TemplateWrapper.php\",\"line\":45,\"class\":\"Twig\\\\Template\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], []\"},{\"objectClass\":\"Twig\\\\TemplateWrapper\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/twig/twig/src/Environment.php\",\"line\":318,\"class\":\"Twig\\\\TemplateWrapper\",\"method\":\"render\",\"args\":\"[\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\twig\\\\Environment\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":408,\"class\":\"Twig\\\\Environment\",\"method\":\"render\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/View.php\",\"line\":461,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\View\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Controller.php\",\"line\":201,\"class\":\"craft\\\\web\\\\View\",\"method\":\"renderPageTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]], \\\"site\\\"\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/controllers/TemplatesController.php\",\"line\":102,\"class\":\"craft\\\\web\\\\Controller\",\"method\":\"renderTemplate\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":null,\"line\":null,\"class\":\"craft\\\\controllers\\\\TemplatesController\",\"method\":\"actionRender\",\"args\":\"\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry, \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":null,\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/InlineAction.php\",\"line\":57,\"class\":null,\"method\":\"call_user_func_array\",\"args\":\"[craft\\\\controllers\\\\TemplatesController, \\\"actionRender\\\"], [\\\"index.twig\\\", [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"yii\\\\base\\\\InlineAction\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Controller.php\",\"line\":178,\"class\":\"yii\\\\base\\\\InlineAction\",\"method\":\"runWithParams\",\"args\":\"[\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\controllers\\\\TemplatesController\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Module.php\",\"line\":552,\"class\":\"yii\\\\base\\\\Controller\",\"method\":\"runAction\",\"args\":\"\\\"render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":293,\"class\":\"yii\\\\base\\\\Module\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/web/Application.php\",\"line\":103,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"runAction\",\"args\":\"\\\"templates/render\\\", [\\\"template\\\" => \\\"index.twig\\\", \\\"variables\\\" => [\\\"entry\\\" => craft\\\\elements\\\\Entry]]\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/craftcms/cms/src/web/Application.php\",\"line\":278,\"class\":\"yii\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/vendor/yiisoft/yii2/base/Application.php\",\"line\":384,\"class\":\"craft\\\\web\\\\Application\",\"method\":\"handleRequest\",\"args\":\"craft\\\\web\\\\Request\"},{\"objectClass\":\"craft\\\\web\\\\Application\",\"file\":\"/home/addons/atweb.space/sub/wvtrust/cms/web/index.php\",\"line\":12,\"class\":\"yii\\\\base\\\\Application\",\"method\":\"run\",\"args\":null}]','2023-01-30 03:34:30','2023-01-30 03:34:30','60066b55-06a0-4af5-8856-2bea34ad06a4');
/*!40000 ALTER TABLE `deprecationerrors` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `drafts`
--

LOCK TABLES `drafts` WRITE;
/*!40000 ALTER TABLE `drafts` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `drafts` VALUES (16,NULL,1,0,'First draft',NULL,0,NULL,1),(19,199,1,1,'Draft 1','',1,NULL,1),(20,2,1,1,'Draft 1','',1,NULL,1),(23,132,1,1,'Draft 1',NULL,1,NULL,1);
/*!40000 ALTER TABLE `drafts` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `elementindexsettings`
--

LOCK TABLES `elementindexsettings` WRITE;
/*!40000 ALTER TABLE `elementindexsettings` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `elementindexsettings` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `elements`
--

LOCK TABLES `elements` WRITE;
/*!40000 ALTER TABLE `elements` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `elements` VALUES (1,NULL,NULL,NULL,NULL,'craft\\elements\\User',1,0,'2022-07-04 01:44:27','2022-07-04 01:44:27',NULL,NULL,'d0f4191b-bdcb-4582-9d5b-5358d6d5e4da'),(2,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2022-07-04 02:21:22','2023-01-19 15:27:32',NULL,NULL,'4e841309-fe53-42fc-ab67-eaa926b67da7'),(3,2,NULL,1,1,'craft\\elements\\Entry',1,0,'2022-07-04 02:21:22','2022-07-04 02:21:22',NULL,NULL,'edf7b806-aab7-4596-8838-d2f766cc72f2'),(4,2,NULL,2,1,'craft\\elements\\Entry',1,0,'2022-07-04 02:27:09','2022-07-04 02:27:09',NULL,NULL,'0089d125-ce1c-4ff7-afbd-d796775f47cd'),(6,2,NULL,3,1,'craft\\elements\\Entry',1,0,'2022-07-04 02:27:32','2022-07-04 02:27:32',NULL,NULL,'a69513e3-424c-4bd8-8c63-4214b870cfbb'),(8,2,NULL,4,1,'craft\\elements\\Entry',1,0,'2022-07-04 03:01:54','2022-07-04 03:01:54',NULL,NULL,'16ae14e5-1e7c-4c33-9060-96f61a87592d'),(9,2,NULL,5,1,'craft\\elements\\Entry',1,0,'2022-07-04 03:07:06','2022-07-04 03:07:06',NULL,NULL,'31bbf2c6-5e63-47d1-8897-33e7dff3c62f'),(11,NULL,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-04 03:07:37','2022-07-04 03:07:37',NULL,'2022-07-04 03:07:39','515aca6c-a3fa-45eb-9fab-b1e3db5d9700'),(12,NULL,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-04 03:07:39','2022-07-04 03:07:39',NULL,'2022-07-04 03:07:46','773f2d72-aedd-4998-a6d7-1cfca2893bdd'),(13,NULL,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-04 03:07:46','2022-07-04 03:07:46',NULL,'2022-07-04 03:07:48','b927c5ca-b777-424b-aa07-b14ff56ffa22'),(15,NULL,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-04 03:07:53','2022-08-30 05:09:24',NULL,'2023-01-19 15:27:32','a4d12ece-3612-4d7a-86c9-303dc82e4798'),(16,2,NULL,6,1,'craft\\elements\\Entry',1,0,'2022-07-04 03:07:53','2022-07-04 03:07:53',NULL,NULL,'92935567-fdf7-41a4-ab93-9e32b54940b3'),(17,15,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-04 03:07:53','2022-07-04 03:07:53',NULL,NULL,'c078dddf-3acc-45c6-a466-2ed7c651c75f'),(20,2,NULL,7,1,'craft\\elements\\Entry',1,0,'2022-07-04 03:22:10','2022-07-04 03:22:10',NULL,NULL,'67072a90-0fab-42a3-8d96-2897d6814831'),(21,15,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-04 03:22:10','2022-07-04 03:22:10',NULL,NULL,'00ec7a35-d3ad-49d8-9cb9-7e62acdc100c'),(24,2,NULL,8,1,'craft\\elements\\Entry',1,0,'2022-07-04 03:25:00','2022-07-04 03:25:00',NULL,NULL,'8033df26-e55f-42dc-adda-87dcc394d9db'),(25,15,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-04 03:25:00','2022-07-04 03:25:00',NULL,NULL,'7a7d2c5c-009d-4841-a54f-8104bc1e3e94'),(28,2,NULL,9,1,'craft\\elements\\Entry',1,0,'2022-07-04 03:33:42','2022-07-04 03:33:42',NULL,NULL,'6166b4bb-8721-4e4e-bcd8-99fab32f76fb'),(29,15,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-04 03:33:42','2022-07-04 03:33:42',NULL,NULL,'f4487ce5-1932-4a3c-a117-55a414102045'),(30,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2022-07-04 03:42:17','2022-07-04 03:42:17',NULL,'2022-07-04 03:43:07','2f756012-8d88-429f-a709-7b4c74836436'),(31,30,NULL,10,3,'craft\\elements\\Entry',1,0,'2022-07-04 03:42:17','2022-07-04 03:42:17',NULL,'2022-07-04 03:43:07','9143cb6c-94f7-4174-8cf9-fc76bc1ee1e3'),(32,NULL,NULL,NULL,4,'craft\\elements\\Entry',1,0,'2022-07-04 03:47:00','2023-04-18 05:25:56',NULL,NULL,'a800cf7a-2ddf-45dc-9539-51bdae7d395d'),(36,NULL,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-04 03:48:43','2022-07-04 03:48:43',NULL,'2022-07-04 03:48:50','5743d92a-8f8a-41da-a8e0-aff52a18e511'),(37,NULL,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-04 03:48:50','2022-07-04 03:48:50',NULL,'2022-07-04 03:48:53','a6d0b33d-1076-42bc-a4d8-17b7436de989'),(38,NULL,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-04 03:48:53','2022-07-04 03:48:53',NULL,'2022-07-04 03:48:55','73dba7c7-14df-41c4-85aa-027de87b558c'),(39,NULL,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-04 03:48:55','2022-07-04 03:48:55',NULL,'2022-07-04 03:48:59','e1665c97-3910-44e0-866a-45d0f069af1d'),(40,NULL,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-04 03:48:59','2022-07-04 03:48:59',NULL,'2022-07-04 03:49:02','dbe118d5-cbfb-4655-9072-fc1455780a36'),(41,NULL,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-04 03:49:02','2022-07-04 03:49:02',NULL,'2022-07-04 03:49:04','a056903e-fcf8-4737-8e5e-76c626a99923'),(42,NULL,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-04 03:49:04','2022-07-04 03:49:04',NULL,'2022-07-04 03:49:11','6cd490d9-4717-42e6-a5f8-9cf2a4933cf2'),(43,NULL,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-04 03:49:11','2022-07-04 03:49:11',NULL,'2022-07-04 03:49:12','45b61661-a1ca-41d0-b5d9-a9bbfbbc9bc1'),(45,NULL,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-04 03:49:16','2023-01-19 15:27:32',NULL,NULL,'42c416ef-5e4b-4e50-bbdb-fa3022ec175f'),(46,2,NULL,11,1,'craft\\elements\\Entry',1,0,'2022-07-04 03:49:16','2022-07-04 03:49:16',NULL,NULL,'c0db5540-7776-4a6f-8c91-606cfeb6fe7e'),(47,15,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-04 03:49:16','2022-07-04 03:49:16',NULL,NULL,'4c24fd35-2082-4cb0-a787-2dec7640e028'),(48,45,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-04 03:49:16','2022-07-04 03:49:16',NULL,NULL,'04d69bba-6b00-4e72-a31f-39476c2327be'),(49,NULL,NULL,NULL,5,'craft\\elements\\Asset',1,0,'2022-07-04 04:01:56','2022-07-04 04:01:56',NULL,NULL,'d26b695e-0469-4af3-a264-955f219c7387'),(53,2,NULL,12,1,'craft\\elements\\Entry',1,0,'2022-07-04 04:03:28','2022-07-04 04:03:28',NULL,NULL,'00c6cc10-4c8b-49b6-8f10-c55523a526c9'),(54,15,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-04 04:03:28','2022-07-04 04:03:28',NULL,NULL,'51ab1430-b545-4d72-808b-84362daab7f7'),(55,45,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-04 04:03:28','2022-07-04 04:03:28',NULL,NULL,'dc5599d8-560f-4a07-9308-d57b2ba12bfa'),(59,2,NULL,13,1,'craft\\elements\\Entry',1,0,'2022-07-04 04:04:15','2022-07-04 04:04:15',NULL,NULL,'0c1d0b4d-6974-4341-965a-69ea63b0dcc6'),(60,15,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-04 04:04:15','2022-07-04 04:04:15',NULL,NULL,'e856f37a-acf2-47de-b8e0-4deb799cde52'),(61,45,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-04 04:04:15','2022-07-04 04:04:15',NULL,NULL,'e8c161ff-daad-4223-9724-c4c0471b2183'),(65,2,NULL,14,1,'craft\\elements\\Entry',1,0,'2022-07-04 04:35:25','2022-07-04 04:35:25',NULL,NULL,'9f318e46-3135-4f3d-86d1-cd242ee425ca'),(66,15,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-04 04:35:25','2022-07-04 04:35:25',NULL,NULL,'171b2c6f-4ee6-4ed4-9b19-1eb7f8670d80'),(67,45,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-04 04:35:25','2022-07-04 04:35:25',NULL,NULL,'a9faa0e3-4948-407e-9074-9cbdeef44fda'),(72,2,NULL,15,1,'craft\\elements\\Entry',1,0,'2022-07-05 02:12:53','2022-07-05 02:12:53',NULL,NULL,'1d9b8f8b-dd73-41e8-bf94-4b93b20a2aa5'),(73,15,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-05 02:12:53','2022-07-05 02:12:53',NULL,NULL,'47ac1f4e-4d93-4e4e-86c5-491dd800037d'),(74,45,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-05 02:12:53','2022-07-05 02:12:53',NULL,NULL,'fd01ba4c-9eff-48a3-88e1-fd03e04105a2'),(76,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2022-07-07 05:39:33','2023-04-19 03:21:49',NULL,NULL,'5359f97c-a3cc-49d8-85eb-4453ffbeb614'),(77,76,NULL,16,6,'craft\\elements\\Entry',1,0,'2022-07-07 05:43:54','2022-07-07 05:43:54',NULL,NULL,'bda6df38-f7f2-4efd-84a1-e060fcdfbd06'),(78,NULL,16,NULL,6,'craft\\elements\\Entry',1,0,'2022-07-07 05:44:03','2022-07-07 05:44:03',NULL,'2022-07-07 05:45:04','a94a5173-a12c-4088-808f-fce809dda1c5'),(79,76,NULL,17,6,'craft\\elements\\Entry',1,0,'2022-07-07 05:44:53','2022-07-07 05:44:53',NULL,NULL,'e1c5a079-57cb-4088-b846-c18b90b64b65'),(81,76,NULL,18,6,'craft\\elements\\Entry',1,0,'2022-07-07 05:45:10','2022-07-07 05:45:10',NULL,NULL,'0c500b44-fac1-41a6-84a4-56550ae7a246'),(85,NULL,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-07 05:45:20','2022-07-07 05:45:20',NULL,'2022-07-07 05:45:24','eee8838f-b891-4546-b790-ae1e86e26672'),(86,NULL,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-07 05:45:24','2022-07-07 05:45:24',NULL,'2022-07-07 05:45:26','20887b30-99cd-4209-ba25-f502043d5cc8'),(87,NULL,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-07 05:45:26','2022-07-07 05:45:26',NULL,'2022-07-07 05:45:27','97a6e341-2607-40e3-8686-963eaf4ec269'),(88,NULL,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-07 05:45:27','2022-07-07 05:45:27',NULL,'2022-07-07 05:45:33','34213812-148f-41d4-a81e-64b7ebc15207'),(90,NULL,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-07 05:45:36','2023-01-19 15:27:32',NULL,NULL,'3f679741-34b4-4473-9aef-1be7236c35c9'),(91,2,NULL,19,1,'craft\\elements\\Entry',1,0,'2022-07-07 05:45:36','2022-07-07 05:45:36',NULL,NULL,'d3709926-99ba-4b3b-be0c-35bc12770eb4'),(92,15,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-07 05:45:36','2022-07-07 05:45:36',NULL,NULL,'16848d6f-d2ec-4620-baf1-284a82287631'),(93,45,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-07 05:45:36','2022-07-07 05:45:36',NULL,NULL,'242dee0d-2dcb-48a2-a92d-4179257f2d09'),(94,90,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-07 05:45:36','2022-07-07 05:45:36',NULL,NULL,'0c75f4a6-7add-4c86-a737-6bd330dd9cc3'),(96,76,NULL,20,6,'craft\\elements\\Entry',1,0,'2022-07-07 05:46:27','2022-07-07 05:46:27',NULL,NULL,'e40be0a7-bb01-4196-a490-40f30dbe5aeb'),(97,76,NULL,21,6,'craft\\elements\\Entry',1,0,'2022-07-07 05:47:44','2022-07-07 05:47:44',NULL,NULL,'9112f702-3433-4b39-8027-10dfd99b392a'),(102,2,NULL,22,1,'craft\\elements\\Entry',1,0,'2022-07-07 05:48:34','2022-07-07 05:48:34',NULL,NULL,'ec54009b-ca9a-491d-bd00-6c921f5a7a90'),(103,15,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-07 05:48:34','2022-07-07 05:48:34',NULL,NULL,'70155537-56fd-45bc-b1c4-ebc99398af78'),(104,45,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-07 05:48:34','2022-07-07 05:48:34',NULL,NULL,'e865d028-a278-49c5-8fe4-04880bdf9cef'),(105,90,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-07-07 05:48:34','2022-07-07 05:48:34',NULL,NULL,'5d2c9e40-c5e5-483e-96e1-374f569f561d'),(107,76,NULL,23,6,'craft\\elements\\Entry',1,0,'2022-08-04 02:46:56','2022-08-04 02:46:56',NULL,NULL,'5667ae90-cd38-4a42-830a-397472a89265'),(112,2,NULL,24,1,'craft\\elements\\Entry',1,0,'2022-08-05 02:17:34','2022-08-05 02:17:34',NULL,NULL,'3fea3696-717b-4bae-8cb3-eef2dab514fb'),(113,15,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-08-05 02:17:34','2022-08-05 02:17:34',NULL,NULL,'5bbd3ca5-5956-48c8-9a5f-1c8220fcb4e3'),(114,45,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-08-05 02:17:35','2022-08-05 02:17:35',NULL,NULL,'8ed67a3f-375d-4d28-850a-4416aa3c76e7'),(115,90,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-08-05 02:17:35','2022-08-05 02:17:35',NULL,NULL,'ec3494c0-db93-4db9-9b4f-0f220022cd99'),(121,2,NULL,25,1,'craft\\elements\\Entry',1,0,'2022-08-30 05:09:24','2022-08-30 05:09:24',NULL,NULL,'a833f150-02d9-4adb-aa08-60e4b262910f'),(122,15,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-08-30 05:09:24','2022-08-30 05:09:24',NULL,NULL,'53ed8856-9070-451c-a352-2b8a246df027'),(123,45,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-08-30 05:09:24','2022-08-30 05:09:24',NULL,NULL,'ee21dadc-56be-47d9-8a3b-cf63129cca2e'),(124,90,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-08-30 05:09:24','2022-08-30 05:09:24',NULL,NULL,'8a5144ef-83ff-4d80-8ea4-34ef3cf986ee'),(129,76,NULL,26,6,'craft\\elements\\Entry',1,0,'2022-10-12 01:46:56','2022-10-12 01:46:56',NULL,NULL,'d85b4b80-83bb-4f75-8cb5-a74b7f0ad54e'),(130,NULL,NULL,NULL,11,'craft\\elements\\Entry',1,0,'2022-10-29 06:06:57','2022-11-30 03:54:14',NULL,'2022-11-30 03:56:59','e4a946f1-374b-4945-8cb4-b49c820997ce'),(131,130,NULL,27,7,'craft\\elements\\Entry',1,0,'2022-10-29 06:07:07','2022-10-29 06:07:07',NULL,'2022-11-30 03:56:59','482445e9-00f6-4adc-a119-07b8e93e6477'),(132,NULL,NULL,NULL,7,'craft\\elements\\Entry',1,0,'2022-10-29 06:07:11','2022-12-01 07:51:27',NULL,NULL,'95b03c2c-bab9-4813-9e38-fd321d5cd333'),(133,132,NULL,28,7,'craft\\elements\\Entry',1,0,'2022-10-29 06:07:29','2022-10-29 06:07:29',NULL,NULL,'21c43aee-c48d-4453-ad33-f87b40164fbd'),(135,NULL,NULL,NULL,9,'craft\\elements\\MatrixBlock',1,0,'2022-10-29 07:06:47','2022-10-29 07:06:47',NULL,'2022-10-29 07:06:49','52297b4f-6d0d-4c17-a617-b418c66b977e'),(136,NULL,NULL,NULL,9,'craft\\elements\\MatrixBlock',1,0,'2022-10-29 07:06:49','2022-10-29 07:06:49',NULL,'2022-10-29 07:06:52','7a126a5d-f2cc-4b49-87cc-16019899e1de'),(137,NULL,NULL,NULL,10,'craft\\elements\\MatrixBlock',1,0,'2022-10-29 07:06:49','2022-10-29 07:06:49',NULL,'2022-10-29 07:06:52','08b1ac04-89a9-45f4-b763-614f3b4c32d3'),(138,NULL,NULL,NULL,9,'craft\\elements\\MatrixBlock',1,0,'2022-10-29 07:06:52','2022-10-29 07:06:52',NULL,'2022-10-29 07:07:04','b24bc00b-8979-4b1d-bbbe-4edbc042679f'),(139,NULL,NULL,NULL,9,'craft\\elements\\MatrixBlock',1,0,'2022-10-29 07:07:04','2022-10-29 07:07:04',NULL,'2022-10-29 07:07:08','5039c971-0179-43e5-adfc-a278e4dd8705'),(140,NULL,NULL,NULL,9,'craft\\elements\\MatrixBlock',1,0,'2022-10-29 07:07:08','2022-10-29 07:07:08',NULL,'2022-10-29 07:07:12','d6726d4b-60f4-4bbf-9781-4373e9fb3e98'),(141,NULL,NULL,NULL,9,'craft\\elements\\MatrixBlock',1,0,'2022-10-29 07:07:12','2022-10-29 07:07:12',NULL,'2022-10-29 07:07:16','0ad34599-1fda-47ad-b937-d22d18480e62'),(142,NULL,NULL,NULL,10,'craft\\elements\\MatrixBlock',1,0,'2022-10-29 07:07:12','2022-10-29 07:07:12',NULL,'2022-10-29 07:07:16','f5603f1a-2175-40d6-9dc6-65b423464990'),(143,NULL,NULL,NULL,9,'craft\\elements\\MatrixBlock',1,0,'2022-10-29 07:07:16','2022-10-29 07:07:16',NULL,'2022-10-29 07:08:25','781c49b8-9d91-4d4a-b6f2-7d2233f8f1fb'),(144,NULL,NULL,NULL,10,'craft\\elements\\MatrixBlock',1,0,'2022-10-29 07:07:16','2022-10-29 07:07:16',NULL,'2022-10-29 07:08:25','8c936130-5fa6-4002-b9f7-b04cbf37662e'),(145,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2022-10-29 07:08:20','2022-10-29 07:08:20',NULL,'2022-11-30 04:06:32','b2533e15-270c-48d1-be9b-a94a1fd8e01c'),(146,NULL,NULL,NULL,9,'craft\\elements\\MatrixBlock',1,0,'2022-10-29 07:08:25','2022-10-29 07:08:25',NULL,'2022-10-29 07:10:22','553797cb-78fb-4ef6-aa47-bc9782ff13f8'),(147,NULL,NULL,NULL,10,'craft\\elements\\MatrixBlock',1,0,'2022-10-29 07:08:25','2022-10-29 07:08:25',NULL,'2022-10-29 07:10:22','688ac344-a78e-4c5e-8f8f-c5b0d97c564b'),(150,NULL,NULL,NULL,9,'craft\\elements\\MatrixBlock',1,0,'2022-10-29 07:10:22','2022-10-29 07:10:22',NULL,'2022-11-30 03:56:59','8ff1642a-a9e9-4c53-9677-374093d5c8d8'),(151,NULL,NULL,NULL,10,'craft\\elements\\MatrixBlock',1,0,'2022-10-29 07:10:22','2022-10-29 07:10:22',NULL,'2022-11-30 03:56:59','b2e346a8-cddd-410d-b4b0-dc0294ad1c0f'),(159,2,NULL,29,1,'craft\\elements\\Entry',1,0,'2022-11-30 03:41:26','2022-11-30 03:41:26',NULL,NULL,'6375816e-8218-40bb-8dfe-847efcc04738'),(160,15,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-11-30 03:41:26','2022-11-30 03:41:26',NULL,NULL,'50fd597b-7f72-41a4-9f75-02e3113e358f'),(161,45,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-11-30 03:41:26','2022-11-30 03:41:26',NULL,NULL,'ac01140c-467e-4915-b0f7-d2e85d1e848f'),(162,90,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-11-30 03:41:26','2022-11-30 03:41:26',NULL,NULL,'54d42fbd-6b39-4392-b0d4-f54841ab3160'),(167,2,NULL,30,1,'craft\\elements\\Entry',1,0,'2022-11-30 03:41:53','2022-11-30 03:41:53',NULL,NULL,'b0511f73-a4bf-4d59-a50b-224d471b0a29'),(168,15,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-11-30 03:41:53','2022-11-30 03:41:53',NULL,NULL,'e6460568-00ab-498f-96d8-7e248f6dc8d0'),(169,45,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-11-30 03:41:53','2022-11-30 03:41:53',NULL,NULL,'09391c91-7ea9-4aae-9b09-4decd4de8379'),(170,90,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-11-30 03:41:53','2022-11-30 03:41:53',NULL,NULL,'708243e3-faae-47cb-b8c0-db7e04a8bc91'),(177,NULL,NULL,NULL,12,'craft\\elements\\MatrixBlock',1,0,'2022-11-30 04:38:30','2022-11-30 04:38:30',NULL,'2022-11-30 04:38:35','a7e425b2-afd7-4239-a972-765b45eb9512'),(178,NULL,NULL,NULL,12,'craft\\elements\\MatrixBlock',1,0,'2022-11-30 04:38:35','2022-11-30 04:38:35',NULL,'2022-11-30 04:39:18','ccdc0e77-4c52-4933-8dc3-450185bcdc10'),(179,NULL,NULL,NULL,12,'craft\\elements\\MatrixBlock',1,0,'2022-11-30 04:39:18','2022-11-30 04:39:18',NULL,'2022-11-30 04:39:29','c5ef65c1-b2fd-40c2-9f0a-13e58003ea54'),(180,NULL,NULL,NULL,12,'craft\\elements\\MatrixBlock',1,0,'2022-11-30 04:39:29','2022-11-30 04:39:29',NULL,'2022-11-30 04:39:31','cc25f375-f89f-42a8-afd6-af4561735d4d'),(181,NULL,NULL,NULL,12,'craft\\elements\\MatrixBlock',1,0,'2022-11-30 04:39:31','2022-11-30 04:39:31',NULL,'2022-11-30 04:39:33','859a2a4c-26cd-449d-b0b0-bd3fe9b3341c'),(182,NULL,NULL,NULL,12,'craft\\elements\\MatrixBlock',1,0,'2022-11-30 04:39:33','2022-11-30 04:39:33',NULL,'2022-11-30 04:39:34','08808073-5c07-4863-b587-84658c6cdcb5'),(183,NULL,NULL,NULL,12,'craft\\elements\\MatrixBlock',1,0,'2022-11-30 04:39:34','2022-11-30 04:39:34',NULL,'2022-11-30 04:39:37','7f2eebab-1894-4cf9-b832-af196d3f722f'),(184,NULL,NULL,NULL,12,'craft\\elements\\MatrixBlock',1,0,'2022-11-30 04:39:37','2022-11-30 04:39:37',NULL,'2022-11-30 04:39:39','c2a11fea-b233-41a3-9c4e-a60d604c4907'),(185,NULL,NULL,NULL,12,'craft\\elements\\MatrixBlock',1,0,'2022-11-30 04:39:39','2022-11-30 04:39:39',NULL,'2022-11-30 04:39:40','d5c5b99c-1ecb-420b-ad35-b861f3ac54c3'),(186,NULL,NULL,NULL,12,'craft\\elements\\MatrixBlock',1,0,'2022-11-30 04:39:40','2022-11-30 04:39:40',NULL,'2022-11-30 04:39:42','dde54e95-b008-4702-a2f2-c70245829bd3'),(188,NULL,NULL,NULL,12,'craft\\elements\\MatrixBlock',1,0,'2022-11-30 04:39:49','2022-12-01 07:51:27',NULL,NULL,'6e87ae73-b29b-42d6-bfe0-c8adec7bcced'),(195,2,NULL,31,1,'craft\\elements\\Entry',1,0,'2022-11-30 04:49:18','2022-11-30 04:49:18',NULL,NULL,'eb3c5f76-d491-4a66-8f63-5998ab5428bc'),(196,15,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-11-30 04:49:18','2022-11-30 04:49:18',NULL,NULL,'dad648ff-ca8b-4cb8-bd04-73143c4f4481'),(197,45,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-11-30 04:49:18','2022-11-30 04:49:18',NULL,NULL,'8b819fa8-c55f-44cd-8fba-b4a1e666b888'),(198,90,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2022-11-30 04:49:18','2022-11-30 04:49:18',NULL,NULL,'15e07e86-6953-4582-aa5b-5096ea61ce07'),(199,NULL,NULL,NULL,7,'craft\\elements\\Entry',1,0,'2022-12-01 07:17:31','2023-02-16 07:39:05',NULL,NULL,'3da6b845-cbb4-4f13-b64b-d2d9055a2ea5'),(200,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2022-12-01 07:21:46','2022-12-01 07:22:06',NULL,NULL,'3ace9403-f815-4b35-9f73-c395991c3e24'),(205,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2022-12-01 07:51:00','2022-12-01 07:51:00',NULL,NULL,'a437886b-e47d-4d1b-950e-44555365fa74'),(207,15,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2023-01-19 15:27:32','2023-01-19 15:27:32',NULL,'2023-01-19 15:27:32','96821f9f-1fee-4d39-8cf8-c95d32eb77fd'),(210,2,NULL,32,1,'craft\\elements\\Entry',1,0,'2023-01-19 15:27:32','2023-01-19 15:27:32',NULL,NULL,'3585f37c-c93b-471f-b82f-3450a55fab46'),(211,45,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2023-01-19 15:27:32','2023-01-19 15:27:32',NULL,NULL,'74b4691d-6cdc-4b2b-b374-1b3b413b3063'),(212,90,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2023-01-19 15:27:33','2023-01-19 15:27:33',NULL,NULL,'30574750-aca0-434f-9a31-1220ecdae5b6'),(214,199,19,NULL,7,'craft\\elements\\Entry',1,0,'2023-02-16 07:39:27','2023-04-25 01:57:11',NULL,NULL,'d87244bd-cf72-4bf8-b6a6-82fa53888c39'),(215,NULL,NULL,NULL,12,'craft\\elements\\MatrixBlock',1,0,'2023-02-16 07:39:27','2023-04-25 01:57:11',NULL,NULL,'faa1a96e-3865-4dc7-afa1-b1ccd1bbdaf6'),(216,2,20,NULL,1,'craft\\elements\\Entry',1,0,'2023-03-14 04:04:27','2023-04-25 01:56:15',NULL,NULL,'f864bc9a-685e-43c5-b22c-bc6be5cd45a2'),(217,45,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2023-03-14 04:04:27','2023-04-25 01:55:40',NULL,NULL,'f62e5811-2f26-47e2-93f0-e3f9d6e9dc67'),(218,90,NULL,NULL,2,'craft\\elements\\MatrixBlock',1,0,'2023-03-14 04:04:27','2023-04-19 02:24:04',NULL,NULL,'78fdbf58-3c9a-4eb8-9f70-f566d3b99afa'),(221,132,23,NULL,7,'craft\\elements\\Entry',1,0,'2023-04-19 02:38:45','2023-04-19 02:38:45',NULL,NULL,'d7d103f4-57eb-42ab-b3b0-ff2bab2c5daa'),(222,188,NULL,NULL,12,'craft\\elements\\MatrixBlock',1,0,'2023-04-19 02:38:45','2023-04-19 02:38:45',NULL,NULL,'e0c1758f-449c-40af-9f83-fa857e98c5f7'),(223,NULL,NULL,NULL,12,'craft\\elements\\MatrixBlock',1,0,'2023-04-19 02:38:45','2023-04-19 02:38:45',NULL,NULL,'fa99edbf-ae27-41ca-b3d1-5fa7546563a9'),(224,76,NULL,33,6,'craft\\elements\\Entry',1,0,'2023-04-19 03:21:49','2023-04-19 03:21:49',NULL,NULL,'c4043104-a38e-49e3-add6-40b68ae447d9');
/*!40000 ALTER TABLE `elements` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `elements_sites`
--

LOCK TABLES `elements_sites` WRITE;
/*!40000 ALTER TABLE `elements_sites` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `elements_sites` VALUES (1,1,1,NULL,NULL,1,'2022-07-04 01:44:27','2022-07-04 01:44:27','43cc0f47-0955-49df-b1e6-7dcb96d68e41'),(2,2,1,'homepage','__home__',1,'2022-07-04 02:21:22','2022-07-04 02:21:22','afc5a204-1122-4eb4-a445-133f3df80872'),(3,3,1,'homepage','__home__',1,'2022-07-04 02:21:22','2022-07-04 02:21:22','227780c5-a7e9-44f4-a6db-6fa3e41d0772'),(4,4,1,'homepage','__home__',1,'2022-07-04 02:27:09','2022-07-04 02:27:09','c4503117-747b-4ee9-89a3-3984ce84c963'),(6,6,1,'homepage','__home__',1,'2022-07-04 02:27:32','2022-07-04 02:27:32','5079ff79-18bd-4d23-b49c-adceb8ff676f'),(8,8,1,'homepage','__home__',1,'2022-07-04 03:01:54','2022-07-04 03:01:54','f430fcc2-86f7-4dc6-919f-c0d17fe1a129'),(9,9,1,'homepage','__home__',1,'2022-07-04 03:07:06','2022-07-04 03:07:06','bbcfae82-4597-4ec2-b639-8ee5e5d685e6'),(11,11,1,NULL,NULL,1,'2022-07-04 03:07:37','2022-07-04 03:07:37','edc28c4e-a4e0-45c1-99b8-d904c39dd449'),(12,12,1,NULL,NULL,1,'2022-07-04 03:07:39','2022-07-04 03:07:39','a4dd464c-42a7-4c7e-8a71-0d211fc5badd'),(13,13,1,NULL,NULL,1,'2022-07-04 03:07:46','2022-07-04 03:07:46','1d82c196-aa28-4e46-8b33-f963dbd48f10'),(15,15,1,NULL,NULL,1,'2022-07-04 03:07:53','2022-07-04 03:07:53','68fae894-7544-48d2-9a9b-30dd97f17413'),(16,16,1,'homepage','__home__',1,'2022-07-04 03:07:53','2022-07-04 03:07:53','6dc3f824-636b-47b2-8d7f-339453bd9bf6'),(17,17,1,NULL,NULL,1,'2022-07-04 03:07:53','2022-07-04 03:07:53','32d2f161-9b5f-4246-b7d3-1757e42ef639'),(20,20,1,'homepage','__home__',1,'2022-07-04 03:22:10','2022-07-04 03:22:10','4d234a1f-f86b-4228-a611-a718f8fc7ea4'),(21,21,1,NULL,NULL,1,'2022-07-04 03:22:10','2022-07-04 03:22:10','c3143e16-0047-434d-8b7b-9517591bc587'),(24,24,1,'homepage','__home__',1,'2022-07-04 03:25:00','2022-07-04 03:25:00','aca1c883-1031-4324-b7d0-2d46ee697d7d'),(25,25,1,NULL,NULL,1,'2022-07-04 03:25:00','2022-07-04 03:25:00','a2458037-333e-49da-a3b0-357a7a045eb8'),(28,28,1,'homepage','__home__',1,'2022-07-04 03:33:42','2022-07-04 03:33:42','b71ee343-8c3e-4bad-98c1-4b3cefcbc7b4'),(29,29,1,NULL,NULL,1,'2022-07-04 03:33:42','2022-07-04 03:33:42','0a8910f2-1835-43f6-b9c6-664ed8e36056'),(30,30,1,'contentpage','content',1,'2022-07-04 03:42:17','2022-07-04 03:42:17','a745dce5-4db3-4436-8e74-369ae8407faa'),(31,31,1,'contentpage','content',1,'2022-07-04 03:42:17','2022-07-04 03:42:17','eaaaac28-44ad-4f68-b253-3663d355d216'),(32,32,1,'maintainece','maintainece',1,'2022-07-04 03:47:00','2022-07-04 03:47:00','09fa2fcd-1dbd-478f-acf9-0a70093a24c4'),(36,36,1,NULL,NULL,1,'2022-07-04 03:48:43','2022-07-04 03:48:43','627b5b2e-851d-49fb-910f-3b4b12170d37'),(37,37,1,NULL,NULL,1,'2022-07-04 03:48:50','2022-07-04 03:48:50','6e834a59-3ec9-4a93-ae53-6915388a8079'),(38,38,1,NULL,NULL,1,'2022-07-04 03:48:53','2022-07-04 03:48:53','70530429-0d7e-4171-833e-8de280bb082d'),(39,39,1,NULL,NULL,1,'2022-07-04 03:48:55','2022-07-04 03:48:55','bbd6dc68-331a-419d-ab56-6fc6c5055c14'),(40,40,1,NULL,NULL,1,'2022-07-04 03:48:59','2022-07-04 03:48:59','56599df1-1ee7-434a-bace-7e9570b7da9d'),(41,41,1,NULL,NULL,1,'2022-07-04 03:49:02','2022-07-04 03:49:02','0f73d8a6-7268-43a4-b10c-c2ba833e8212'),(42,42,1,NULL,NULL,1,'2022-07-04 03:49:04','2022-07-04 03:49:04','6456eeb4-f453-4e63-a9aa-3e78535dfaa3'),(43,43,1,NULL,NULL,1,'2022-07-04 03:49:11','2022-07-04 03:49:11','a703784a-2955-49d0-82bb-b82e8faf12d8'),(45,45,1,NULL,NULL,1,'2022-07-04 03:49:16','2022-07-04 03:49:16','bb800607-9919-466d-8d81-4c2967b8e1ee'),(46,46,1,'homepage','__home__',1,'2022-07-04 03:49:16','2022-07-04 03:49:16','2945592c-cd92-4347-89a1-4000ee77e7f7'),(47,47,1,NULL,NULL,1,'2022-07-04 03:49:16','2022-07-04 03:49:16','6526370d-1861-42a1-9dea-2ec68942bad1'),(48,48,1,NULL,NULL,1,'2022-07-04 03:49:16','2022-07-04 03:49:16','3362310d-c2c8-430c-8ded-2e0f89e6d49b'),(49,49,1,NULL,NULL,1,'2022-07-04 04:01:56','2022-07-04 04:01:56','765be0aa-df4d-488b-a504-4222e6958849'),(53,53,1,'homepage','__home__',1,'2022-07-04 04:03:28','2022-07-04 04:03:28','79ac4f7d-abd9-471c-99be-df06cc79b5a1'),(54,54,1,NULL,NULL,1,'2022-07-04 04:03:28','2022-07-04 04:03:28','7c0886c6-f12d-48e1-8262-e67c10e33b93'),(55,55,1,NULL,NULL,1,'2022-07-04 04:03:28','2022-07-04 04:03:28','756ed678-ca6e-43d0-8844-42266bcbd5b2'),(59,59,1,'homepage','__home__',1,'2022-07-04 04:04:15','2022-07-04 04:04:15','f070b7d5-d952-4135-817b-fc98173f25e6'),(60,60,1,NULL,NULL,1,'2022-07-04 04:04:15','2022-07-04 04:04:15','61788f3c-13cd-4161-87f4-dbca62a93d02'),(61,61,1,NULL,NULL,1,'2022-07-04 04:04:15','2022-07-04 04:04:15','c1b7adad-ea57-4054-bc76-76a8f6f80360'),(65,65,1,'homepage','__home__',1,'2022-07-04 04:35:25','2022-07-04 04:35:25','0d58ad67-92e0-4904-87a6-0d2d5cdb21ba'),(66,66,1,NULL,NULL,1,'2022-07-04 04:35:25','2022-07-04 04:35:25','06f2d8d1-0471-4dfb-9b5c-eb5fd23b8c1b'),(67,67,1,NULL,NULL,1,'2022-07-04 04:35:25','2022-07-04 04:35:25','f0949c0a-f336-4fc3-a991-0ac3c66eae62'),(72,72,1,'homepage','__home__',1,'2022-07-05 02:12:53','2022-07-05 02:12:53','8bb87fa9-071d-4454-8ae9-9b1a18613cb9'),(73,73,1,NULL,NULL,1,'2022-07-05 02:12:53','2022-07-05 02:12:53','b7a041d4-03bd-4543-bb4a-437a12f0e1d3'),(74,74,1,NULL,NULL,1,'2022-07-05 02:12:53','2022-07-05 02:12:53','e22f62d3-d786-4e69-ad1a-eb67c52e7066'),(76,76,1,'billing-information','billing',1,'2022-07-07 05:39:33','2022-07-07 05:46:27','93308028-f328-47b1-84c2-6acb64dadf2a'),(77,77,1,'billing-information','billing/billing-information',1,'2022-07-07 05:43:54','2022-07-07 05:43:54','8ae04a63-05b9-4d64-ba38-a3e545ca799b'),(78,78,1,'__temp_gohlruyeyhdypdkrlzkxrasbytzhtgxacafz',NULL,1,'2022-07-07 05:44:03','2022-07-07 05:44:54','4c431974-9bea-498a-9562-33efd5c31962'),(79,79,1,'billing-information',NULL,1,'2022-07-07 05:44:53','2022-07-07 05:44:53','d66be03a-396f-4e87-847e-3210ae022f3d'),(81,81,1,'billing-information',NULL,1,'2022-07-07 05:45:10','2022-07-07 05:45:10','afee83cf-1202-4c47-b3a2-fb4e040f4bda'),(85,85,1,NULL,NULL,1,'2022-07-07 05:45:20','2022-07-07 05:45:20','acd04d89-5a7e-477c-8622-f41793f21712'),(86,86,1,NULL,NULL,1,'2022-07-07 05:45:24','2022-07-07 05:45:24','6915c3f1-bdf1-4e18-bc67-c8ff5bf6e5a7'),(87,87,1,NULL,NULL,1,'2022-07-07 05:45:26','2022-07-07 05:45:26','8e29ac16-0bdd-4b55-b6a4-a22034559ce3'),(88,88,1,NULL,NULL,1,'2022-07-07 05:45:27','2022-07-07 05:45:27','7d0a4c40-67d8-4a41-865a-eb94e1c0fe66'),(90,90,1,NULL,NULL,1,'2022-07-07 05:45:36','2022-07-07 05:45:36','73c87d4e-1f8e-4b82-bc09-89ef47cc27e0'),(91,91,1,'homepage','__home__',1,'2022-07-07 05:45:36','2022-07-07 05:45:36','6cba85d2-adda-432d-9746-86f1b0d7a89e'),(92,92,1,NULL,NULL,1,'2022-07-07 05:45:36','2022-07-07 05:45:36','8befa66c-9939-4983-bce4-6a3309df901e'),(93,93,1,NULL,NULL,1,'2022-07-07 05:45:36','2022-07-07 05:45:36','d4e653c5-a5ae-4517-858b-8a158c4e09bc'),(94,94,1,NULL,NULL,1,'2022-07-07 05:45:36','2022-07-07 05:45:36','9e0d720f-fc7f-4a08-92a6-0780c601dd65'),(96,96,1,'billing-information','billing',1,'2022-07-07 05:46:27','2022-07-07 05:46:27','a4541522-de3b-43ec-b8f9-fe27955e1fe6'),(97,97,1,'billing-information','billing',1,'2022-07-07 05:47:44','2022-07-07 05:47:44','e19edc0b-f818-4d04-9315-2b5602c8ac10'),(102,102,1,'homepage','__home__',1,'2022-07-07 05:48:34','2022-07-07 05:48:34','85c201f5-8cbc-4d66-8eba-9b7a0b48e233'),(103,103,1,NULL,NULL,1,'2022-07-07 05:48:34','2022-07-07 05:48:34','738e4ec0-cfa8-46ff-a2a4-95cc8de30ecb'),(104,104,1,NULL,NULL,1,'2022-07-07 05:48:34','2022-07-07 05:48:34','7e938af5-39b1-41b9-9969-51b6053ed4d4'),(105,105,1,NULL,NULL,1,'2022-07-07 05:48:34','2022-07-07 05:48:34','10e4abf9-00d1-4954-a001-8d247a07d242'),(107,107,1,'billing-information','billing',1,'2022-08-04 02:46:56','2022-08-04 02:46:56','7652aa71-cef5-4d73-85d1-ed0149f9bce4'),(112,112,1,'homepage','__home__',1,'2022-08-05 02:17:34','2022-08-05 02:17:34','72a10dc1-813c-468e-a2a3-1e25222988a2'),(113,113,1,NULL,NULL,1,'2022-08-05 02:17:35','2022-08-05 02:17:35','90f93100-4866-4934-a91c-c2b94ef59af3'),(114,114,1,NULL,NULL,1,'2022-08-05 02:17:35','2022-08-05 02:17:35','d7b92057-7bd4-4b8f-a761-bfd1fff63b66'),(115,115,1,NULL,NULL,1,'2022-08-05 02:17:35','2022-08-05 02:17:35','d2950a2e-5af3-448b-a719-5e547ccfc6d6'),(121,121,1,'homepage','__home__',1,'2022-08-30 05:09:24','2022-08-30 05:09:24','9d97c58f-c513-4fb0-835a-196534fb388e'),(122,122,1,NULL,NULL,1,'2022-08-30 05:09:24','2022-08-30 05:09:24','e76da290-2c51-4719-b2f6-9f13502bf043'),(123,123,1,NULL,NULL,1,'2022-08-30 05:09:24','2022-08-30 05:09:24','e0e38013-34b2-4772-9607-c377b6fb2f23'),(124,124,1,NULL,NULL,1,'2022-08-30 05:09:24','2022-08-30 05:09:24','aeb0bea8-4d30-4d70-ba8f-f18eaf7d8084'),(129,129,1,'billing-information','billing',1,'2022-10-12 01:46:56','2022-10-12 01:46:56','18edf732-16aa-4bb9-ad8c-a3fe1dc0414d'),(130,130,1,'1-5-nasmth','property/1-5-nasmth',1,'2022-10-29 06:06:57','2022-11-30 03:54:14','1764c2c7-ec8f-4bdd-b439-43031e886c74'),(131,131,1,'south','properties/south',1,'2022-10-29 06:07:07','2022-10-29 06:07:07','90fcb91c-4b83-4378-b4d1-d1fb430daa66'),(132,132,1,'111-medina','property/111-medina',1,'2022-10-29 06:07:11','2022-11-30 03:53:59','7fee9f9f-efab-493a-be98-a9ebc3d2ac5a'),(133,133,1,'more-south','properties/more-south',1,'2022-10-29 06:07:29','2022-10-29 06:07:29','e2944d1a-f9fe-4901-9391-a1500a4a540b'),(135,135,1,NULL,NULL,1,'2022-10-29 07:06:47','2022-10-29 07:06:47','7b4fc813-3ef4-4f49-b017-070e6436c645'),(136,136,1,NULL,NULL,1,'2022-10-29 07:06:49','2022-10-29 07:06:49','9ae34325-8251-4e28-9978-e624b2895fc7'),(137,137,1,NULL,NULL,1,'2022-10-29 07:06:49','2022-10-29 07:06:49','9c13506b-4f25-4a89-b1e1-c3492a4cee48'),(138,138,1,NULL,NULL,1,'2022-10-29 07:06:52','2022-10-29 07:06:52','45ecd2cf-ce4a-41d5-8077-e5906101132a'),(139,139,1,NULL,NULL,1,'2022-10-29 07:07:04','2022-10-29 07:07:04','7f717791-197c-48f2-be50-189fe86ae407'),(140,140,1,NULL,NULL,1,'2022-10-29 07:07:08','2022-10-29 07:07:08','94976fc0-3993-4dd7-ba4b-ec4807618e42'),(141,141,1,NULL,NULL,1,'2022-10-29 07:07:12','2022-10-29 07:07:12','737c6e82-cbab-4e3a-94e7-9a520851aac2'),(142,142,1,NULL,NULL,1,'2022-10-29 07:07:12','2022-10-29 07:07:12','1a251411-eb07-43a6-9284-be766207e38f'),(143,143,1,NULL,NULL,1,'2022-10-29 07:07:16','2022-10-29 07:07:16','66cd77d5-2b0b-4b9c-a631-cd66aab0bfda'),(144,144,1,NULL,NULL,1,'2022-10-29 07:07:16','2022-10-29 07:07:16','8492df3a-b11f-4c1d-b6c7-54f4e8731f7c'),(145,145,1,NULL,NULL,1,'2022-10-29 07:08:20','2022-10-29 07:08:20','5d431684-110a-4bee-8f16-ae63353bfa91'),(146,146,1,NULL,NULL,1,'2022-10-29 07:08:25','2022-10-29 07:08:25','8c73e581-d144-4afc-a963-944a59ec59ff'),(147,147,1,NULL,NULL,1,'2022-10-29 07:08:25','2022-10-29 07:08:25','bbdb53ec-9b31-4466-9507-10ab2973491d'),(150,150,1,NULL,NULL,1,'2022-10-29 07:10:22','2022-10-29 07:10:22','350d5cb5-8df9-4f26-a231-e7f49f3596bd'),(151,151,1,NULL,NULL,1,'2022-10-29 07:10:22','2022-10-29 07:10:22','c948439d-e18e-4f79-b125-631029ff17b8'),(159,159,1,'homepage','__home__',1,'2022-11-30 03:41:26','2022-11-30 03:41:26','cf160fa8-e2fb-4638-ba23-518e198360b0'),(160,160,1,NULL,NULL,1,'2022-11-30 03:41:26','2022-11-30 03:41:26','5ddfb2cf-e05a-41f1-85e5-0826d796ac81'),(161,161,1,NULL,NULL,1,'2022-11-30 03:41:26','2022-11-30 03:41:26','902bb935-ec20-4c8b-901d-9c1f4306e1c5'),(162,162,1,NULL,NULL,1,'2022-11-30 03:41:26','2022-11-30 03:41:26','b95e28bb-19cd-48c2-8dd3-0ef4eafee317'),(167,167,1,'homepage','__home__',1,'2022-11-30 03:41:53','2022-11-30 03:41:53','bb1e713f-14af-44d9-89c5-3a6642e14403'),(168,168,1,NULL,NULL,1,'2022-11-30 03:41:53','2022-11-30 03:41:53','0b0b3bb9-82da-48ea-9929-ee3456b721ba'),(169,169,1,NULL,NULL,1,'2022-11-30 03:41:53','2022-11-30 03:41:53','407453a8-b74f-45e8-be4e-02aba1f73c5d'),(170,170,1,NULL,NULL,1,'2022-11-30 03:41:53','2022-11-30 03:41:53','603b26c1-2582-4d15-9cdb-d66c0535df06'),(177,177,1,NULL,NULL,1,'2022-11-30 04:38:30','2022-11-30 04:38:30','4e9659a1-d7ff-47fe-b4aa-2a57b7d72492'),(178,178,1,NULL,NULL,1,'2022-11-30 04:38:35','2022-11-30 04:38:35','d4e7d045-0d48-490a-a0b3-81f315bdbef9'),(179,179,1,NULL,NULL,1,'2022-11-30 04:39:18','2022-11-30 04:39:18','ecd6f8ac-6f32-4e17-881a-1f7e42cf35f8'),(180,180,1,NULL,NULL,1,'2022-11-30 04:39:29','2022-11-30 04:39:29','4b6d6508-1a26-4b45-9b17-f82e0ab8d669'),(181,181,1,NULL,NULL,1,'2022-11-30 04:39:31','2022-11-30 04:39:31','4ccb70f8-bdb2-4e1a-9367-1cc66f0368e9'),(182,182,1,NULL,NULL,1,'2022-11-30 04:39:33','2022-11-30 04:39:33','35be446e-e5a4-4357-8018-ad6332edeb01'),(183,183,1,NULL,NULL,1,'2022-11-30 04:39:34','2022-11-30 04:39:34','796bf730-36a2-4226-9a53-a914d69199ca'),(184,184,1,NULL,NULL,1,'2022-11-30 04:39:37','2022-11-30 04:39:37','9c67022c-1e9b-4891-8913-83ae900ac5c9'),(185,185,1,NULL,NULL,1,'2022-11-30 04:39:39','2022-11-30 04:39:39','8d104528-7a1f-4ee4-941f-3f3f138efe47'),(186,186,1,NULL,NULL,1,'2022-11-30 04:39:40','2022-11-30 04:39:40','fa3c7a15-8953-4a3c-8356-c8462fe4b1ee'),(188,188,1,NULL,NULL,1,'2022-11-30 04:39:49','2022-11-30 04:39:49','7eb259a6-f342-4452-b19d-1551ab3a648a'),(195,195,1,'homepage','__home__',1,'2022-11-30 04:49:18','2022-11-30 04:49:18','f56f85ad-db88-403b-8d39-4b7bf97f7712'),(196,196,1,NULL,NULL,1,'2022-11-30 04:49:18','2022-11-30 04:49:18','aa90390f-26ba-45b7-b1b8-58c4e3a3bb7b'),(197,197,1,NULL,NULL,1,'2022-11-30 04:49:18','2022-11-30 04:49:18','b76f8f0e-3d60-42e5-b2d9-f892f7ae9828'),(198,198,1,NULL,NULL,1,'2022-11-30 04:49:18','2022-11-30 04:49:18','8d17c71b-4dd1-42c0-bdf8-5ee31740c71d'),(199,199,1,'1-5-nasmyth-rockingham','property/1-5-nasmyth-rockingham',1,'2022-12-01 07:17:31','2022-12-01 07:17:54','d444b116-f7f3-4e08-b87a-9d3e1899a1ed'),(200,200,1,NULL,NULL,1,'2022-12-01 07:21:46','2022-12-01 07:21:46','bcbe3e43-0c1a-47c3-9b94-8c5ed86ec9b2'),(205,205,1,NULL,NULL,1,'2022-12-01 07:51:00','2022-12-01 07:51:00','2090af22-8f22-4f2a-a905-ddbc7aa0adf5'),(207,207,1,NULL,NULL,1,'2023-01-19 15:27:32','2023-01-19 15:27:32','b04b6eb0-3fa0-4c8e-9b1b-34dbef8799ed'),(210,210,1,'homepage','__home__',1,'2023-01-19 15:27:32','2023-01-19 15:27:32','667f56fc-5e12-45a3-b589-628283f3ef2b'),(211,211,1,NULL,NULL,1,'2023-01-19 15:27:33','2023-01-19 15:27:33','90ad17b7-2b84-4f31-885b-9b5afcc0c02d'),(212,212,1,NULL,NULL,1,'2023-01-19 15:27:33','2023-01-19 15:27:33','032248a8-8dd3-4a7e-8b11-2729180ab6b0'),(214,214,1,'1-5-nasmyth-rockingham','property/1-5-nasmyth-rockingham',1,'2023-02-16 07:39:27','2023-02-16 07:39:27','75fa4643-34d7-4dec-8936-a4e31b5a1f92'),(215,215,1,NULL,NULL,1,'2023-02-16 07:39:27','2023-02-16 07:39:27','7b3e94f3-878c-468e-b25d-9eca24e20f7d'),(216,216,1,'homepage','__home__',1,'2023-03-14 04:04:27','2023-03-14 04:04:27','91d76c20-fea6-49c6-8890-800a81aaba0e'),(217,217,1,NULL,NULL,1,'2023-03-14 04:04:27','2023-03-14 04:04:27','df097661-ef39-44b7-9140-d2187f881616'),(218,218,1,NULL,NULL,1,'2023-03-14 04:04:27','2023-03-14 04:04:27','31ab71cc-50c4-4ce3-8675-289857283b0f'),(221,221,1,'111-medina','property/111-medina',1,'2023-04-19 02:38:45','2023-04-19 02:38:45','0c5a5114-db67-41f5-9406-d6759d39b53d'),(222,222,1,NULL,NULL,1,'2023-04-19 02:38:45','2023-04-19 02:38:45','57033c2a-5fda-4603-9713-43bfaaec2244'),(223,223,1,NULL,NULL,1,'2023-04-19 02:38:45','2023-04-19 02:38:45','f8dd12b9-be12-4990-839e-41585c9c9ec3'),(224,224,1,'billing-information','billing',1,'2023-04-19 03:21:49','2023-04-19 03:21:49','2c78eb41-dd67-4d4d-9238-f88d493480ed');
/*!40000 ALTER TABLE `elements_sites` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `entries`
--

LOCK TABLES `entries` WRITE;
/*!40000 ALTER TABLE `entries` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `entries` VALUES (2,1,NULL,1,NULL,'2022-07-04 02:21:00',NULL,NULL,'2022-07-04 02:21:22','2022-07-04 02:21:22','0aaf9bd4-7a56-4192-8977-a3be02c9832b'),(3,1,NULL,1,NULL,'2022-07-04 02:21:00',NULL,NULL,'2022-07-04 02:21:22','2022-07-04 02:21:22','3fa8cdf3-f94c-4c97-af32-840e3fc6c3bc'),(4,1,NULL,1,NULL,'2022-07-04 02:21:00',NULL,NULL,'2022-07-04 02:27:09','2022-07-04 02:27:09','ef55cef5-4293-4fbd-8f6d-ba63a9af7aa2'),(6,1,NULL,1,NULL,'2022-07-04 02:21:00',NULL,NULL,'2022-07-04 02:27:32','2022-07-04 02:27:32','8867ff8b-cf14-47b3-a0e3-41a945be8d9b'),(8,1,NULL,1,NULL,'2022-07-04 02:21:00',NULL,NULL,'2022-07-04 03:01:54','2022-07-04 03:01:54','98aa2123-1e26-4d61-8e82-52a00bd603e8'),(9,1,NULL,1,NULL,'2022-07-04 02:21:00',NULL,NULL,'2022-07-04 03:07:06','2022-07-04 03:07:06','9e06f0ce-809d-42fa-a8d0-8855bd87f2c6'),(16,1,NULL,1,NULL,'2022-07-04 02:21:00',NULL,NULL,'2022-07-04 03:07:53','2022-07-04 03:07:53','e0c90532-11fb-4312-8288-e542c873a946'),(20,1,NULL,1,NULL,'2022-07-04 02:21:00',NULL,NULL,'2022-07-04 03:22:10','2022-07-04 03:22:10','1fca340a-9c89-42bf-b178-29c65f417921'),(24,1,NULL,1,NULL,'2022-07-04 02:21:00',NULL,NULL,'2022-07-04 03:25:00','2022-07-04 03:25:00','129e40fd-18e7-4240-94f8-3d45b997159f'),(28,1,NULL,1,NULL,'2022-07-04 02:21:00',NULL,NULL,'2022-07-04 03:33:42','2022-07-04 03:33:42','3d0cf9fb-a0fc-413b-b090-609c15820cd6'),(30,2,NULL,2,NULL,'2022-07-04 03:42:00',NULL,1,'2022-07-04 03:42:17','2022-07-04 03:42:17','d602394c-fee8-4b3f-8ebb-24fe40b38839'),(31,2,NULL,2,NULL,'2022-07-04 03:42:00',NULL,NULL,'2022-07-04 03:42:17','2022-07-04 03:42:17','d20d0a37-eb85-4387-8c25-1f3f4f7145ee'),(32,3,NULL,3,NULL,'2022-07-04 03:47:00',NULL,NULL,'2022-07-04 03:47:00','2022-07-04 03:47:00','61b6b027-90ff-461d-85b0-380cf306f4b9'),(46,1,NULL,1,NULL,'2022-07-04 02:21:00',NULL,NULL,'2022-07-04 03:49:16','2022-07-04 03:49:16','0c32abdd-6239-47de-a67c-df4ecb4e1edd'),(53,1,NULL,1,NULL,'2022-07-04 02:21:00',NULL,NULL,'2022-07-04 04:03:28','2022-07-04 04:03:28','c94c1ace-5155-4735-bcaf-14124586c354'),(59,1,NULL,1,NULL,'2022-07-04 02:21:00',NULL,NULL,'2022-07-04 04:04:15','2022-07-04 04:04:15','b89d796a-85ed-4bd6-98d1-b15a6ca53e58'),(65,1,NULL,1,NULL,'2022-07-04 02:21:00',NULL,NULL,'2022-07-04 04:35:25','2022-07-04 04:35:25','bbc35633-eeb7-4d92-a54e-692178149428'),(72,1,NULL,1,NULL,'2022-07-04 02:21:00',NULL,NULL,'2022-07-05 02:12:53','2022-07-05 02:12:53','b2b06ebe-6961-4a31-b1b5-1f7c9aee91e9'),(76,4,NULL,4,NULL,'2022-07-07 05:39:00',NULL,NULL,'2022-07-07 05:39:33','2022-07-07 05:44:53','466d6254-ccde-4fb3-85f4-404606447665'),(77,4,NULL,4,1,'2022-07-07 05:39:00',NULL,NULL,'2022-07-07 05:43:54','2022-07-07 05:43:54','d960529e-632f-411d-b67c-ea624e2f5223'),(78,4,NULL,4,NULL,'2022-07-07 05:44:00',NULL,0,'2022-07-07 05:44:03','2022-07-07 05:44:54','1b183582-3c74-4ea6-bc03-132d7bdfa822'),(79,4,NULL,4,NULL,'2022-07-07 05:39:00',NULL,NULL,'2022-07-07 05:44:53','2022-07-07 05:44:53','6844b90f-c1f6-40cc-a338-54bdc7b9af13'),(81,4,NULL,4,NULL,'2022-07-07 05:39:00',NULL,NULL,'2022-07-07 05:45:10','2022-07-07 05:45:10','0ddd66b6-3e47-4fe7-9bb0-2565887e3018'),(91,1,NULL,1,NULL,'2022-07-04 02:21:00',NULL,NULL,'2022-07-07 05:45:36','2022-07-07 05:45:36','a1dddd34-783d-41d1-a07c-88b790bce6aa'),(96,4,NULL,4,NULL,'2022-07-07 05:39:00',NULL,NULL,'2022-07-07 05:46:27','2022-07-07 05:46:27','a1156698-52f2-4a49-81f8-e5b709f1f239'),(97,4,NULL,4,NULL,'2022-07-07 05:39:00',NULL,NULL,'2022-07-07 05:47:44','2022-07-07 05:47:44','b8ee9a99-e22f-4f45-9dd9-9aa17c651373'),(102,1,NULL,1,NULL,'2022-07-04 02:21:00',NULL,NULL,'2022-07-07 05:48:34','2022-07-07 05:48:34','d26920c4-b161-4493-a117-f88d3939449a'),(107,4,NULL,4,NULL,'2022-07-07 05:39:00',NULL,NULL,'2022-08-04 02:46:56','2022-08-04 02:46:56','540819c3-765a-4cde-9330-21a11a0ed34c'),(112,1,NULL,1,NULL,'2022-07-04 02:21:00',NULL,NULL,'2022-08-05 02:17:34','2022-08-05 02:17:34','d7b086bd-fc33-4a40-8e45-fc2eef8c1403'),(121,1,NULL,1,NULL,'2022-07-04 02:21:00',NULL,NULL,'2022-08-30 05:09:24','2022-08-30 05:09:24','75708c58-f900-4f33-a129-4294b1b3efb3'),(129,4,NULL,4,NULL,'2022-07-07 05:39:00',NULL,NULL,'2022-10-12 01:46:56','2022-10-12 01:46:56','f20b78a5-6432-4134-8e96-355d31e539ea'),(130,5,NULL,6,1,'2022-10-29 06:06:00',NULL,1,'2022-10-29 06:06:57','2022-10-29 07:10:22','f265d6ab-76b7-4cb9-9000-f94a70e4002a'),(131,5,NULL,5,1,'2022-10-29 06:06:00',NULL,NULL,'2022-10-29 06:07:07','2022-10-29 06:07:07','4754d222-b4a0-4fc7-9285-fd0da3c6e2e2'),(132,5,NULL,5,1,'2022-10-29 06:07:00',NULL,NULL,'2022-10-29 06:07:11','2022-10-29 06:07:11','22ecd852-caaa-49d0-b68b-38fd0fbbeb4c'),(133,5,NULL,5,1,'2022-10-29 06:07:00',NULL,NULL,'2022-10-29 06:07:29','2022-10-29 06:07:29','a32b5bb1-eecf-4773-988f-0c4bf7dd15d9'),(159,1,NULL,1,NULL,'2022-07-04 02:21:00',NULL,NULL,'2022-11-30 03:41:26','2022-11-30 03:41:26','7c580d8a-bf31-429e-9bba-f2cdf6278e89'),(167,1,NULL,1,NULL,'2022-07-04 02:21:00',NULL,NULL,'2022-11-30 03:41:53','2022-11-30 03:41:53','f3e75dd8-273f-4546-a7d3-1414be5fc5b7'),(195,1,NULL,1,NULL,'2022-07-04 02:21:00',NULL,NULL,'2022-11-30 04:49:18','2022-11-30 04:49:18','7a764e9b-ffaf-451c-bf09-211d8316daec'),(199,5,NULL,5,1,'2022-12-01 07:17:00',NULL,NULL,'2022-12-01 07:17:31','2022-12-01 07:17:31','58fe3db1-3738-41ea-8f08-a84297252e3a'),(210,1,NULL,1,NULL,'2022-07-04 02:21:00',NULL,NULL,'2023-01-19 15:27:32','2023-01-19 15:27:32','3409fbb5-3ae5-42bb-8414-dbfb77fcf5c2'),(214,5,NULL,5,1,'2022-12-01 07:17:00',NULL,NULL,'2023-02-16 07:39:27','2023-02-16 07:39:27','49c087ff-fe4a-4e3c-b407-86e2dc82fdbf'),(216,1,NULL,1,NULL,'2022-07-04 02:21:00',NULL,NULL,'2023-03-14 04:04:27','2023-03-14 04:04:27','e9f38b40-38ab-4b93-9c60-8f688d41be93'),(221,5,NULL,5,1,'2022-10-29 06:07:00',NULL,NULL,'2023-04-19 02:38:45','2023-04-19 02:38:45','8655b45e-051d-44c3-ad32-960f5c98bdde'),(224,4,NULL,4,NULL,'2022-07-07 05:39:00',NULL,NULL,'2023-04-19 03:21:49','2023-04-19 03:21:49','ba33cac9-28bc-4438-a216-b3103b265ca6');
/*!40000 ALTER TABLE `entries` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `entrytypes`
--

LOCK TABLES `entrytypes` WRITE;
/*!40000 ALTER TABLE `entrytypes` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `entrytypes` VALUES (1,1,1,'Homepage','homepage',0,'site',NULL,'{section.name|raw}',1,'2022-07-04 02:21:22','2022-07-04 02:21:22',NULL,'e10cefd1-b1af-40d8-90e6-e69c462e039c'),(2,2,3,'ContentPage','contentPage',0,'site',NULL,'{section.name|raw}',1,'2022-07-04 03:42:17','2022-07-04 03:42:17','2022-07-04 03:43:07','345a7003-8ce2-4569-91de-737fe9d59497'),(3,3,4,'Maintainece','maintainece',0,'site',NULL,'{section.name|raw}',1,'2022-07-04 03:47:00','2022-07-04 03:47:00',NULL,'9239b6a0-41c5-4717-b44d-27a4bb071832'),(4,4,6,'Billing','billing',1,'site',NULL,NULL,1,'2022-07-07 05:39:06','2022-07-07 05:44:53',NULL,'388d274a-addd-4e8e-9b91-4eaec06ff3f9'),(5,5,7,'Default','default',1,'site',NULL,NULL,2,'2022-10-29 05:30:14','2022-10-29 07:02:33',NULL,'cf39e515-68eb-4f8e-bac3-b7928c230eb6'),(6,5,11,'property','property',1,'site',NULL,NULL,1,'2022-10-29 06:56:25','2022-10-29 07:02:33','2022-11-30 03:56:59','f97c4a52-912f-414a-b7ca-b99ec89bfbd7');
/*!40000 ALTER TABLE `entrytypes` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `fieldgroups`
--

LOCK TABLES `fieldgroups` WRITE;
/*!40000 ALTER TABLE `fieldgroups` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `fieldgroups` VALUES (1,'Common','2022-07-04 01:44:27','2022-07-04 01:44:27',NULL,'fd8a69c8-4f31-4c6f-bcba-c9f9a4351053'),(2,'home','2022-07-04 02:25:37','2022-07-04 02:25:37',NULL,'a29c4e08-0ee4-463d-a469-38769ac088da'),(3,'Property Blocks','2022-10-29 06:17:26','2022-10-29 06:17:40',NULL,'4532e13c-52d3-48d5-a1ab-a9526b969b3d');
/*!40000 ALTER TABLE `fieldgroups` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `fieldlayoutfields`
--

LOCK TABLES `fieldlayoutfields` WRITE;
/*!40000 ALTER TABLE `fieldlayoutfields` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `fieldlayoutfields` VALUES (5,1,4,1,0,1,'2022-07-04 03:07:06','2022-07-04 03:07:06','7566492b-0a11-4466-a125-3ee315f0d72a'),(6,1,4,3,0,2,'2022-07-04 03:07:06','2022-07-04 03:07:06','306ed785-fb5e-4782-b10e-05762c1b632f'),(7,2,5,5,0,0,'2022-07-04 03:31:57','2022-07-04 03:31:57','6aa5eb4f-73b5-4e5a-bce7-5cfd908504ef'),(8,2,5,4,0,1,'2022-07-04 03:31:57','2022-07-04 03:31:57','c8dcfba4-4152-4e13-a701-6adf1962813f'),(9,2,5,6,0,2,'2022-07-04 03:31:57','2022-07-04 03:31:57','ddf5e1ae-4c59-4ea7-87c9-ac72054604f0'),(10,4,8,2,0,1,'2022-07-04 03:47:23','2022-07-04 03:47:23','927bbcd3-eda5-48a2-b7cd-3da126aef748'),(12,6,12,2,0,1,'2022-07-07 05:44:53','2022-07-07 05:44:53','45d582e5-84fe-43d3-bd50-1b6bf892b30f'),(21,12,22,14,0,0,'2022-11-30 04:10:03','2022-11-30 04:10:03','b5240420-4972-4724-861a-ad7ce7d5e799'),(22,12,22,12,0,1,'2022-11-30 04:10:03','2022-11-30 04:10:03','e498c759-9323-4397-813e-2057d317b2a4'),(23,12,22,13,0,2,'2022-11-30 04:10:03','2022-11-30 04:10:03','7642d2d5-1692-42d1-a78b-35d5c1de1696'),(26,7,24,2,0,1,'2022-12-01 07:19:38','2022-12-01 07:19:38','e28a8e1d-23b8-4bd0-93c8-147577e6f842'),(27,7,24,11,0,2,'2022-12-01 07:19:38','2022-12-01 07:19:38','dd56772c-d88b-437e-a483-81a08ca2b6d5'),(28,7,24,15,0,3,'2022-12-01 07:19:38','2022-12-01 07:19:38','a81cbd84-d9b2-473a-b606-25c0b5c177d6');
/*!40000 ALTER TABLE `fieldlayoutfields` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `fieldlayouts`
--

LOCK TABLES `fieldlayouts` WRITE;
/*!40000 ALTER TABLE `fieldlayouts` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `fieldlayouts` VALUES (1,'craft\\elements\\Entry','2022-07-04 02:21:22','2022-07-04 02:21:22',NULL,'a78266ac-58ed-41d9-b02d-1f07d7e1a2af'),(2,'craft\\elements\\MatrixBlock','2022-07-04 03:06:37','2022-07-04 03:06:37',NULL,'18fb859b-6081-49cb-b81c-92b73eeb07d3'),(3,'craft\\elements\\Entry','2022-07-04 03:42:17','2022-07-04 03:42:17','2022-07-04 03:43:07','935c3fd4-fef7-460b-8c83-f26c540f0e53'),(4,'craft\\elements\\Entry','2022-07-04 03:47:00','2022-07-04 03:47:00',NULL,'9147e7b2-af7d-485c-b41c-a324a92ec37c'),(5,'craft\\elements\\Asset','2022-07-04 03:59:55','2022-07-04 03:59:55',NULL,'219cccb7-50d4-4bbe-bf5a-33a900b3010a'),(6,'craft\\elements\\Entry','2022-07-07 05:39:06','2022-07-07 05:39:06',NULL,'a59d09ab-2a57-488d-af10-b75cd38ab57a'),(7,'craft\\elements\\Entry','2022-10-29 05:30:14','2022-10-29 05:30:14',NULL,'cbd014c1-6ba3-4fc5-8f0c-70a551b4728f'),(8,'craft\\elements\\Asset','2022-10-29 06:52:18','2022-10-29 06:52:18',NULL,'1edcbe18-0a6a-484e-a01c-c5681fa0d9e7'),(9,'craft\\elements\\MatrixBlock','2022-10-29 06:52:38','2022-10-29 06:52:38','2022-11-30 03:58:07','992df285-587d-41e3-853c-f021f1c1d7cc'),(10,'craft\\elements\\MatrixBlock','2022-10-29 06:52:38','2022-10-29 06:52:38','2022-11-30 03:58:07','d181de75-2d97-45ce-8ec3-38b82b093205'),(11,'craft\\elements\\Entry','2022-10-29 06:56:25','2022-10-29 06:56:25','2022-11-30 03:56:59','a92ce952-508d-450d-8886-e98ed7effdb4'),(12,'craft\\elements\\MatrixBlock','2022-11-30 04:10:03','2022-11-30 04:10:03',NULL,'8e8fc1d7-9656-4857-8d0a-2c3acee9d885');
/*!40000 ALTER TABLE `fieldlayouts` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `fieldlayouttabs`
--

LOCK TABLES `fieldlayouttabs` WRITE;
/*!40000 ALTER TABLE `fieldlayouttabs` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `fieldlayouttabs` VALUES (4,1,'Content','[{\"type\":\"craft\\\\fieldlayoutelements\\\\EntryTitleField\",\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"fieldUid\":\"32578409-4596-4fe9-b40a-530ea041c7e5\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"fieldUid\":\"11c4fb00-409a-473d-bf23-ed69a40ccec3\"}]',1,'2022-07-04 03:07:06','2022-07-04 03:07:06','db5aeb20-e9be-45ac-89fc-d6acd76c9ac5'),(5,2,'Content','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"fieldUid\":\"870bcb50-af4e-4c19-867a-e05088f23ca5\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"fieldUid\":\"0b54bcb2-2233-4648-8a6d-fcc710ba10b2\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"fieldUid\":\"1229c6cf-f0e1-44b4-af52-b591d2cddb65\"}]',1,'2022-07-04 03:31:57','2022-07-04 03:31:57','c3701d94-47d0-43f5-b4fd-6e5eb311c0d2'),(6,3,'Content','[{\"type\":\"craft\\\\fieldlayoutelements\\\\EntryTitleField\",\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100}]',1,'2022-07-04 03:42:17','2022-07-04 03:42:17','92b97f2f-9720-476a-a58c-778336d0c23b'),(8,4,'Content','[{\"type\":\"craft\\\\fieldlayoutelements\\\\EntryTitleField\",\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"fieldUid\":\"b33ec018-8c1d-4b91-8711-31e8b020ce0a\"}]',1,'2022-07-04 03:47:23','2022-07-04 03:47:23','47d70d37-7568-4865-974c-d247189df912'),(9,5,'Content','[{\"type\":\"craft\\\\fieldlayoutelements\\\\AssetTitleField\",\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100}]',1,'2022-07-04 03:59:56','2022-07-04 03:59:56','93938483-a85e-4c4c-8ee8-a5e718ae20e6'),(12,6,'Content','[{\"type\":\"craft\\\\fieldlayoutelements\\\\EntryTitleField\",\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"fieldUid\":\"b33ec018-8c1d-4b91-8711-31e8b020ce0a\"}]',1,'2022-07-07 05:44:53','2022-07-07 05:44:53','984f3ec7-cd56-4de0-9a5c-9b357bb31550'),(17,9,'Content','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"fieldUid\":\"7da2d549-b273-40bf-ad51-e8fe2202460e\"}]',1,'2022-10-29 06:54:54','2022-10-29 06:54:54','e7e34424-af18-4875-bce2-36e863417504'),(18,10,'Content','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"fieldUid\":\"1133b123-9600-4fc1-b59b-f51011da76fe\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"fieldUid\":\"128cde9d-33b0-4d0a-a8b7-c12ab3eff8bc\"}]',1,'2022-10-29 06:54:54','2022-10-29 06:54:54','732746d5-e6ec-4cd5-9b0c-ef7a6a755bc1'),(20,11,'Content','[{\"type\":\"craft\\\\fieldlayoutelements\\\\EntryTitleField\",\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"fieldUid\":\"e70fc45a-cbbb-4aef-be6c-f780e34a4791\"}]',1,'2022-10-29 07:02:33','2022-10-29 07:02:33','72de4b10-717b-4a5f-88cb-e0366ad4fbe6'),(22,12,'Content','[{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"fieldUid\":\"f617a4e5-c7c4-49bd-9517-db6b7c84742d\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"fieldUid\":\"b76e1673-8377-4694-9733-d468ac184644\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"fieldUid\":\"bf766438-211a-4b0a-818c-da0f4533ae65\"}]',1,'2022-11-30 04:10:03','2022-11-30 04:10:03','653c6f3e-9927-4227-a5ab-0c3f274a5bb5'),(24,7,'Content','[{\"type\":\"craft\\\\fieldlayoutelements\\\\EntryTitleField\",\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"fieldUid\":\"b33ec018-8c1d-4b91-8711-31e8b020ce0a\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"fieldUid\":\"5a9cab0c-2379-4a70-b9b3-76426c59833e\"},{\"type\":\"craft\\\\fieldlayoutelements\\\\CustomField\",\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"required\":false,\"width\":100,\"fieldUid\":\"b7392388-c0aa-4007-ba39-5f268f0a2bbe\"}]',1,'2022-12-01 07:19:38','2022-12-01 07:19:38','3c87561a-4269-4355-9f2a-0750cb2667cb'),(26,8,'Content','[{\"type\":\"craft\\\\fieldlayoutelements\\\\AssetTitleField\",\"autocomplete\":false,\"class\":null,\"size\":null,\"name\":null,\"autocorrect\":true,\"autocapitalize\":true,\"disabled\":false,\"readonly\":false,\"title\":null,\"placeholder\":null,\"step\":null,\"min\":null,\"max\":null,\"requirable\":false,\"id\":null,\"containerAttributes\":[],\"inputContainerAttributes\":[],\"labelAttributes\":[],\"orientation\":null,\"label\":null,\"instructions\":null,\"tip\":null,\"warning\":null,\"width\":100}]',1,'2022-12-01 07:52:59','2022-12-01 07:52:59','8d2da9a5-24b4-4d2d-b80d-2a95c0b3bb62');
/*!40000 ALTER TABLE `fieldlayouttabs` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `fields`
--

LOCK TABLES `fields` WRITE;
/*!40000 ALTER TABLE `fields` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `fields` VALUES (1,2,'introduction','introduction','global','oldpmmwb','Just basic introduction text',0,'none',NULL,'craft\\redactor\\Field','{\"availableTransforms\":\"*\",\"availableVolumes\":\"*\",\"columnType\":\"text\",\"configSelectionMode\":\"choose\",\"defaultTransform\":\"\",\"manualConfig\":\"\",\"purifierConfig\":\"\",\"purifyHtml\":\"1\",\"redactorConfig\":\"\",\"removeEmptyTags\":\"1\",\"removeInlineStyles\":\"1\",\"removeNbsp\":\"1\",\"showHtmlButtonForNonAdmins\":\"\",\"showUnpermittedFiles\":false,\"showUnpermittedVolumes\":false,\"uiMode\":\"enlarged\"}','2022-07-04 02:22:42','2022-07-04 02:25:47','32578409-4596-4fe9-b40a-530ea041c7e5'),(2,1,'Pagecopy','pagecopy','global','rbegzurr','just the main stuff of the page',0,'none',NULL,'craft\\redactor\\Field','{\"availableTransforms\":\"*\",\"availableVolumes\":\"*\",\"columnType\":\"text\",\"configSelectionMode\":\"choose\",\"defaultTransform\":\"\",\"manualConfig\":\"\",\"purifierConfig\":\"\",\"purifyHtml\":\"1\",\"redactorConfig\":\"\",\"removeEmptyTags\":\"1\",\"removeInlineStyles\":\"1\",\"removeNbsp\":\"1\",\"showHtmlButtonForNonAdmins\":\"\",\"showUnpermittedFiles\":false,\"showUnpermittedVolumes\":false,\"uiMode\":\"enlarged\"}','2022-07-04 02:26:13','2022-07-04 02:26:13','b33ec018-8c1d-4b91-8711-31e8b020ce0a'),(3,2,'Pagelinks','pagelinks','global',NULL,'',0,'site',NULL,'craft\\fields\\Matrix','{\"contentTable\":\"{{%matrixcontent_pagelinks}}\",\"maxBlocks\":\"10\",\"minBlocks\":\"1\",\"propagationKeyFormat\":null,\"propagationMethod\":\"all\"}','2022-07-04 03:06:36','2022-07-04 03:06:36','11c4fb00-409a-473d-bf23-ed69a40ccec3'),(4,NULL,'path','path','matrixBlockType:6c13d5a4-07fa-4982-9011-8299498c1ad3','jdjmkifc','path to the link',0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":100,\"code\":\"\",\"columnType\":null,\"initialRows\":\"4\",\"multiline\":\"\",\"placeholder\":\"Path\",\"uiMode\":\"normal\"}','2022-07-04 03:06:37','2022-07-04 03:06:37','0b54bcb2-2233-4648-8a6d-fcc710ba10b2'),(5,NULL,'Linkname','linkname','matrixBlockType:6c13d5a4-07fa-4982-9011-8299498c1ad3','dotldesy','',0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":50,\"code\":\"\",\"columnType\":null,\"initialRows\":\"4\",\"multiline\":\"\",\"placeholder\":\"Name \",\"uiMode\":\"normal\"}','2022-07-04 03:06:37','2022-07-04 03:06:37','870bcb50-af4e-4c19-867a-e05088f23ca5'),(6,NULL,'description','description','matrixBlockType:6c13d5a4-07fa-4982-9011-8299498c1ad3','czvzkzmw','',0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":200,\"code\":\"\",\"columnType\":null,\"initialRows\":\"4\",\"multiline\":\"\",\"placeholder\":\"Description\",\"uiMode\":\"normal\"}','2022-07-04 03:06:37','2022-07-04 03:06:37','1229c6cf-f0e1-44b4-af52-b591d2cddb65'),(11,3,'service providers','serviceProviders','global',NULL,'recommend service providers ',0,'site',NULL,'craft\\fields\\Matrix','{\"contentTable\":\"{{%matrixcontent_serviceproviders}}\",\"maxBlocks\":\"\",\"minBlocks\":\"\",\"propagationKeyFormat\":null,\"propagationMethod\":\"all\"}','2022-11-30 04:10:03','2022-11-30 04:10:03','5a9cab0c-2379-4a70-b9b3-76426c59833e'),(12,NULL,'business type','businessType','matrixBlockType:87abb876-efda-45ae-b75c-9df708501a10','dkbjfaab','Type of business',0,'none',NULL,'craft\\fields\\Dropdown','{\"optgroups\":true,\"options\":[{\"label\":\"Air Conditioning\",\"value\":\"airConditioning\",\"default\":\"\"},{\"label\":\"Shutter Repair\",\"value\":\"shutterRepair\",\"default\":\"\"}]}','2022-11-30 04:10:03','2022-11-30 04:10:03','b76e1673-8377-4694-9733-d468ac184644'),(13,NULL,'contact details','contactDetails','matrixBlockType:87abb876-efda-45ae-b75c-9df708501a10','epbvbqny','',0,'none',NULL,'craft\\redactor\\Field','{\"availableTransforms\":\"*\",\"availableVolumes\":\"*\",\"columnType\":\"text\",\"configSelectionMode\":\"choose\",\"defaultTransform\":\"\",\"manualConfig\":\"\",\"purifierConfig\":\"\",\"purifyHtml\":\"1\",\"redactorConfig\":\"\",\"removeEmptyTags\":\"1\",\"removeInlineStyles\":\"1\",\"removeNbsp\":\"1\",\"showHtmlButtonForNonAdmins\":\"\",\"showUnpermittedFiles\":false,\"showUnpermittedVolumes\":false,\"uiMode\":\"enlarged\"}','2022-11-30 04:10:03','2022-11-30 04:10:03','bf766438-211a-4b0a-818c-da0f4533ae65'),(14,NULL,'business name','businessName','matrixBlockType:87abb876-efda-45ae-b75c-9df708501a10','ixuxkuzm','',0,'none',NULL,'craft\\fields\\PlainText','{\"byteLimit\":null,\"charLimit\":null,\"code\":\"\",\"columnType\":null,\"initialRows\":\"4\",\"multiline\":\"\",\"placeholder\":null,\"uiMode\":\"normal\"}','2022-11-30 04:10:03','2022-11-30 04:10:03','f617a4e5-c7c4-49bd-9517-db6b7c84742d'),(15,3,'main image','mainImage','global',NULL,'Picture of the property',0,'site',NULL,'craft\\fields\\Assets','{\"allowSelfRelations\":false,\"allowUploads\":true,\"allowedKinds\":null,\"defaultUploadLocationSource\":\"volume:4691da8f-b71c-465a-a5df-29d41a87e0a5\",\"defaultUploadLocationSubpath\":\"\",\"limit\":\"\",\"localizeRelations\":false,\"previewMode\":\"full\",\"restrictFiles\":\"\",\"selectionLabel\":\"\",\"showSiteMenu\":true,\"showUnpermittedFiles\":false,\"showUnpermittedVolumes\":false,\"singleUploadLocationSource\":\"volume:cdc2c8ee-142d-4714-a659-c1b46e254b25\",\"singleUploadLocationSubpath\":\"\",\"source\":null,\"sources\":[\"volume:4691da8f-b71c-465a-a5df-29d41a87e0a5\"],\"targetSiteId\":null,\"useSingleFolder\":false,\"validateRelatedElements\":false,\"viewMode\":\"list\"}','2022-12-01 07:19:20','2022-12-01 07:53:31','b7392388-c0aa-4007-ba39-5f268f0a2bbe');
/*!40000 ALTER TABLE `fields` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `globalsets`
--

LOCK TABLES `globalsets` WRITE;
/*!40000 ALTER TABLE `globalsets` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `globalsets` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `gqlschemas`
--

LOCK TABLES `gqlschemas` WRITE;
/*!40000 ALTER TABLE `gqlschemas` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `gqlschemas` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `gqltokens`
--

LOCK TABLES `gqltokens` WRITE;
/*!40000 ALTER TABLE `gqltokens` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `gqltokens` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `info`
--

LOCK TABLES `info` WRITE;
/*!40000 ALTER TABLE `info` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `info` VALUES (1,'3.8.2','3.8.0.1',1,'pdaiksoeceqo','3@toavebkvhx','2022-07-04 01:44:27','2023-03-16 04:56:47','1cb3f07a-b9a9-4e64-b3df-7a7034a76871');
/*!40000 ALTER TABLE `info` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `matrixblocks`
--

LOCK TABLES `matrixblocks` WRITE;
/*!40000 ALTER TABLE `matrixblocks` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `matrixblocks` VALUES (15,2,3,1,1,0,'2022-07-04 03:07:53','2022-07-04 03:07:53','4107d718-1efb-4582-a7b4-455258ea9698'),(17,16,3,1,1,NULL,'2022-07-04 03:07:53','2022-07-04 03:07:53','52ed1809-e46c-461d-9098-6d3106866649'),(21,20,3,1,1,NULL,'2022-07-04 03:22:10','2022-07-04 03:22:10','c2d26954-1c08-4547-a39b-88e056c2e7d4'),(25,24,3,1,1,NULL,'2022-07-04 03:25:00','2022-07-04 03:25:00','8d2006e7-bcce-4d93-b2fb-73fb3261b685'),(29,28,3,1,1,NULL,'2022-07-04 03:33:42','2022-07-04 03:33:42','d484c165-ed7f-4014-9008-24698887ec7a'),(45,2,3,1,1,NULL,'2022-07-04 03:49:16','2023-01-19 15:27:32','01238273-2475-4df9-b730-cbcb990bd1d6'),(47,46,3,1,1,NULL,'2022-07-04 03:49:16','2022-07-04 03:49:16','058446f0-cdfb-40b9-845e-839ad8032f92'),(48,46,3,1,2,NULL,'2022-07-04 03:49:16','2022-07-04 03:49:16','8cc7e228-0d0f-40e2-a195-f610de140a83'),(54,53,3,1,1,NULL,'2022-07-04 04:03:28','2022-07-04 04:03:28','da253369-c8b3-4a9c-9628-90d44fe6f72d'),(55,53,3,1,2,NULL,'2022-07-04 04:03:28','2022-07-04 04:03:28','6a9a6e7c-4ccb-45f5-b247-7cc63847b453'),(60,59,3,1,1,NULL,'2022-07-04 04:04:15','2022-07-04 04:04:15','2333283f-3713-4c9e-b674-51c993ae5a93'),(61,59,3,1,2,NULL,'2022-07-04 04:04:15','2022-07-04 04:04:15','e1098369-4406-46d7-b53a-b4a923191a0b'),(66,65,3,1,1,NULL,'2022-07-04 04:35:25','2022-07-04 04:35:25','017b6296-e11f-4d0b-9608-cc89c2c5a93d'),(67,65,3,1,2,NULL,'2022-07-04 04:35:25','2022-07-04 04:35:25','04531c85-8e14-4168-8914-5f948fd6a6b4'),(73,72,3,1,1,NULL,'2022-07-05 02:12:53','2022-07-05 02:12:53','13aff0e1-24fc-493e-8776-b3d2039f62e9'),(74,72,3,1,2,NULL,'2022-07-05 02:12:53','2022-07-05 02:12:53','feb1c3a0-0d8d-4975-a07c-4ddb170a0ee8'),(90,2,3,1,2,NULL,'2022-07-07 05:45:36','2023-01-19 15:27:32','b48178dd-9f96-46ae-b776-f4f3c28d0acf'),(92,91,3,1,1,NULL,'2022-07-07 05:45:36','2022-07-07 05:45:36','cec61beb-6c9b-4381-8d6f-6593bb11c08f'),(93,91,3,1,2,NULL,'2022-07-07 05:45:36','2022-07-07 05:45:36','8351a904-a4f7-4dc1-83c6-3cc1269b2c15'),(94,91,3,1,3,NULL,'2022-07-07 05:45:36','2022-07-07 05:45:36','931c901a-7ef1-4d6d-81a8-ca36c2c0b149'),(103,102,3,1,1,NULL,'2022-07-07 05:48:34','2022-07-07 05:48:34','6cf1020c-ff4a-4048-b0fa-63a771a1d482'),(104,102,3,1,2,NULL,'2022-07-07 05:48:34','2022-07-07 05:48:34','8caa4310-dbdf-4bfa-a346-7f0b98ea8fbd'),(105,102,3,1,3,NULL,'2022-07-07 05:48:34','2022-07-07 05:48:34','6d9426fa-86a5-4b9f-b545-23feb788019e'),(113,112,3,1,1,NULL,'2022-08-05 02:17:35','2022-08-05 02:17:35','1d19c737-5fec-4e48-865c-47f6d8e046d7'),(114,112,3,1,2,NULL,'2022-08-05 02:17:35','2022-08-05 02:17:35','974539c7-2ae5-489e-9607-0d41e055baf4'),(115,112,3,1,3,NULL,'2022-08-05 02:17:35','2022-08-05 02:17:35','0d49c407-965b-4c63-a38c-5663a95afc45'),(122,121,3,1,1,NULL,'2022-08-30 05:09:24','2022-08-30 05:09:24','f4266d12-1243-4dc5-bef7-cf4f6470cbfc'),(123,121,3,1,2,NULL,'2022-08-30 05:09:24','2022-08-30 05:09:24','eb8a3054-29f8-4771-9684-611e24be36d4'),(124,121,3,1,3,NULL,'2022-08-30 05:09:24','2022-08-30 05:09:24','b18931c2-d218-4573-9fe4-c55efe14a1da'),(160,159,3,1,1,NULL,'2022-11-30 03:41:26','2022-11-30 03:41:26','34036df4-fffc-4fcb-89fc-b255aaabd317'),(161,159,3,1,2,NULL,'2022-11-30 03:41:26','2022-11-30 03:41:26','1a417a1a-888b-4838-ba76-b1d5b23a288d'),(162,159,3,1,3,NULL,'2022-11-30 03:41:26','2022-11-30 03:41:26','62cf009b-cc9a-49e5-acec-1d5bc94df235'),(168,167,3,1,1,NULL,'2022-11-30 03:41:53','2022-11-30 03:41:53','2cf5764b-060b-4a2d-9bab-0dbffc26babd'),(169,167,3,1,2,NULL,'2022-11-30 03:41:53','2022-11-30 03:41:53','597c4c0d-c4dd-47a7-a978-3115d87b99c2'),(170,167,3,1,3,NULL,'2022-11-30 03:41:53','2022-11-30 03:41:53','87a8fd17-9c7c-4c2e-9712-ebbbe33c89e6'),(188,132,11,4,1,NULL,'2022-11-30 04:39:49','2022-11-30 04:39:49','7fd4c907-97c3-496c-a556-f7ab531d579a'),(196,195,3,1,1,NULL,'2022-11-30 04:49:18','2022-11-30 04:49:18','5d44f810-3494-481d-aba8-9f50d939d92e'),(197,195,3,1,2,NULL,'2022-11-30 04:49:18','2022-11-30 04:49:18','5114e160-33b8-4202-829b-d563ae71a88a'),(198,195,3,1,3,NULL,'2022-11-30 04:49:18','2022-11-30 04:49:18','3c5ce00e-a13a-436e-9aa0-5a83a8b7be31'),(211,210,3,1,1,NULL,'2023-01-19 15:27:33','2023-01-19 15:27:33','bfa4ae5c-2415-4a78-848c-b0cbc92d8381'),(212,210,3,1,2,NULL,'2023-01-19 15:27:33','2023-01-19 15:27:33','0ab64e4a-a02c-4d06-91c5-cb48889155d4'),(215,214,11,4,1,NULL,'2023-02-16 07:39:27','2023-02-16 07:39:27','2a3210c9-2528-4427-b4f4-38d62a12b144'),(217,216,3,1,1,NULL,'2023-03-14 04:04:27','2023-03-14 04:04:27','6946ced3-8921-46ed-9964-a3bd845f1638'),(218,216,3,1,2,NULL,'2023-03-14 04:04:27','2023-03-14 04:04:27','f5f6978c-0ccc-4934-a984-749b7c439088'),(222,221,11,4,1,NULL,'2023-04-19 02:38:45','2023-04-19 02:38:45','42024454-3bbb-4b53-a673-53629d69564c'),(223,221,11,4,2,NULL,'2023-04-19 02:38:45','2023-04-19 02:38:45','45181aa0-4156-425e-af14-8fea395818f2');
/*!40000 ALTER TABLE `matrixblocks` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `matrixblocktypes`
--

LOCK TABLES `matrixblocktypes` WRITE;
/*!40000 ALTER TABLE `matrixblocktypes` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `matrixblocktypes` VALUES (1,3,2,'link','link',1,'2022-07-04 03:06:37','2022-07-04 03:06:37','6c13d5a4-07fa-4982-9011-8299498c1ad3'),(4,11,12,'vendor','vendor',1,'2022-11-30 04:10:03','2022-11-30 04:10:03','87abb876-efda-45ae-b75c-9df708501a10');
/*!40000 ALTER TABLE `matrixblocktypes` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `matrixcontent_pagelinks`
--

LOCK TABLES `matrixcontent_pagelinks` WRITE;
/*!40000 ALTER TABLE `matrixcontent_pagelinks` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `matrixcontent_pagelinks` VALUES (1,11,1,'2022-07-04 03:07:37','2022-07-04 03:07:37','5f6fb87d-45ce-47ab-8c3f-2008f11caccc',NULL,'Submit Refund',NULL),(2,12,1,'2022-07-04 03:07:39','2022-07-04 03:07:39','eec7d456-685e-4231-b791-d849f8c53cf9','/refund','Submit Refund',NULL),(3,13,1,'2022-07-04 03:07:46','2022-07-04 03:07:46','e0e4c832-c1c8-40b5-9b8f-afcebfde630b','/refund','Submit Refund','111 Well'),(5,15,1,'2022-07-04 03:07:53','2022-08-30 05:09:24','92476091-04ad-4377-9533-2e4afc2523bd','http://paperlesscloud.wesvault.com/pc/acctpro/index.php?r=invoice/refund/select&coy=wvt','Booking Refund or Extra Session','Submit Refund for 111 Wellness for cancellation or postpone'),(6,17,1,'2022-07-04 03:07:53','2022-07-04 03:07:53','e7767d64-df55-48c3-80e0-11c71725a840','/refund','Submit Refund','111 Wellness Refund'),(8,21,1,'2022-07-04 03:22:10','2022-07-04 03:22:10','15623da9-df19-430c-a350-1efcc7da9aa8','/refund','Submit Refund','111 Wellness Refund'),(10,25,1,'2022-07-04 03:25:00','2022-07-04 03:25:00','bd26bec5-d57e-4e93-b288-c09426365752','/refund','Submit Refund','111 Wellness Refund'),(12,29,1,'2022-07-04 03:33:42','2022-07-04 03:33:42','79c4cae7-d7d0-438b-8dae-a79b5acdb26e','http://paperlesscloud.wesvault.com/pc/acctpro/index.php?r=invoice/refund/select','Submit Refund','Submit a request for refund'),(14,36,1,'2022-07-04 03:48:43','2022-07-04 03:48:43','4578c1ed-ecb2-40f3-9041-db84cae7a08e',NULL,NULL,NULL),(15,37,1,'2022-07-04 03:48:50','2022-07-04 03:48:50','5005265e-3a02-4f2c-bd7a-1876028874bf',NULL,'Repairs and Main',NULL),(16,38,1,'2022-07-04 03:48:53','2022-07-04 03:48:53','d994fa13-b6c9-493a-8813-0dc03aed64ae',NULL,'Repairs and Maintainence',NULL),(17,39,1,'2022-07-04 03:48:55','2022-07-04 03:48:55','dc4d9606-3229-49d0-a53e-1247f6fe0205','/Maintainece','Repairs and Maintainence',NULL),(18,40,1,'2022-07-04 03:48:59','2022-07-04 03:48:59','92945715-8b68-405c-b490-7379bb50d13d','/maintainece','Repairs and Maintainence',NULL),(19,41,1,'2022-07-04 03:49:02','2022-07-04 03:49:02','b67ef1a2-36e0-41a3-94e4-7228d11e3ed0','/maintainece','Repairs and Maintainence','Anything'),(20,42,1,'2022-07-04 03:49:04','2022-07-04 03:49:04','b4e77fca-6d4f-4103-9194-7e5a54a4bb01','/maintainece','Repairs and Maintainence',NULL),(21,43,1,'2022-07-04 03:49:11','2022-07-04 03:49:11','d60c523f-b120-4d0c-a7ef-dec2383fed32','/maintainece','Repairs and Maintainence','Any issues to do with'),(23,45,1,'2022-07-04 03:49:16','2023-01-19 15:27:32','b2d49353-59a2-4891-a2a0-cd46d0cb8cca','/maintainece','Repairs and Maintainence','Any issues to do with property'),(24,47,1,'2022-07-04 03:49:16','2022-07-04 03:49:16','2c0ee5dc-7e96-4e9a-956f-1f5b07b9a44b','http://paperlesscloud.wesvault.com/pc/acctpro/index.php?r=invoice/refund/select','Submit Refund','Submit a request for refund'),(25,48,1,'2022-07-04 03:49:16','2022-07-04 03:49:16','1cb8c00e-0a68-467a-8080-cd943a5ecd7c','/maintainece','Repairs and Maintainence','Any issues to do with property'),(28,54,1,'2022-07-04 04:03:28','2022-07-04 04:03:28','dbf2585d-dcd2-46ac-b8e8-7b30c0f8ecc5','http://paperlesscloud.wesvault.com/pc/acctpro/index.php?r=invoice/refund/select','Submit Refund','Submit a request for refund'),(29,55,1,'2022-07-04 04:03:28','2022-07-04 04:03:28','77478c13-3074-4275-8fcc-60c9810bd1ed','/maintainece','Repairs and Maintainence','Any issues to do with property'),(32,60,1,'2022-07-04 04:04:15','2022-07-04 04:04:15','0e5dff21-673e-420b-ba40-f77424b4c581','http://paperlesscloud.wesvault.com/pc/acctpro/index.php?r=invoice/refund/select','Submit Refund','Submit a request for refund'),(33,61,1,'2022-07-04 04:04:15','2022-07-04 04:04:15','1ffc1177-b3c8-421a-b1b1-e4299c12136a','/maintainece','Repairs and Maintainence','Any issues to do with property'),(36,66,1,'2022-07-04 04:35:25','2022-07-04 04:35:25','c0df64da-4e8b-422e-bd8f-50818120c760','http://paperlesscloud.wesvault.com/pc/acctpro/index.php?r=invoice/refund/select','Submit Refund','Submit Refund for 111 Wellness for cancellation or postpone'),(37,67,1,'2022-07-04 04:35:25','2022-07-04 04:35:25','06f5626e-a92c-4da5-96c6-392e0c3cf81d','/maintainece','Repairs and Maintainence','Any issues to do with property'),(40,73,1,'2022-07-05 02:12:53','2022-07-05 02:12:53','7d7b5c94-feed-4c55-967c-01179d443fc4','http://paperlesscloud.wesvault.com/pc/acctpro/index.php?r=invoice/refund/select&coy=wvt','Submit Refund','Submit Refund for 111 Wellness for cancellation or postpone'),(41,74,1,'2022-07-05 02:12:53','2022-07-05 02:12:53','da44320f-acd1-492e-a097-2aec814a4792','/maintainece','Repairs and Maintainence','Any issues to do with property'),(44,85,1,'2022-07-07 05:45:20','2022-07-07 05:45:20','a1da5974-36cd-46fb-b0aa-f43a7e74869e',NULL,NULL,NULL),(45,86,1,'2022-07-07 05:45:24','2022-07-07 05:45:24','73cffd1b-e104-4053-b8f5-2be19dc3204a',NULL,'Billing Information',NULL),(46,87,1,'2022-07-07 05:45:26','2022-07-07 05:45:26','3477d2b9-e967-41a1-99e5-30374e8962e1','/','Billing Information',NULL),(47,88,1,'2022-07-07 05:45:27','2022-07-07 05:45:27','41115aa3-2859-437b-a0fc-a4408038ada1','/bill','Billing Information',NULL),(49,90,1,'2022-07-07 05:45:36','2023-01-19 15:27:32','2423d33f-c1c0-4971-bbd6-b233b683c6be','/billing','Billing Information','Our Billing Information today'),(50,92,1,'2022-07-07 05:45:36','2022-07-07 05:45:36','9128ab27-b763-4da1-aa6a-347ee5bb38d5','http://paperlesscloud.wesvault.com/pc/acctpro/index.php?r=invoice/refund/select&coy=wvt','Submit Refund','Submit Refund for 111 Wellness for cancellation or postpone'),(51,93,1,'2022-07-07 05:45:36','2022-07-07 05:45:36','f1577f7d-b308-4b79-a663-06811cc0040d','/maintainece','Repairs and Maintainence','Any issues to do with property'),(52,94,1,'2022-07-07 05:45:36','2022-07-07 05:45:36','6f3aa8c7-e147-477b-b821-a0880cd21710','/bill','Billing Information','Our Billing Information'),(56,103,1,'2022-07-07 05:48:34','2022-07-07 05:48:34','43d1eeae-4aaa-4e1a-bf48-a5b0e5bf07a7','http://paperlesscloud.wesvault.com/pc/acctpro/index.php?r=invoice/refund/select&coy=wvt','Submit Refund','Submit Refund for 111 Wellness for cancellation or postpone'),(57,104,1,'2022-07-07 05:48:34','2022-07-07 05:48:34','510fb3b0-16d1-471f-bcda-f290df041e88','/maintainece','Repairs and Maintainence','Any issues to do with property'),(58,105,1,'2022-07-07 05:48:34','2022-07-07 05:48:34','8c8fdcd4-6aee-4e8c-a17a-ae148deae479','/billing','Billing Information','Our Billing Information'),(62,113,1,'2022-08-05 02:17:35','2022-08-05 02:17:35','8e5be903-6327-4df5-a7b1-79efc6ae3464','http://paperlesscloud.wesvault.com/pc/acctpro/index.php?r=invoice/refund/select&coy=wvt','Booking Refund or Extra Session','Submit Refund for 111 Wellness for cancellation or postpone'),(63,114,1,'2022-08-05 02:17:35','2022-08-05 02:17:35','a117715d-f414-425e-9347-e657903a6f1f','/maintainece','Repairs and Maintainence','Any issues to do with property'),(64,115,1,'2022-08-05 02:17:35','2022-08-05 02:17:35','eee9c08a-0ff8-4b36-9a23-b85334d9a9d6','/billing','Billing Information','Our Billing Information'),(68,122,1,'2022-08-30 05:09:24','2022-08-30 05:09:24','622cf4ea-d9d1-4082-861c-d5b8f798667d','http://paperlesscloud.wesvault.com/pc/acctpro/index.php?r=invoice/refund/select&coy=wvt','Booking Refund or Extra Session','Submit Refund for 111 Wellness for cancellation or postpone'),(69,123,1,'2022-08-30 05:09:24','2022-08-30 05:09:24','de497fda-085f-4886-9346-c68f36601b41','/maintainece','Repairs and Maintainence','Any issues to do with property'),(70,124,1,'2022-08-30 05:09:24','2022-08-30 05:09:24','05fb829d-0538-4fb1-8e4b-bd3a9fa1fbfa','/billing','Billing Information','Our Billing Information today'),(74,160,1,'2022-11-30 03:41:26','2022-11-30 03:41:26','2166b92d-cffc-47ac-8fc3-ff394a220964','http://paperlesscloud.wesvault.com/pc/acctpro/index.php?r=invoice/refund/select&coy=wvt','Booking Refund or Extra Session','Submit Refund for 111 Wellness for cancellation or postpone'),(75,161,1,'2022-11-30 03:41:26','2022-11-30 03:41:26','402ff708-6957-41bd-94b9-5e9d5a152b26','/maintainece','Repairs and Maintainence','Any issues to do with property'),(76,162,1,'2022-11-30 03:41:26','2022-11-30 03:41:26','15734cc3-44f8-49ed-8d9d-dc26433c41ad','/billing','Billing Information','Our Billing Information today'),(80,168,1,'2022-11-30 03:41:53','2022-11-30 03:41:53','50122c45-d8c7-4cb6-bd04-477f9ee99ccf','http://paperlesscloud.wesvault.com/pc/acctpro/index.php?r=invoice/refund/select&coy=wvt','Booking Refund or Extra Session','Submit Refund for 111 Wellness for cancellation or postpone'),(81,169,1,'2022-11-30 03:41:53','2022-11-30 03:41:53','d27a7bfc-5538-4c3b-b5a8-70f31ffd4743','/maintainece','Repairs and Maintainence','Any issues to do with property'),(82,170,1,'2022-11-30 03:41:53','2022-11-30 03:41:53','6618c081-9e84-453f-9bc3-560c2b4b5557','/billing','Billing Information','Our Billing Information today'),(86,196,1,'2022-11-30 04:49:18','2022-11-30 04:49:18','3c9fe0d0-c0c5-417b-a54f-5f1db3be0808','http://paperlesscloud.wesvault.com/pc/acctpro/index.php?r=invoice/refund/select&coy=wvt','Booking Refund or Extra Session','Submit Refund for 111 Wellness for cancellation or postpone'),(87,197,1,'2022-11-30 04:49:18','2022-11-30 04:49:18','b494b0e9-7fa9-426a-a9d6-8b4e66639480','/maintainece','Repairs and Maintainence','Any issues to do with property'),(88,198,1,'2022-11-30 04:49:18','2022-11-30 04:49:18','615797a6-51a9-417e-a355-5344c7c34dd9','/billing','Billing Information','Our Billing Information today'),(89,207,1,'2023-01-19 15:27:32','2023-01-19 15:27:32','d66fe84a-31c0-4a6a-bfda-10ff81fd1ec5','http://paperlesscloud.wesvault.com/pc/acctpro/index.php?r=invoice/refund/select&coy=wvt','Booking Refund or Extra Session','Submit Refund for 111 Wellness for cancellation or postpone'),(92,211,1,'2023-01-19 15:27:33','2023-01-19 15:27:33','8122accc-2793-4675-9b43-ee4841bb31db','/maintainece','Repairs and Maintainence','Any issues to do with property'),(93,212,1,'2023-01-19 15:27:33','2023-01-19 15:27:33','adcc6775-6c8d-429e-aa2d-2daf1f1aad9d','/billing','Billing Information','Our Billing Information today'),(94,217,1,'2023-03-14 04:04:27','2023-04-25 01:55:40','202add34-74cc-41c0-ba98-ab99349c0554','/maintainece','Repairs and Maintainence','Any issues to do with property'),(95,218,1,'2023-03-14 04:04:27','2023-04-19 02:24:04','4aabbd4a-fab0-4334-89d6-114511d0c91b','/billing','Billing Information','Our Billing Information');
/*!40000 ALTER TABLE `matrixcontent_pagelinks` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `matrixcontent_serviceproviders`
--

LOCK TABLES `matrixcontent_serviceproviders` WRITE;
/*!40000 ALTER TABLE `matrixcontent_serviceproviders` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `matrixcontent_serviceproviders` VALUES (1,177,1,'2022-11-30 04:38:30','2022-11-30 04:38:30','685a6be5-249e-4ad0-ac92-da998aa89a9b','airConditioning',NULL,NULL),(2,178,1,'2022-11-30 04:38:35','2022-11-30 04:38:35','bfb2c03b-9aac-4d03-9f97-914658e48343','shutterRepair',NULL,NULL),(3,179,1,'2022-11-30 04:39:18','2022-11-30 04:39:18','e54d928b-29c0-4800-aade-8e0d25b26182','shutterRepair',NULL,'Pelican Roller Shutters'),(4,180,1,'2022-11-30 04:39:29','2022-11-30 04:39:29','805f62b8-e944-4cd3-9960-4e7fefba621b','shutterRepair','<p>9</p>','Pelican Roller Shutters'),(5,181,1,'2022-11-30 04:39:31','2022-11-30 04:39:31','d2a87c16-6eac-4c3a-8d7f-e4d324f86bd2','shutterRepair','<p>9527</p>','Pelican Roller Shutters'),(6,182,1,'2022-11-30 04:39:33','2022-11-30 04:39:33','c1bda54d-1903-44c9-8fbd-34b0ced435e2','shutterRepair','<p>95272938</p>','Pelican Roller Shutters'),(7,183,1,'2022-11-30 04:39:34','2022-11-30 04:39:34','3951fc1c-a9ba-4432-9071-22ade8e7e132','shutterRepair','<p>95272938</p>\n','Pelican Roller Shutters'),(8,184,1,'2022-11-30 04:39:37','2022-11-30 04:39:37','12860f69-1f65-4c9b-8866-243d4e55daa9','shutterRepair','<p>95272938</p>\n<p>04</p>','Pelican Roller Shutters'),(9,185,1,'2022-11-30 04:39:39','2022-11-30 04:39:39','6981dc94-0c08-4138-9e3f-529a3eacc2a6','shutterRepair','<p>95272938</p>\n<p>0413015456</p>','Pelican Roller Shutters'),(10,186,1,'2022-11-30 04:39:40','2022-11-30 04:39:40','697f9f9a-05e7-4708-8ebc-aeb268971697','shutterRepair','<p>95272938</p>\n<p>0413015456</p>\n','Pelican Roller Shutters'),(12,188,1,'2022-11-30 04:39:49','2022-12-01 07:51:27','52decca4-a8fd-4e6a-abc6-dbd5446e87b6','shutterRepair','<p>Person: Andy<br />Tel: 95272938<br />HP: 0413015456<br /><br /></p>','Pelican Roller Shutters'),(13,215,1,'2023-02-16 07:39:27','2023-04-25 01:57:11','e8b1088e-42f0-4b7d-a86d-af676989b95a','airConditioning','<p>The contact is </p>','Aircon servicing'),(14,222,1,'2023-04-19 02:38:45','2023-04-19 02:38:45','78025697-6184-477f-b947-c288ecb1fca5','shutterRepair','<p>Person: Andy<br />Tel: 95272938<br />HP: 0413015456<br /><br /></p>','Pelican Roller Shutters'),(15,223,1,'2023-04-19 02:38:45','2023-04-19 02:38:45','d96b88e5-340c-4c39-970e-34688f4c373a','airConditioning',NULL,NULL);
/*!40000 ALTER TABLE `matrixcontent_serviceproviders` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `migrations` VALUES (1,'craft','Install','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','62ac0438-3f0a-43ed-8536-b2c4d06b0e78'),(2,'craft','m150403_183908_migrations_table_changes','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','5e4ad4ad-3bca-4386-a77f-1c05c2b15769'),(3,'craft','m150403_184247_plugins_table_changes','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','508bd15f-866c-48e4-aa1b-1e95bdee05e5'),(4,'craft','m150403_184533_field_version','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','c35b2286-115a-4522-b28b-57c1fe21c968'),(5,'craft','m150403_184729_type_columns','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','9c570da2-fce0-4eae-a9f6-cea6ab3f1741'),(6,'craft','m150403_185142_volumes','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','1beb7648-717c-4728-a0bf-670f533d8e9c'),(7,'craft','m150428_231346_userpreferences','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','0b26f17d-5342-4cbf-922a-2d3a2651775d'),(8,'craft','m150519_150900_fieldversion_conversion','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','617e7bc3-dee3-4ed1-b479-82b30a9f1dc5'),(9,'craft','m150617_213829_update_email_settings','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','f568a72f-5b70-4e3f-85a7-4a75b550d7fb'),(10,'craft','m150721_124739_templatecachequeries','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','83186373-934c-449c-af59-6675d8d931a7'),(11,'craft','m150724_140822_adjust_quality_settings','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','277d1f11-9d3e-4f0d-932d-ea4d2ed2882a'),(12,'craft','m150815_133521_last_login_attempt_ip','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','a8b16ca5-6aae-478f-b783-6739585f4fd8'),(13,'craft','m151002_095935_volume_cache_settings','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','9d1027fe-e9ce-4d8d-8a53-288a3f0ad8eb'),(14,'craft','m151005_142750_volume_s3_storage_settings','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','f5fb7b1b-4b78-440e-9f2a-a60ede4297cf'),(15,'craft','m151016_133600_delete_asset_thumbnails','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','1bdd44b7-a22a-49a5-b9f2-83e9b3fc679d'),(16,'craft','m151209_000000_move_logo','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','6fe2aac3-8683-4756-8613-6a7c12ad9d56'),(17,'craft','m151211_000000_rename_fileId_to_assetId','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','0dfa685f-b716-4b0c-940b-193061ae41ab'),(18,'craft','m151215_000000_rename_asset_permissions','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','55f95cb2-f457-4f3e-8a1d-250c48dc7456'),(19,'craft','m160707_000001_rename_richtext_assetsource_setting','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','506a17aa-c520-4af7-aec2-bc4035f21e5b'),(20,'craft','m160708_185142_volume_hasUrls_setting','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','2db70f49-eb7d-4dab-81fc-8e9703357984'),(21,'craft','m160714_000000_increase_max_asset_filesize','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','0e17014c-67dd-42e5-8863-db6087f3eaa8'),(22,'craft','m160727_194637_column_cleanup','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','b38854ce-7542-4440-a945-5a9100765c0f'),(23,'craft','m160804_110002_userphotos_to_assets','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','248e4167-6fb8-4886-a84a-d535bc6bd11c'),(24,'craft','m160807_144858_sites','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','2052e547-6719-4981-88e5-2074ae3e214c'),(25,'craft','m160829_000000_pending_user_content_cleanup','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','d362f7dd-4c83-466f-a3bf-1a646caf3c3a'),(26,'craft','m160830_000000_asset_index_uri_increase','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','657e877d-2e7b-42ae-8780-4db71c8e9078'),(27,'craft','m160912_230520_require_entry_type_id','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','f41fba91-a839-406d-80e5-1f2126dfb8de'),(28,'craft','m160913_134730_require_matrix_block_type_id','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','eea5f79e-8331-42ae-8d18-52a6c78dcdd6'),(29,'craft','m160920_174553_matrixblocks_owner_site_id_nullable','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','9511ba9b-a4ae-4814-a95a-e1f5f3aaf5b7'),(30,'craft','m160920_231045_usergroup_handle_title_unique','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','f157a546-c7e2-4b06-8e87-2b544cd26a22'),(31,'craft','m160925_113941_route_uri_parts','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','86d2d3f2-58a8-4a16-8704-843baf9ac05c'),(32,'craft','m161006_205918_schemaVersion_not_null','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','0674b27e-ef88-4db8-b7d4-d6310afa9ee9'),(33,'craft','m161007_130653_update_email_settings','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','0275256a-dd4b-4aa1-8ff2-b5c525168111'),(34,'craft','m161013_175052_newParentId','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','923a98cd-733e-4dbd-b81b-89e50620a233'),(35,'craft','m161021_102916_fix_recent_entries_widgets','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','04841f7a-aa7c-42dd-8736-a886f5c1841f'),(36,'craft','m161021_182140_rename_get_help_widget','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','d18eb07d-5793-4238-8e90-1aa21aac1769'),(37,'craft','m161025_000000_fix_char_columns','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','2c4765bf-f321-4b3f-b3b2-3703bdf2978e'),(38,'craft','m161029_124145_email_message_languages','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','c1ce7c4d-aa88-45a3-9e6d-6aa66044eaad'),(39,'craft','m161108_000000_new_version_format','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','11f99c08-57aa-4f35-ba16-e0e351c813bf'),(40,'craft','m161109_000000_index_shuffle','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','228869bd-c5b3-4fc0-a7de-b0416bd0abec'),(41,'craft','m161122_185500_no_craft_app','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','4b2f85c4-711b-461c-b9db-f916fece1f9d'),(42,'craft','m161125_150752_clear_urlmanager_cache','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','2c60f777-09f7-465c-978d-ba7bcc3c5494'),(43,'craft','m161220_000000_volumes_hasurl_notnull','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','bafe574d-3074-4c4b-ab56-64d62be77970'),(44,'craft','m170114_161144_udates_permission','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','1bc7804b-511c-4b53-a811-b5410d8f54c3'),(45,'craft','m170120_000000_schema_cleanup','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','d3380ec3-16c5-4b43-a4d7-3457637bc341'),(46,'craft','m170126_000000_assets_focal_point','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','4172b500-0ceb-4491-a04c-726a1e48da3b'),(47,'craft','m170206_142126_system_name','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','d8f8cdcf-ceaa-4417-b403-af886b011b29'),(48,'craft','m170217_044740_category_branch_limits','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','b019710d-e6f5-4fe6-9c76-514247cc72fa'),(49,'craft','m170217_120224_asset_indexing_columns','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','c5f3d13b-63f6-4310-ad05-57694d26e10b'),(50,'craft','m170223_224012_plain_text_settings','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','d3e9bb41-e8e1-4dba-a57d-9c206642ef70'),(51,'craft','m170227_120814_focal_point_percentage','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','dfb7a969-4c88-4942-8448-a3a44d5a2af6'),(52,'craft','m170228_171113_system_messages','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','595e508e-3ccf-4cf5-b6dd-1f132ba21dad'),(53,'craft','m170303_140500_asset_field_source_settings','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','5778dead-6f97-40c2-90bd-5c5e8f1d805c'),(54,'craft','m170306_150500_asset_temporary_uploads','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','8c304046-afb6-49e3-ae7c-be5df357f8c9'),(55,'craft','m170523_190652_element_field_layout_ids','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','b22eb178-a557-4ef8-a62e-b865c21c2288'),(56,'craft','m170621_195237_format_plugin_handles','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','b71b905f-ef84-4db7-8b02-42eede156046'),(57,'craft','m170630_161027_deprecation_line_nullable','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','3f2a06b1-2b78-4a9d-9ebe-1125f8b7d8b5'),(58,'craft','m170630_161028_deprecation_changes','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','d335108e-2422-48fa-b269-4e205ce25d6b'),(59,'craft','m170703_181539_plugins_table_tweaks','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','65a8cdbf-a502-4d4c-acbf-76e25209a83d'),(60,'craft','m170704_134916_sites_tables','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','9bacb0f4-6b0f-4bd5-be19-ed87bdefecf3'),(61,'craft','m170706_183216_rename_sequences','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','69b30297-138c-4a63-bf31-fe99c79d07da'),(62,'craft','m170707_094758_delete_compiled_traits','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','4ea8f7e9-0ede-4c54-adde-ca5186905525'),(63,'craft','m170731_190138_drop_asset_packagist','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','fbd41c23-d4ed-40d9-bc83-44f231182c23'),(64,'craft','m170810_201318_create_queue_table','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','7096bd34-2540-48d1-871b-96b1005a3554'),(65,'craft','m170903_192801_longblob_for_queue_jobs','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','7775d77c-32bb-474c-93f0-09e1628df6f5'),(66,'craft','m170914_204621_asset_cache_shuffle','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','56fbfb98-5105-4eba-8e6e-47aae566d226'),(67,'craft','m171011_214115_site_groups','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','19dac8fd-05d5-4b8b-b095-109e42d1e045'),(68,'craft','m171012_151440_primary_site','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','ba3f94bb-7bcf-4da6-8b75-6e44978922f6'),(69,'craft','m171013_142500_transform_interlace','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','edd5065c-9ce3-4002-a448-5d3cfd4908a6'),(70,'craft','m171016_092553_drop_position_select','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','b62557a4-5f24-4a96-8efb-80cfde34ef04'),(71,'craft','m171016_221244_less_strict_translation_method','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','8d05afe3-ac2f-446c-bb15-ce496dc7671f'),(72,'craft','m171107_000000_assign_group_permissions','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','0aab9732-0f4b-4abf-9dcc-ebfa5af66e3e'),(73,'craft','m171117_000001_templatecache_index_tune','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','3b79194a-c2d2-4545-9f07-23e3ddacabe1'),(74,'craft','m171126_105927_disabled_plugins','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','b52db8aa-251a-48e7-b3bc-4878d126c039'),(75,'craft','m171130_214407_craftidtokens_table','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','4c873689-4101-4d9c-a30a-d5682aca91c5'),(76,'craft','m171202_004225_update_email_settings','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','1146917d-05bc-4232-9429-07cccbcbf2e6'),(77,'craft','m171204_000001_templatecache_index_tune_deux','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','daed78a5-4c94-4b9a-b471-b27209aa0035'),(78,'craft','m171205_130908_remove_craftidtokens_refreshtoken_column','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','04d64541-3e52-48d3-9e16-15e7c86c5b2a'),(79,'craft','m171218_143135_longtext_query_column','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','17d2753d-bbdb-4780-bb3c-0e9e56ce50fa'),(80,'craft','m171231_055546_environment_variables_to_aliases','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','79f32f42-3b23-45e9-b6d6-41917d8893e1'),(81,'craft','m180113_153740_drop_users_archived_column','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','52773ff9-3683-469a-ab53-64d25356cd4b'),(82,'craft','m180122_213433_propagate_entries_setting','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','45313273-9d6a-4232-b2d5-db25182810e2'),(83,'craft','m180124_230459_fix_propagate_entries_values','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','28aa64d1-7651-4268-a493-eacff345661c'),(84,'craft','m180128_235202_set_tag_slugs','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','655445c1-1582-4629-8890-49900cc626ac'),(85,'craft','m180202_185551_fix_focal_points','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','7a179275-c30a-4858-b292-81c539c883c6'),(86,'craft','m180217_172123_tiny_ints','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','49b751ab-64d9-4160-a0f7-d8faec807ba2'),(87,'craft','m180321_233505_small_ints','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','93bd3a57-5a41-46ad-9ae4-0973e0e21948'),(88,'craft','m180404_182320_edition_changes','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','e673427c-5137-4a04-b2da-ab542081f142'),(89,'craft','m180411_102218_fix_db_routes','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','9a01509e-9f56-482d-9d9e-0aeb4c2e0977'),(90,'craft','m180416_205628_resourcepaths_table','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','f149459d-a82a-46b3-b5b8-4b491780533f'),(91,'craft','m180418_205713_widget_cleanup','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','ad149062-96d6-43cd-82d9-639d8351706e'),(92,'craft','m180425_203349_searchable_fields','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','44eb4256-6f52-433a-afb0-bb9fdd44b378'),(93,'craft','m180516_153000_uids_in_field_settings','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','47de403c-6d20-4611-861a-5ab60f1e422b'),(94,'craft','m180517_173000_user_photo_volume_to_uid','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','3a467e83-6aec-423a-9c97-5ff2bedcd13e'),(95,'craft','m180518_173000_permissions_to_uid','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','17fcaf40-d86d-42d2-8ea4-304dc538bcb0'),(96,'craft','m180520_173000_matrix_context_to_uids','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','a2c8cdff-1581-4aad-a492-2a04b823d324'),(97,'craft','m180521_172900_project_config_table','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','3e227b53-0436-4e99-8fe0-cad1f1bbec10'),(98,'craft','m180521_173000_initial_yml_and_snapshot','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','dc2dbef8-cd0a-4cf6-ba91-5df88294f8e7'),(99,'craft','m180731_162030_soft_delete_sites','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','d5addb11-4643-4f36-b630-1286ef39ea57'),(100,'craft','m180810_214427_soft_delete_field_layouts','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','5fdcd323-c6d4-4ebc-9809-fe1bf65bd81a'),(101,'craft','m180810_214439_soft_delete_elements','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','8684abf8-e156-4c13-b03c-fefb89c162e6'),(102,'craft','m180824_193422_case_sensitivity_fixes','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','afe6212d-1456-476e-8a41-0631ef36353b'),(103,'craft','m180901_151639_fix_matrixcontent_tables','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','bf0e2345-9189-40c6-bca4-9f01e567f8e2'),(104,'craft','m180904_112109_permission_changes','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','4c4f2248-fe81-438f-89a9-4b2f33ba4e39'),(105,'craft','m180910_142030_soft_delete_sitegroups','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','8c4b7874-612d-477a-b213-4a64ae9bbae9'),(106,'craft','m181011_160000_soft_delete_asset_support','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','16e38e16-d644-4bd6-865a-2bfe0caf5166'),(107,'craft','m181016_183648_set_default_user_settings','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','81038256-bc40-4a47-ab50-d339217652db'),(108,'craft','m181017_225222_system_config_settings','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','83af765a-5ec7-4e56-a80b-71a38b202663'),(109,'craft','m181018_222343_drop_userpermissions_from_config','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','f6022e2e-7810-4be2-accd-36b4c87d2b84'),(110,'craft','m181029_130000_add_transforms_routes_to_config','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','d4946a51-e5bc-4136-b8eb-d3fbe19b3479'),(111,'craft','m181112_203955_sequences_table','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','a59dd490-750e-4186-8efc-4c84479e4c4a'),(112,'craft','m181121_001712_cleanup_field_configs','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','6fb7624e-bee5-4301-ac21-87a8bbba137a'),(113,'craft','m181128_193942_fix_project_config','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','47963ef0-9646-4ff8-9faf-5f16e448cd46'),(114,'craft','m181130_143040_fix_schema_version','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','0af5f83a-85b7-4871-aabf-e09a6f5a46a9'),(115,'craft','m181211_143040_fix_entry_type_uids','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','f296d949-d319-4c10-a828-0b2a75aea52e'),(116,'craft','m181217_153000_fix_structure_uids','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','c0ed215d-a840-4740-bc2f-9d47ec16a93c'),(117,'craft','m190104_152725_store_licensed_plugin_editions','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','cfc45121-0658-4d02-9cec-c95ae14857bf'),(118,'craft','m190108_110000_cleanup_project_config','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','83a5981a-a878-453b-a648-9e2e2cc1e7b3'),(119,'craft','m190108_113000_asset_field_setting_change','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','a109841b-cb21-4a3b-863b-386fb0813f69'),(120,'craft','m190109_172845_fix_colspan','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','d43cfd82-71fc-4aa9-9760-77a1b48abbfc'),(121,'craft','m190110_150000_prune_nonexisting_sites','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','7a68d6fa-205a-4e1e-9397-518d480bcb95'),(122,'craft','m190110_214819_soft_delete_volumes','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','27babbdb-60bf-4807-bc8f-7b2504d686ca'),(123,'craft','m190112_124737_fix_user_settings','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','b4187102-3d81-4a46-b277-b199df9210a1'),(124,'craft','m190112_131225_fix_field_layouts','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','3e6498ab-7638-4d64-a0a5-1df33145a3fb'),(125,'craft','m190112_201010_more_soft_deletes','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','5f066fa8-8b92-4b5c-9829-659610dad13f'),(126,'craft','m190114_143000_more_asset_field_setting_changes','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','270344f9-d5b9-4aee-b8c6-446b286d7f43'),(127,'craft','m190121_120000_rich_text_config_setting','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','d6fc6af0-31b6-41f0-a4ce-9e9396a2c927'),(128,'craft','m190125_191628_fix_email_transport_password','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','09482de0-e86b-41b2-9485-9a35cfcb6509'),(129,'craft','m190128_181422_cleanup_volume_folders','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','9abefa45-bfee-4d65-92d0-0a9f1b3dfb30'),(130,'craft','m190205_140000_fix_asset_soft_delete_index','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','6dc4d85c-b12a-4c58-b646-115957142a2b'),(131,'craft','m190218_143000_element_index_settings_uid','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','0272caea-bf56-42e9-94a3-b594cc5a9516'),(132,'craft','m190312_152740_element_revisions','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','11097c39-7047-40cc-9f53-1b3f3668194e'),(133,'craft','m190327_235137_propagation_method','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','8dbf3d98-f731-45e8-bfce-a9ecdfe12cd0'),(134,'craft','m190401_223843_drop_old_indexes','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','295a992b-8d64-485a-808b-c0be0b25c3ed'),(135,'craft','m190416_014525_drop_unique_global_indexes','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','72acf313-0928-4d0c-9d9f-4cf110cba11f'),(136,'craft','m190417_085010_add_image_editor_permissions','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','cd7810dc-bd18-4598-92ca-1a2581a168e3'),(137,'craft','m190502_122019_store_default_user_group_uid','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','ace70139-79a5-4241-81ad-a07b93672e4c'),(138,'craft','m190504_150349_preview_targets','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','8aa4b56a-c680-444d-a215-105b1c46d11d'),(139,'craft','m190516_184711_job_progress_label','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','06dd83be-1b1c-4917-87b5-57145cbc0f4e'),(140,'craft','m190523_190303_optional_revision_creators','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','1e976682-1c47-4b60-b720-0d74e38ed03c'),(141,'craft','m190529_204501_fix_duplicate_uids','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','65d320aa-2cd3-4500-ba2b-7a4d4e20716e'),(142,'craft','m190605_223807_unsaved_drafts','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','3b9f3001-f5e1-4313-8f0f-7c53b92b7855'),(143,'craft','m190607_230042_entry_revision_error_tables','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','5df3fb5b-26b2-45f4-9b2e-8ea6a19262fd'),(144,'craft','m190608_033429_drop_elements_uid_idx','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','18ef4b18-e953-4fed-8d1a-ac54c5e3df1f'),(145,'craft','m190617_164400_add_gqlschemas_table','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','df78737c-29af-47fb-9f2e-1b4531e057c3'),(146,'craft','m190624_234204_matrix_propagation_method','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','7dbb06d3-3f30-4fef-bcb4-72ee120c8caa'),(147,'craft','m190711_153020_drop_snapshots','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','8469d927-25be-4401-bfe3-1c24af0c2fcd'),(148,'craft','m190712_195914_no_draft_revisions','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','be32ecc7-64c7-4d1c-a266-9ed0e033289c'),(149,'craft','m190723_140314_fix_preview_targets_column','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','b9ba3c17-3ba7-4b7e-a5b3-ee5b8cd74e89'),(150,'craft','m190820_003519_flush_compiled_templates','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','e2d1abed-17b1-4208-87d1-d9018300aa4b'),(151,'craft','m190823_020339_optional_draft_creators','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','e20c059e-4386-49c1-9e29-451a2f726ca4'),(152,'craft','m190913_152146_update_preview_targets','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','e099f07f-39f7-47fc-bf7a-d5f2ec213002'),(153,'craft','m191107_122000_add_gql_project_config_support','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','573cee37-02dc-468d-9b27-1b27ce766b33'),(154,'craft','m191204_085100_pack_savable_component_settings','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','2f81e4d8-f266-4443-819b-14e6a3a9f766'),(155,'craft','m191206_001148_change_tracking','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','4189c2d6-45a4-4b99-b882-470d6ced2d81'),(156,'craft','m191216_191635_asset_upload_tracking','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','59759bc9-5d77-405b-b568-75dd6168c96b'),(157,'craft','m191222_002848_peer_asset_permissions','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','3b005fec-1639-4ac6-a2ba-4b640ddb04e0'),(158,'craft','m200127_172522_queue_channels','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','19b3c4ab-badb-470e-9a57-cb103cbe6216'),(159,'craft','m200211_175048_truncate_element_query_cache','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','882df1f3-f34e-4e22-94a9-de57509bba75'),(160,'craft','m200213_172522_new_elements_index','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','3f22de04-faa6-432b-b4a1-23037abf534f'),(161,'craft','m200228_195211_long_deprecation_messages','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','203fa747-0e09-46e8-9b3e-a3bc6b3b4ccb'),(162,'craft','m200306_054652_disabled_sites','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','8f66f339-7bf6-4957-9b14-d1472725a6ac'),(163,'craft','m200522_191453_clear_template_caches','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','0847cfde-57fc-47f5-ba8a-6d24d402e409'),(164,'craft','m200606_231117_migration_tracks','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','0e8bb877-383d-4397-9699-4dc6fb64633d'),(165,'craft','m200619_215137_title_translation_method','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','00112266-ba88-4968-97d9-0f3157686f5f'),(166,'craft','m200620_005028_user_group_descriptions','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','beca0678-a127-4765-9eb8-6fc3853d8e8c'),(167,'craft','m200620_230205_field_layout_changes','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','f851cfd5-0ec3-46fa-8932-c81debaf440e'),(168,'craft','m200625_131100_move_entrytypes_to_top_project_config','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','cf21bf5a-673e-4680-a1e7-dd7a76e9cd91'),(169,'craft','m200629_112700_remove_project_config_legacy_files','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','80d112db-5748-46b4-97d5-827eb8bfa580'),(170,'craft','m200630_183000_drop_configmap','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','a25abdee-34d7-44fd-9fe7-4e57eabd6273'),(171,'craft','m200715_113400_transform_index_error_flag','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','ea67c347-b258-4040-a130-0ee962511c64'),(172,'craft','m200716_110900_replace_file_asset_permissions','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','ca2fc06f-f3b3-4487-a5ce-bff05d168b35'),(173,'craft','m200716_153800_public_token_settings_in_project_config','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','df2f60af-298b-4f32-b41c-124463494b2f'),(174,'craft','m200720_175543_drop_unique_constraints','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','a3b438e4-4f85-46d9-a53b-bf1e6b0ae5e7'),(175,'craft','m200825_051217_project_config_version','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','1444f882-11fc-4e32-a1dd-8155e4c93d05'),(176,'craft','m201116_190500_asset_title_translation_method','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','bf1a7617-86c9-4880-a259-a2756af6f8fb'),(177,'craft','m201124_003555_plugin_trials','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','b9fb4069-5584-4a26-825c-d5f89c46c8ac'),(178,'craft','m210209_135503_soft_delete_field_groups','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','ed85414f-6864-4340-b9b7-2d00a6517b6f'),(179,'craft','m210212_223539_delete_invalid_drafts','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','6eaf0125-329b-4613-ad97-9a8ffcd748fd'),(180,'craft','m210214_202731_track_saved_drafts','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','d1564e53-7a56-4244-9549-67b7c4f17346'),(181,'craft','m210223_150900_add_new_element_gql_schema_components','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','a3aeff4e-3e68-4706-bfa4-33e3622e5e5c'),(182,'craft','m210302_212318_canonical_elements','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','6c10e3d7-6dcb-4554-9aa6-4aa798f1768d'),(183,'craft','m210326_132000_invalidate_projectconfig_cache','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','aa4ad812-fc06-400f-b016-aac80a76eb7e'),(184,'craft','m210329_214847_field_column_suffixes','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','5ead1ff7-c1f2-46ba-a132-74156a9e89af'),(185,'craft','m210331_220322_null_author','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','20163098-a75f-4b1f-a722-73b4c3089efb'),(186,'craft','m210405_231315_provisional_drafts','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','97a7e830-1ea8-49b7-ba58-4309bbf1ded6'),(187,'craft','m210602_111300_project_config_names_in_config','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','ba0c81fd-0a9f-49f4-b2e3-1f52eec2cd4e'),(188,'craft','m210611_233510_default_placement_settings','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','8b64d167-894d-484e-93c3-d4c060840db0'),(189,'craft','m210613_145522_sortable_global_sets','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','53a41b71-4dc8-41aa-8249-f269fe98e489'),(190,'craft','m210613_184103_announcements','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','96954c13-8326-495f-8303-cbef44fc4b56'),(191,'craft','m210829_000000_element_index_tweak','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','25a4776a-fbb1-4241-b84f-90c35e99fc24'),(192,'craft','m220209_095604_add_indexes','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','b4d18cc5-2c97-45f8-a3b4-275a9d635eb3'),(193,'craft','m220214_000000_truncate_sessions','2022-07-04 01:44:27','2022-07-04 01:44:27','2022-07-04 01:44:27','a048feee-0124-4be1-8ed6-a06dcbcf12f9'),(194,'plugin:redactor','m180430_204710_remove_old_plugins','2022-07-04 02:24:41','2022-07-04 02:24:41','2022-07-04 02:24:41','5a942a83-d3f9-41c6-b261-a1f92d05822a'),(195,'plugin:redactor','Install','2022-07-04 02:24:41','2022-07-04 02:24:41','2022-07-04 02:24:41','fe032dcf-5ac9-415b-b4ac-9f2b599d3707'),(196,'plugin:redactor','m190225_003922_split_cleanup_html_settings','2022-07-04 02:24:41','2022-07-04 02:24:41','2022-07-04 02:24:41','54e30e17-60d4-4cee-b736-dcee9a78258f'),(197,'craft','m230221_185926_drop_element_fks','2023-03-16 04:56:47','2023-03-16 04:56:47','2023-03-16 04:56:47','2d111c1b-f167-46ab-8d50-eeb56d7439e9'),(198,'craft','m230226_013114_drop_plugin_license_columns','2023-03-16 04:56:47','2023-03-16 04:56:47','2023-03-16 04:56:47','f48ef721-db16-4417-81cb-b9416f9f0ec2');
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `plugins`
--

LOCK TABLES `plugins` WRITE;
/*!40000 ALTER TABLE `plugins` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `plugins` VALUES (1,'redactor','2.10.10','2.3.0','2022-07-04 02:24:41','2022-07-04 02:24:41','2023-03-16 04:55:11','e0378d3e-ca30-4d8a-a5c4-3f76643a0442');
/*!40000 ALTER TABLE `plugins` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `projectconfig`
--

LOCK TABLES `projectconfig` WRITE;
/*!40000 ALTER TABLE `projectconfig` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `projectconfig` VALUES ('dateModified','1669881211'),('email.fromEmail','\"admin@wesvault.com\"'),('email.fromName','\"WV Trust\"'),('email.transportType','\"craft\\\\mail\\\\transportadapters\\\\Sendmail\"'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.0.autocapitalize','true'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.0.autocomplete','false'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.0.autocorrect','true'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.0.class','null'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.0.disabled','false'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.0.id','null'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.0.instructions','null'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.0.label','null'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.0.max','null'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.0.min','null'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.0.name','null'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.0.orientation','null'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.0.placeholder','null'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.0.readonly','false'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.0.requirable','false'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.0.size','null'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.0.step','null'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.0.tip','null'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.0.title','null'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\EntryTitleField\"'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.0.warning','null'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.0.width','100'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.1.fieldUid','\"b33ec018-8c1d-4b91-8711-31e8b020ce0a\"'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.1.instructions','null'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.1.label','null'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.1.required','false'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.1.tip','null'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.1.warning','null'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.elements.1.width','100'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.name','\"Content\"'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.fieldLayouts.a59d09ab-2a57-488d-af10-b75cd38ab57a.tabs.0.sortOrder','1'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.handle','\"billing\"'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.hasTitleField','true'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.name','\"Billing\"'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.section','\"41182da9-4532-4be7-a64b-ec2fc6dc82d2\"'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.sortOrder','1'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.titleFormat','null'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.titleTranslationKeyFormat','null'),('entryTypes.388d274a-addd-4e8e-9b91-4eaec06ff3f9.titleTranslationMethod','\"site\"'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.0.autocapitalize','true'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.0.autocomplete','false'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.0.autocorrect','true'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.0.class','null'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.0.disabled','false'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.0.id','null'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.0.instructions','null'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.0.label','null'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.0.max','null'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.0.min','null'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.0.name','null'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.0.orientation','null'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.0.placeholder','null'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.0.readonly','false'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.0.requirable','false'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.0.size','null'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.0.step','null'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.0.tip','null'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.0.title','null'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\EntryTitleField\"'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.0.warning','null'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.0.width','100'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.1.fieldUid','\"b33ec018-8c1d-4b91-8711-31e8b020ce0a\"'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.1.instructions','null'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.1.label','null'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.1.required','false'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.1.tip','null'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.1.warning','null'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.elements.1.width','100'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.name','\"Content\"'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.fieldLayouts.9147e7b2-af7d-485c-b41c-a324a92ec37c.tabs.0.sortOrder','1'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.handle','\"maintainece\"'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.hasTitleField','false'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.name','\"Maintainece\"'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.section','\"45328b02-47bd-4dc2-9cd0-d5fbca492ca2\"'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.sortOrder','1'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.titleFormat','\"{section.name|raw}\"'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.titleTranslationKeyFormat','null'),('entryTypes.9239b6a0-41c5-4717-b44d-27a4bb071832.titleTranslationMethod','\"site\"'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.0.autocapitalize','true'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.0.autocomplete','false'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.0.autocorrect','true'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.0.class','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.0.disabled','false'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.0.id','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.0.instructions','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.0.label','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.0.max','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.0.min','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.0.name','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.0.orientation','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.0.placeholder','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.0.readonly','false'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.0.requirable','false'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.0.size','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.0.step','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.0.tip','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.0.title','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\EntryTitleField\"'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.0.warning','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.0.width','100'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.1.fieldUid','\"b33ec018-8c1d-4b91-8711-31e8b020ce0a\"'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.1.instructions','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.1.label','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.1.required','false'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.1.tip','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.1.warning','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.1.width','100'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.2.fieldUid','\"5a9cab0c-2379-4a70-b9b3-76426c59833e\"'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.2.instructions','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.2.label','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.2.required','false'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.2.tip','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.2.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.2.warning','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.2.width','100'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.3.fieldUid','\"b7392388-c0aa-4007-ba39-5f268f0a2bbe\"'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.3.instructions','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.3.label','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.3.required','false'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.3.tip','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.3.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.3.warning','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.elements.3.width','100'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.name','\"Content\"'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.fieldLayouts.cbd014c1-6ba3-4fc5-8f0c-70a551b4728f.tabs.0.sortOrder','1'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.handle','\"default\"'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.hasTitleField','true'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.name','\"Default\"'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.section','\"13906807-3b1b-43fa-b531-55e16707323e\"'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.sortOrder','2'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.titleFormat','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.titleTranslationKeyFormat','null'),('entryTypes.cf39e515-68eb-4f8e-bac3-b7928c230eb6.titleTranslationMethod','\"site\"'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.0.autocapitalize','true'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.0.autocomplete','false'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.0.autocorrect','true'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.0.class','null'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.0.disabled','false'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.0.id','null'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.0.instructions','null'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.0.label','null'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.0.max','null'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.0.min','null'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.0.name','null'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.0.orientation','null'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.0.placeholder','null'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.0.readonly','false'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.0.requirable','false'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.0.size','null'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.0.step','null'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.0.tip','null'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.0.title','null'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\EntryTitleField\"'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.0.warning','null'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.0.width','100'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.1.fieldUid','\"32578409-4596-4fe9-b40a-530ea041c7e5\"'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.1.instructions','null'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.1.label','null'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.1.required','false'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.1.tip','null'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.1.warning','null'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.1.width','100'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.2.fieldUid','\"11c4fb00-409a-473d-bf23-ed69a40ccec3\"'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.2.instructions','null'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.2.label','null'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.2.required','false'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.2.tip','null'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.2.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.2.warning','null'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.elements.2.width','100'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.name','\"Content\"'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.fieldLayouts.a78266ac-58ed-41d9-b02d-1f07d7e1a2af.tabs.0.sortOrder','1'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.handle','\"homepage\"'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.hasTitleField','false'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.name','\"Homepage\"'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.section','\"a34c98ef-da5b-4203-ab2a-00134c3d3424\"'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.sortOrder','1'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.titleFormat','\"{section.name|raw}\"'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.titleTranslationKeyFormat','null'),('entryTypes.e10cefd1-b1af-40d8-90e6-e69c462e039c.titleTranslationMethod','\"site\"'),('fieldGroups.4532e13c-52d3-48d5-a1ab-a9526b969b3d.name','\"Property Blocks\"'),('fieldGroups.a29c4e08-0ee4-463d-a469-38769ac088da.name','\"home\"'),('fieldGroups.fd8a69c8-4f31-4c6f-bcba-c9f9a4351053.name','\"Common\"'),('fields.11c4fb00-409a-473d-bf23-ed69a40ccec3.columnSuffix','null'),('fields.11c4fb00-409a-473d-bf23-ed69a40ccec3.contentColumnType','\"string\"'),('fields.11c4fb00-409a-473d-bf23-ed69a40ccec3.fieldGroup','\"a29c4e08-0ee4-463d-a469-38769ac088da\"'),('fields.11c4fb00-409a-473d-bf23-ed69a40ccec3.handle','\"pagelinks\"'),('fields.11c4fb00-409a-473d-bf23-ed69a40ccec3.instructions','\"\"'),('fields.11c4fb00-409a-473d-bf23-ed69a40ccec3.name','\"Pagelinks\"'),('fields.11c4fb00-409a-473d-bf23-ed69a40ccec3.searchable','false'),('fields.11c4fb00-409a-473d-bf23-ed69a40ccec3.settings.contentTable','\"{{%matrixcontent_pagelinks}}\"'),('fields.11c4fb00-409a-473d-bf23-ed69a40ccec3.settings.maxBlocks','\"10\"'),('fields.11c4fb00-409a-473d-bf23-ed69a40ccec3.settings.minBlocks','\"1\"'),('fields.11c4fb00-409a-473d-bf23-ed69a40ccec3.settings.propagationKeyFormat','null'),('fields.11c4fb00-409a-473d-bf23-ed69a40ccec3.settings.propagationMethod','\"all\"'),('fields.11c4fb00-409a-473d-bf23-ed69a40ccec3.translationKeyFormat','null'),('fields.11c4fb00-409a-473d-bf23-ed69a40ccec3.translationMethod','\"site\"'),('fields.11c4fb00-409a-473d-bf23-ed69a40ccec3.type','\"craft\\\\fields\\\\Matrix\"'),('fields.32578409-4596-4fe9-b40a-530ea041c7e5.columnSuffix','\"oldpmmwb\"'),('fields.32578409-4596-4fe9-b40a-530ea041c7e5.contentColumnType','\"text\"'),('fields.32578409-4596-4fe9-b40a-530ea041c7e5.fieldGroup','\"a29c4e08-0ee4-463d-a469-38769ac088da\"'),('fields.32578409-4596-4fe9-b40a-530ea041c7e5.handle','\"introduction\"'),('fields.32578409-4596-4fe9-b40a-530ea041c7e5.instructions','\"Just basic introduction text\"'),('fields.32578409-4596-4fe9-b40a-530ea041c7e5.name','\"introduction\"'),('fields.32578409-4596-4fe9-b40a-530ea041c7e5.searchable','false'),('fields.32578409-4596-4fe9-b40a-530ea041c7e5.settings.availableTransforms','\"*\"'),('fields.32578409-4596-4fe9-b40a-530ea041c7e5.settings.availableVolumes','\"*\"'),('fields.32578409-4596-4fe9-b40a-530ea041c7e5.settings.columnType','\"text\"'),('fields.32578409-4596-4fe9-b40a-530ea041c7e5.settings.configSelectionMode','\"choose\"'),('fields.32578409-4596-4fe9-b40a-530ea041c7e5.settings.defaultTransform','\"\"'),('fields.32578409-4596-4fe9-b40a-530ea041c7e5.settings.manualConfig','\"\"'),('fields.32578409-4596-4fe9-b40a-530ea041c7e5.settings.purifierConfig','\"\"'),('fields.32578409-4596-4fe9-b40a-530ea041c7e5.settings.purifyHtml','\"1\"'),('fields.32578409-4596-4fe9-b40a-530ea041c7e5.settings.redactorConfig','\"\"'),('fields.32578409-4596-4fe9-b40a-530ea041c7e5.settings.removeEmptyTags','\"1\"'),('fields.32578409-4596-4fe9-b40a-530ea041c7e5.settings.removeInlineStyles','\"1\"'),('fields.32578409-4596-4fe9-b40a-530ea041c7e5.settings.removeNbsp','\"1\"'),('fields.32578409-4596-4fe9-b40a-530ea041c7e5.settings.showHtmlButtonForNonAdmins','\"\"'),('fields.32578409-4596-4fe9-b40a-530ea041c7e5.settings.showUnpermittedFiles','false'),('fields.32578409-4596-4fe9-b40a-530ea041c7e5.settings.showUnpermittedVolumes','false'),('fields.32578409-4596-4fe9-b40a-530ea041c7e5.settings.uiMode','\"enlarged\"'),('fields.32578409-4596-4fe9-b40a-530ea041c7e5.translationKeyFormat','null'),('fields.32578409-4596-4fe9-b40a-530ea041c7e5.translationMethod','\"none\"'),('fields.32578409-4596-4fe9-b40a-530ea041c7e5.type','\"craft\\\\redactor\\\\Field\"'),('fields.5a9cab0c-2379-4a70-b9b3-76426c59833e.columnSuffix','null'),('fields.5a9cab0c-2379-4a70-b9b3-76426c59833e.contentColumnType','\"string\"'),('fields.5a9cab0c-2379-4a70-b9b3-76426c59833e.fieldGroup','\"4532e13c-52d3-48d5-a1ab-a9526b969b3d\"'),('fields.5a9cab0c-2379-4a70-b9b3-76426c59833e.handle','\"serviceProviders\"'),('fields.5a9cab0c-2379-4a70-b9b3-76426c59833e.instructions','\"recommend service providers \"'),('fields.5a9cab0c-2379-4a70-b9b3-76426c59833e.name','\"service providers\"'),('fields.5a9cab0c-2379-4a70-b9b3-76426c59833e.searchable','false'),('fields.5a9cab0c-2379-4a70-b9b3-76426c59833e.settings.contentTable','\"{{%matrixcontent_serviceproviders}}\"'),('fields.5a9cab0c-2379-4a70-b9b3-76426c59833e.settings.maxBlocks','\"\"'),('fields.5a9cab0c-2379-4a70-b9b3-76426c59833e.settings.minBlocks','\"\"'),('fields.5a9cab0c-2379-4a70-b9b3-76426c59833e.settings.propagationKeyFormat','null'),('fields.5a9cab0c-2379-4a70-b9b3-76426c59833e.settings.propagationMethod','\"all\"'),('fields.5a9cab0c-2379-4a70-b9b3-76426c59833e.translationKeyFormat','null'),('fields.5a9cab0c-2379-4a70-b9b3-76426c59833e.translationMethod','\"site\"'),('fields.5a9cab0c-2379-4a70-b9b3-76426c59833e.type','\"craft\\\\fields\\\\Matrix\"'),('fields.b33ec018-8c1d-4b91-8711-31e8b020ce0a.columnSuffix','\"rbegzurr\"'),('fields.b33ec018-8c1d-4b91-8711-31e8b020ce0a.contentColumnType','\"text\"'),('fields.b33ec018-8c1d-4b91-8711-31e8b020ce0a.fieldGroup','\"fd8a69c8-4f31-4c6f-bcba-c9f9a4351053\"'),('fields.b33ec018-8c1d-4b91-8711-31e8b020ce0a.handle','\"pagecopy\"'),('fields.b33ec018-8c1d-4b91-8711-31e8b020ce0a.instructions','\"just the main stuff of the page\"'),('fields.b33ec018-8c1d-4b91-8711-31e8b020ce0a.name','\"Pagecopy\"'),('fields.b33ec018-8c1d-4b91-8711-31e8b020ce0a.searchable','false'),('fields.b33ec018-8c1d-4b91-8711-31e8b020ce0a.settings.availableTransforms','\"*\"'),('fields.b33ec018-8c1d-4b91-8711-31e8b020ce0a.settings.availableVolumes','\"*\"'),('fields.b33ec018-8c1d-4b91-8711-31e8b020ce0a.settings.columnType','\"text\"'),('fields.b33ec018-8c1d-4b91-8711-31e8b020ce0a.settings.configSelectionMode','\"choose\"'),('fields.b33ec018-8c1d-4b91-8711-31e8b020ce0a.settings.defaultTransform','\"\"'),('fields.b33ec018-8c1d-4b91-8711-31e8b020ce0a.settings.manualConfig','\"\"'),('fields.b33ec018-8c1d-4b91-8711-31e8b020ce0a.settings.purifierConfig','\"\"'),('fields.b33ec018-8c1d-4b91-8711-31e8b020ce0a.settings.purifyHtml','\"1\"'),('fields.b33ec018-8c1d-4b91-8711-31e8b020ce0a.settings.redactorConfig','\"\"'),('fields.b33ec018-8c1d-4b91-8711-31e8b020ce0a.settings.removeEmptyTags','\"1\"'),('fields.b33ec018-8c1d-4b91-8711-31e8b020ce0a.settings.removeInlineStyles','\"1\"'),('fields.b33ec018-8c1d-4b91-8711-31e8b020ce0a.settings.removeNbsp','\"1\"'),('fields.b33ec018-8c1d-4b91-8711-31e8b020ce0a.settings.showHtmlButtonForNonAdmins','\"\"'),('fields.b33ec018-8c1d-4b91-8711-31e8b020ce0a.settings.showUnpermittedFiles','false'),('fields.b33ec018-8c1d-4b91-8711-31e8b020ce0a.settings.showUnpermittedVolumes','false'),('fields.b33ec018-8c1d-4b91-8711-31e8b020ce0a.settings.uiMode','\"enlarged\"'),('fields.b33ec018-8c1d-4b91-8711-31e8b020ce0a.translationKeyFormat','null'),('fields.b33ec018-8c1d-4b91-8711-31e8b020ce0a.translationMethod','\"none\"'),('fields.b33ec018-8c1d-4b91-8711-31e8b020ce0a.type','\"craft\\\\redactor\\\\Field\"'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.columnSuffix','null'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.contentColumnType','\"string\"'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.fieldGroup','\"4532e13c-52d3-48d5-a1ab-a9526b969b3d\"'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.handle','\"mainImage\"'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.instructions','\"Picture of the property\"'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.name','\"main image\"'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.searchable','false'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.settings.allowedKinds','null'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.settings.allowSelfRelations','false'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.settings.allowUploads','true'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.settings.defaultUploadLocationSource','\"volume:4691da8f-b71c-465a-a5df-29d41a87e0a5\"'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.settings.defaultUploadLocationSubpath','\"\"'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.settings.limit','\"\"'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.settings.localizeRelations','false'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.settings.previewMode','\"full\"'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.settings.restrictFiles','\"\"'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.settings.selectionLabel','\"\"'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.settings.showSiteMenu','true'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.settings.showUnpermittedFiles','false'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.settings.showUnpermittedVolumes','false'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.settings.singleUploadLocationSource','\"volume:cdc2c8ee-142d-4714-a659-c1b46e254b25\"'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.settings.singleUploadLocationSubpath','\"\"'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.settings.source','null'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.settings.sources.0','\"volume:4691da8f-b71c-465a-a5df-29d41a87e0a5\"'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.settings.targetSiteId','null'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.settings.useSingleFolder','false'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.settings.validateRelatedElements','false'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.settings.viewMode','\"list\"'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.translationKeyFormat','null'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.translationMethod','\"site\"'),('fields.b7392388-c0aa-4007-ba39-5f268f0a2bbe.type','\"craft\\\\fields\\\\Assets\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.field','\"11c4fb00-409a-473d-bf23-ed69a40ccec3\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fieldLayouts.18fb859b-6081-49cb-b81c-92b73eeb07d3.tabs.0.elements.0.fieldUid','\"870bcb50-af4e-4c19-867a-e05088f23ca5\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fieldLayouts.18fb859b-6081-49cb-b81c-92b73eeb07d3.tabs.0.elements.0.instructions','null'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fieldLayouts.18fb859b-6081-49cb-b81c-92b73eeb07d3.tabs.0.elements.0.label','null'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fieldLayouts.18fb859b-6081-49cb-b81c-92b73eeb07d3.tabs.0.elements.0.required','false'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fieldLayouts.18fb859b-6081-49cb-b81c-92b73eeb07d3.tabs.0.elements.0.tip','null'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fieldLayouts.18fb859b-6081-49cb-b81c-92b73eeb07d3.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fieldLayouts.18fb859b-6081-49cb-b81c-92b73eeb07d3.tabs.0.elements.0.warning','null'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fieldLayouts.18fb859b-6081-49cb-b81c-92b73eeb07d3.tabs.0.elements.0.width','100'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fieldLayouts.18fb859b-6081-49cb-b81c-92b73eeb07d3.tabs.0.elements.1.fieldUid','\"0b54bcb2-2233-4648-8a6d-fcc710ba10b2\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fieldLayouts.18fb859b-6081-49cb-b81c-92b73eeb07d3.tabs.0.elements.1.instructions','null'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fieldLayouts.18fb859b-6081-49cb-b81c-92b73eeb07d3.tabs.0.elements.1.label','null'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fieldLayouts.18fb859b-6081-49cb-b81c-92b73eeb07d3.tabs.0.elements.1.required','false'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fieldLayouts.18fb859b-6081-49cb-b81c-92b73eeb07d3.tabs.0.elements.1.tip','null'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fieldLayouts.18fb859b-6081-49cb-b81c-92b73eeb07d3.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fieldLayouts.18fb859b-6081-49cb-b81c-92b73eeb07d3.tabs.0.elements.1.warning','null'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fieldLayouts.18fb859b-6081-49cb-b81c-92b73eeb07d3.tabs.0.elements.1.width','100'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fieldLayouts.18fb859b-6081-49cb-b81c-92b73eeb07d3.tabs.0.elements.2.fieldUid','\"1229c6cf-f0e1-44b4-af52-b591d2cddb65\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fieldLayouts.18fb859b-6081-49cb-b81c-92b73eeb07d3.tabs.0.elements.2.instructions','null'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fieldLayouts.18fb859b-6081-49cb-b81c-92b73eeb07d3.tabs.0.elements.2.label','null'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fieldLayouts.18fb859b-6081-49cb-b81c-92b73eeb07d3.tabs.0.elements.2.required','false'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fieldLayouts.18fb859b-6081-49cb-b81c-92b73eeb07d3.tabs.0.elements.2.tip','null'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fieldLayouts.18fb859b-6081-49cb-b81c-92b73eeb07d3.tabs.0.elements.2.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fieldLayouts.18fb859b-6081-49cb-b81c-92b73eeb07d3.tabs.0.elements.2.warning','null'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fieldLayouts.18fb859b-6081-49cb-b81c-92b73eeb07d3.tabs.0.elements.2.width','100'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fieldLayouts.18fb859b-6081-49cb-b81c-92b73eeb07d3.tabs.0.name','\"Content\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fieldLayouts.18fb859b-6081-49cb-b81c-92b73eeb07d3.tabs.0.sortOrder','1'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.0b54bcb2-2233-4648-8a6d-fcc710ba10b2.columnSuffix','\"jdjmkifc\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.0b54bcb2-2233-4648-8a6d-fcc710ba10b2.contentColumnType','\"string(400)\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.0b54bcb2-2233-4648-8a6d-fcc710ba10b2.fieldGroup','null'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.0b54bcb2-2233-4648-8a6d-fcc710ba10b2.handle','\"path\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.0b54bcb2-2233-4648-8a6d-fcc710ba10b2.instructions','\"path to the link\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.0b54bcb2-2233-4648-8a6d-fcc710ba10b2.name','\"path\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.0b54bcb2-2233-4648-8a6d-fcc710ba10b2.searchable','false'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.0b54bcb2-2233-4648-8a6d-fcc710ba10b2.settings.byteLimit','null'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.0b54bcb2-2233-4648-8a6d-fcc710ba10b2.settings.charLimit','100'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.0b54bcb2-2233-4648-8a6d-fcc710ba10b2.settings.code','\"\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.0b54bcb2-2233-4648-8a6d-fcc710ba10b2.settings.columnType','null'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.0b54bcb2-2233-4648-8a6d-fcc710ba10b2.settings.initialRows','\"4\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.0b54bcb2-2233-4648-8a6d-fcc710ba10b2.settings.multiline','\"\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.0b54bcb2-2233-4648-8a6d-fcc710ba10b2.settings.placeholder','\"Path\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.0b54bcb2-2233-4648-8a6d-fcc710ba10b2.settings.uiMode','\"normal\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.0b54bcb2-2233-4648-8a6d-fcc710ba10b2.translationKeyFormat','null'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.0b54bcb2-2233-4648-8a6d-fcc710ba10b2.translationMethod','\"none\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.0b54bcb2-2233-4648-8a6d-fcc710ba10b2.type','\"craft\\\\fields\\\\PlainText\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.1229c6cf-f0e1-44b4-af52-b591d2cddb65.columnSuffix','\"czvzkzmw\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.1229c6cf-f0e1-44b4-af52-b591d2cddb65.contentColumnType','\"string(800)\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.1229c6cf-f0e1-44b4-af52-b591d2cddb65.fieldGroup','null'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.1229c6cf-f0e1-44b4-af52-b591d2cddb65.handle','\"description\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.1229c6cf-f0e1-44b4-af52-b591d2cddb65.instructions','\"\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.1229c6cf-f0e1-44b4-af52-b591d2cddb65.name','\"description\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.1229c6cf-f0e1-44b4-af52-b591d2cddb65.searchable','false'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.1229c6cf-f0e1-44b4-af52-b591d2cddb65.settings.byteLimit','null'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.1229c6cf-f0e1-44b4-af52-b591d2cddb65.settings.charLimit','200'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.1229c6cf-f0e1-44b4-af52-b591d2cddb65.settings.code','\"\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.1229c6cf-f0e1-44b4-af52-b591d2cddb65.settings.columnType','null'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.1229c6cf-f0e1-44b4-af52-b591d2cddb65.settings.initialRows','\"4\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.1229c6cf-f0e1-44b4-af52-b591d2cddb65.settings.multiline','\"\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.1229c6cf-f0e1-44b4-af52-b591d2cddb65.settings.placeholder','\"Description\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.1229c6cf-f0e1-44b4-af52-b591d2cddb65.settings.uiMode','\"normal\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.1229c6cf-f0e1-44b4-af52-b591d2cddb65.translationKeyFormat','null'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.1229c6cf-f0e1-44b4-af52-b591d2cddb65.translationMethod','\"none\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.1229c6cf-f0e1-44b4-af52-b591d2cddb65.type','\"craft\\\\fields\\\\PlainText\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.870bcb50-af4e-4c19-867a-e05088f23ca5.columnSuffix','\"dotldesy\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.870bcb50-af4e-4c19-867a-e05088f23ca5.contentColumnType','\"string(200)\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.870bcb50-af4e-4c19-867a-e05088f23ca5.fieldGroup','null'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.870bcb50-af4e-4c19-867a-e05088f23ca5.handle','\"linkname\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.870bcb50-af4e-4c19-867a-e05088f23ca5.instructions','\"\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.870bcb50-af4e-4c19-867a-e05088f23ca5.name','\"Linkname\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.870bcb50-af4e-4c19-867a-e05088f23ca5.searchable','false'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.870bcb50-af4e-4c19-867a-e05088f23ca5.settings.byteLimit','null'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.870bcb50-af4e-4c19-867a-e05088f23ca5.settings.charLimit','50'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.870bcb50-af4e-4c19-867a-e05088f23ca5.settings.code','\"\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.870bcb50-af4e-4c19-867a-e05088f23ca5.settings.columnType','null'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.870bcb50-af4e-4c19-867a-e05088f23ca5.settings.initialRows','\"4\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.870bcb50-af4e-4c19-867a-e05088f23ca5.settings.multiline','\"\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.870bcb50-af4e-4c19-867a-e05088f23ca5.settings.placeholder','\"Name \"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.870bcb50-af4e-4c19-867a-e05088f23ca5.settings.uiMode','\"normal\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.870bcb50-af4e-4c19-867a-e05088f23ca5.translationKeyFormat','null'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.870bcb50-af4e-4c19-867a-e05088f23ca5.translationMethod','\"none\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.fields.870bcb50-af4e-4c19-867a-e05088f23ca5.type','\"craft\\\\fields\\\\PlainText\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.handle','\"link\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.name','\"link\"'),('matrixBlockTypes.6c13d5a4-07fa-4982-9011-8299498c1ad3.sortOrder','1'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.field','\"5a9cab0c-2379-4a70-b9b3-76426c59833e\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fieldLayouts.8e8fc1d7-9656-4857-8d0a-2c3acee9d885.tabs.0.elements.0.fieldUid','\"f617a4e5-c7c4-49bd-9517-db6b7c84742d\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fieldLayouts.8e8fc1d7-9656-4857-8d0a-2c3acee9d885.tabs.0.elements.0.instructions','null'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fieldLayouts.8e8fc1d7-9656-4857-8d0a-2c3acee9d885.tabs.0.elements.0.label','null'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fieldLayouts.8e8fc1d7-9656-4857-8d0a-2c3acee9d885.tabs.0.elements.0.required','false'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fieldLayouts.8e8fc1d7-9656-4857-8d0a-2c3acee9d885.tabs.0.elements.0.tip','null'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fieldLayouts.8e8fc1d7-9656-4857-8d0a-2c3acee9d885.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fieldLayouts.8e8fc1d7-9656-4857-8d0a-2c3acee9d885.tabs.0.elements.0.warning','null'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fieldLayouts.8e8fc1d7-9656-4857-8d0a-2c3acee9d885.tabs.0.elements.0.width','100'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fieldLayouts.8e8fc1d7-9656-4857-8d0a-2c3acee9d885.tabs.0.elements.1.fieldUid','\"b76e1673-8377-4694-9733-d468ac184644\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fieldLayouts.8e8fc1d7-9656-4857-8d0a-2c3acee9d885.tabs.0.elements.1.instructions','null'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fieldLayouts.8e8fc1d7-9656-4857-8d0a-2c3acee9d885.tabs.0.elements.1.label','null'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fieldLayouts.8e8fc1d7-9656-4857-8d0a-2c3acee9d885.tabs.0.elements.1.required','false'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fieldLayouts.8e8fc1d7-9656-4857-8d0a-2c3acee9d885.tabs.0.elements.1.tip','null'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fieldLayouts.8e8fc1d7-9656-4857-8d0a-2c3acee9d885.tabs.0.elements.1.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fieldLayouts.8e8fc1d7-9656-4857-8d0a-2c3acee9d885.tabs.0.elements.1.warning','null'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fieldLayouts.8e8fc1d7-9656-4857-8d0a-2c3acee9d885.tabs.0.elements.1.width','100'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fieldLayouts.8e8fc1d7-9656-4857-8d0a-2c3acee9d885.tabs.0.elements.2.fieldUid','\"bf766438-211a-4b0a-818c-da0f4533ae65\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fieldLayouts.8e8fc1d7-9656-4857-8d0a-2c3acee9d885.tabs.0.elements.2.instructions','null'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fieldLayouts.8e8fc1d7-9656-4857-8d0a-2c3acee9d885.tabs.0.elements.2.label','null'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fieldLayouts.8e8fc1d7-9656-4857-8d0a-2c3acee9d885.tabs.0.elements.2.required','false'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fieldLayouts.8e8fc1d7-9656-4857-8d0a-2c3acee9d885.tabs.0.elements.2.tip','null'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fieldLayouts.8e8fc1d7-9656-4857-8d0a-2c3acee9d885.tabs.0.elements.2.type','\"craft\\\\fieldlayoutelements\\\\CustomField\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fieldLayouts.8e8fc1d7-9656-4857-8d0a-2c3acee9d885.tabs.0.elements.2.warning','null'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fieldLayouts.8e8fc1d7-9656-4857-8d0a-2c3acee9d885.tabs.0.elements.2.width','100'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fieldLayouts.8e8fc1d7-9656-4857-8d0a-2c3acee9d885.tabs.0.name','\"Content\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fieldLayouts.8e8fc1d7-9656-4857-8d0a-2c3acee9d885.tabs.0.sortOrder','1'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.b76e1673-8377-4694-9733-d468ac184644.columnSuffix','\"dkbjfaab\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.b76e1673-8377-4694-9733-d468ac184644.contentColumnType','\"string\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.b76e1673-8377-4694-9733-d468ac184644.fieldGroup','null'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.b76e1673-8377-4694-9733-d468ac184644.handle','\"businessType\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.b76e1673-8377-4694-9733-d468ac184644.instructions','\"Type of business\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.b76e1673-8377-4694-9733-d468ac184644.name','\"business type\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.b76e1673-8377-4694-9733-d468ac184644.searchable','false'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.b76e1673-8377-4694-9733-d468ac184644.settings.optgroups','true'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.b76e1673-8377-4694-9733-d468ac184644.settings.options.0.__assoc__.0.0','\"label\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.b76e1673-8377-4694-9733-d468ac184644.settings.options.0.__assoc__.0.1','\"Air Conditioning\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.b76e1673-8377-4694-9733-d468ac184644.settings.options.0.__assoc__.1.0','\"value\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.b76e1673-8377-4694-9733-d468ac184644.settings.options.0.__assoc__.1.1','\"airConditioning\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.b76e1673-8377-4694-9733-d468ac184644.settings.options.0.__assoc__.2.0','\"default\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.b76e1673-8377-4694-9733-d468ac184644.settings.options.0.__assoc__.2.1','\"\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.b76e1673-8377-4694-9733-d468ac184644.settings.options.1.__assoc__.0.0','\"label\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.b76e1673-8377-4694-9733-d468ac184644.settings.options.1.__assoc__.0.1','\"Shutter Repair\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.b76e1673-8377-4694-9733-d468ac184644.settings.options.1.__assoc__.1.0','\"value\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.b76e1673-8377-4694-9733-d468ac184644.settings.options.1.__assoc__.1.1','\"shutterRepair\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.b76e1673-8377-4694-9733-d468ac184644.settings.options.1.__assoc__.2.0','\"default\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.b76e1673-8377-4694-9733-d468ac184644.settings.options.1.__assoc__.2.1','\"\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.b76e1673-8377-4694-9733-d468ac184644.translationKeyFormat','null'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.b76e1673-8377-4694-9733-d468ac184644.translationMethod','\"none\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.b76e1673-8377-4694-9733-d468ac184644.type','\"craft\\\\fields\\\\Dropdown\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.bf766438-211a-4b0a-818c-da0f4533ae65.columnSuffix','\"epbvbqny\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.bf766438-211a-4b0a-818c-da0f4533ae65.contentColumnType','\"text\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.bf766438-211a-4b0a-818c-da0f4533ae65.fieldGroup','null'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.bf766438-211a-4b0a-818c-da0f4533ae65.handle','\"contactDetails\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.bf766438-211a-4b0a-818c-da0f4533ae65.instructions','\"\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.bf766438-211a-4b0a-818c-da0f4533ae65.name','\"contact details\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.bf766438-211a-4b0a-818c-da0f4533ae65.searchable','false'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.bf766438-211a-4b0a-818c-da0f4533ae65.settings.availableTransforms','\"*\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.bf766438-211a-4b0a-818c-da0f4533ae65.settings.availableVolumes','\"*\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.bf766438-211a-4b0a-818c-da0f4533ae65.settings.columnType','\"text\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.bf766438-211a-4b0a-818c-da0f4533ae65.settings.configSelectionMode','\"choose\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.bf766438-211a-4b0a-818c-da0f4533ae65.settings.defaultTransform','\"\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.bf766438-211a-4b0a-818c-da0f4533ae65.settings.manualConfig','\"\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.bf766438-211a-4b0a-818c-da0f4533ae65.settings.purifierConfig','\"\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.bf766438-211a-4b0a-818c-da0f4533ae65.settings.purifyHtml','\"1\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.bf766438-211a-4b0a-818c-da0f4533ae65.settings.redactorConfig','\"\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.bf766438-211a-4b0a-818c-da0f4533ae65.settings.removeEmptyTags','\"1\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.bf766438-211a-4b0a-818c-da0f4533ae65.settings.removeInlineStyles','\"1\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.bf766438-211a-4b0a-818c-da0f4533ae65.settings.removeNbsp','\"1\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.bf766438-211a-4b0a-818c-da0f4533ae65.settings.showHtmlButtonForNonAdmins','\"\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.bf766438-211a-4b0a-818c-da0f4533ae65.settings.showUnpermittedFiles','false'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.bf766438-211a-4b0a-818c-da0f4533ae65.settings.showUnpermittedVolumes','false'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.bf766438-211a-4b0a-818c-da0f4533ae65.settings.uiMode','\"enlarged\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.bf766438-211a-4b0a-818c-da0f4533ae65.translationKeyFormat','null'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.bf766438-211a-4b0a-818c-da0f4533ae65.translationMethod','\"none\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.bf766438-211a-4b0a-818c-da0f4533ae65.type','\"craft\\\\redactor\\\\Field\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.f617a4e5-c7c4-49bd-9517-db6b7c84742d.columnSuffix','\"ixuxkuzm\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.f617a4e5-c7c4-49bd-9517-db6b7c84742d.contentColumnType','\"text\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.f617a4e5-c7c4-49bd-9517-db6b7c84742d.fieldGroup','null'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.f617a4e5-c7c4-49bd-9517-db6b7c84742d.handle','\"businessName\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.f617a4e5-c7c4-49bd-9517-db6b7c84742d.instructions','\"\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.f617a4e5-c7c4-49bd-9517-db6b7c84742d.name','\"business name\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.f617a4e5-c7c4-49bd-9517-db6b7c84742d.searchable','false'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.f617a4e5-c7c4-49bd-9517-db6b7c84742d.settings.byteLimit','null'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.f617a4e5-c7c4-49bd-9517-db6b7c84742d.settings.charLimit','null'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.f617a4e5-c7c4-49bd-9517-db6b7c84742d.settings.code','\"\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.f617a4e5-c7c4-49bd-9517-db6b7c84742d.settings.columnType','null'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.f617a4e5-c7c4-49bd-9517-db6b7c84742d.settings.initialRows','\"4\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.f617a4e5-c7c4-49bd-9517-db6b7c84742d.settings.multiline','\"\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.f617a4e5-c7c4-49bd-9517-db6b7c84742d.settings.placeholder','null'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.f617a4e5-c7c4-49bd-9517-db6b7c84742d.settings.uiMode','\"normal\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.f617a4e5-c7c4-49bd-9517-db6b7c84742d.translationKeyFormat','null'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.f617a4e5-c7c4-49bd-9517-db6b7c84742d.translationMethod','\"none\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.fields.f617a4e5-c7c4-49bd-9517-db6b7c84742d.type','\"craft\\\\fields\\\\PlainText\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.handle','\"vendor\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.name','\"vendor\"'),('matrixBlockTypes.87abb876-efda-45ae-b75c-9df708501a10.sortOrder','1'),('meta.__names__.0b54bcb2-2233-4648-8a6d-fcc710ba10b2','\"path\"'),('meta.__names__.1133b123-9600-4fc1-b59b-f51011da76fe','\"text\"'),('meta.__names__.11c4fb00-409a-473d-bf23-ed69a40ccec3','\"Pagelinks\"'),('meta.__names__.1229c6cf-f0e1-44b4-af52-b591d2cddb65','\"description\"'),('meta.__names__.128cde9d-33b0-4d0a-a8b7-c12ab3eff8bc','\"img\"'),('meta.__names__.13906807-3b1b-43fa-b531-55e16707323e','\"property\"'),('meta.__names__.32578409-4596-4fe9-b40a-530ea041c7e5','\"introduction\"'),('meta.__names__.388d274a-addd-4e8e-9b91-4eaec06ff3f9','\"Billing\"'),('meta.__names__.41182da9-4532-4be7-a64b-ec2fc6dc82d2','\"Billing\"'),('meta.__names__.45328b02-47bd-4dc2-9cd0-d5fbca492ca2','\"Maintainece\"'),('meta.__names__.4532e13c-52d3-48d5-a1ab-a9526b969b3d','\"Property Blocks\"'),('meta.__names__.4691da8f-b71c-465a-a5df-29d41a87e0a5','\"Property\"'),('meta.__names__.52e933c4-1638-4b82-8406-a9e8639fe56d','\"WV Trust\"'),('meta.__names__.5a9cab0c-2379-4a70-b9b3-76426c59833e','\"service providers\"'),('meta.__names__.6c13d5a4-07fa-4982-9011-8299498c1ad3','\"link\"'),('meta.__names__.7da2d549-b273-40bf-ad51-e8fe2202460e','\"text\"'),('meta.__names__.870bcb50-af4e-4c19-867a-e05088f23ca5','\"Linkname\"'),('meta.__names__.87abb876-efda-45ae-b75c-9df708501a10','\"vendor\"'),('meta.__names__.9239b6a0-41c5-4717-b44d-27a4bb071832','\"Maintainece\"'),('meta.__names__.a29c4e08-0ee4-463d-a469-38769ac088da','\"home\"'),('meta.__names__.a34c98ef-da5b-4203-ab2a-00134c3d3424','\"Homepage\"'),('meta.__names__.a7703bae-b817-4711-acfb-83fb257f9cdf','\"WV Trust\"'),('meta.__names__.b33ec018-8c1d-4b91-8711-31e8b020ce0a','\"Pagecopy\"'),('meta.__names__.b7392388-c0aa-4007-ba39-5f268f0a2bbe','\"main image\"'),('meta.__names__.b76e1673-8377-4694-9733-d468ac184644','\"business type\"'),('meta.__names__.bf766438-211a-4b0a-818c-da0f4533ae65','\"contact details\"'),('meta.__names__.cdc2c8ee-142d-4714-a659-c1b46e254b25','\"Homepage\"'),('meta.__names__.cf39e515-68eb-4f8e-bac3-b7928c230eb6','\"Default\"'),('meta.__names__.e10cefd1-b1af-40d8-90e6-e69c462e039c','\"Homepage\"'),('meta.__names__.f617a4e5-c7c4-49bd-9517-db6b7c84742d','\"business name\"'),('meta.__names__.fd8a69c8-4f31-4c6f-bcba-c9f9a4351053','\"Common\"'),('plugins.redactor.edition','\"standard\"'),('plugins.redactor.enabled','true'),('plugins.redactor.schemaVersion','\"2.3.0\"'),('sections.13906807-3b1b-43fa-b531-55e16707323e.defaultPlacement','\"beginning\"'),('sections.13906807-3b1b-43fa-b531-55e16707323e.enableVersioning','false'),('sections.13906807-3b1b-43fa-b531-55e16707323e.handle','\"property\"'),('sections.13906807-3b1b-43fa-b531-55e16707323e.name','\"property\"'),('sections.13906807-3b1b-43fa-b531-55e16707323e.propagationMethod','\"all\"'),('sections.13906807-3b1b-43fa-b531-55e16707323e.siteSettings.a7703bae-b817-4711-acfb-83fb257f9cdf.enabledByDefault','true'),('sections.13906807-3b1b-43fa-b531-55e16707323e.siteSettings.a7703bae-b817-4711-acfb-83fb257f9cdf.hasUrls','true'),('sections.13906807-3b1b-43fa-b531-55e16707323e.siteSettings.a7703bae-b817-4711-acfb-83fb257f9cdf.template','\"property/_entry.twig\"'),('sections.13906807-3b1b-43fa-b531-55e16707323e.siteSettings.a7703bae-b817-4711-acfb-83fb257f9cdf.uriFormat','\"property/{slug}\"'),('sections.13906807-3b1b-43fa-b531-55e16707323e.structure.maxLevels','null'),('sections.13906807-3b1b-43fa-b531-55e16707323e.structure.uid','\"33317265-c7a2-4710-bc21-c49526dcbc64\"'),('sections.13906807-3b1b-43fa-b531-55e16707323e.type','\"structure\"'),('sections.41182da9-4532-4be7-a64b-ec2fc6dc82d2.defaultPlacement','\"end\"'),('sections.41182da9-4532-4be7-a64b-ec2fc6dc82d2.enableVersioning','true'),('sections.41182da9-4532-4be7-a64b-ec2fc6dc82d2.handle','\"billing\"'),('sections.41182da9-4532-4be7-a64b-ec2fc6dc82d2.name','\"Billing\"'),('sections.41182da9-4532-4be7-a64b-ec2fc6dc82d2.propagationMethod','\"all\"'),('sections.41182da9-4532-4be7-a64b-ec2fc6dc82d2.siteSettings.a7703bae-b817-4711-acfb-83fb257f9cdf.enabledByDefault','true'),('sections.41182da9-4532-4be7-a64b-ec2fc6dc82d2.siteSettings.a7703bae-b817-4711-acfb-83fb257f9cdf.hasUrls','true'),('sections.41182da9-4532-4be7-a64b-ec2fc6dc82d2.siteSettings.a7703bae-b817-4711-acfb-83fb257f9cdf.template','\"_content.twig\"'),('sections.41182da9-4532-4be7-a64b-ec2fc6dc82d2.siteSettings.a7703bae-b817-4711-acfb-83fb257f9cdf.uriFormat','\"billing\"'),('sections.41182da9-4532-4be7-a64b-ec2fc6dc82d2.type','\"single\"'),('sections.45328b02-47bd-4dc2-9cd0-d5fbca492ca2.defaultPlacement','\"end\"'),('sections.45328b02-47bd-4dc2-9cd0-d5fbca492ca2.enableVersioning','false'),('sections.45328b02-47bd-4dc2-9cd0-d5fbca492ca2.handle','\"maintainece\"'),('sections.45328b02-47bd-4dc2-9cd0-d5fbca492ca2.name','\"Maintainece\"'),('sections.45328b02-47bd-4dc2-9cd0-d5fbca492ca2.propagationMethod','\"all\"'),('sections.45328b02-47bd-4dc2-9cd0-d5fbca492ca2.siteSettings.a7703bae-b817-4711-acfb-83fb257f9cdf.enabledByDefault','true'),('sections.45328b02-47bd-4dc2-9cd0-d5fbca492ca2.siteSettings.a7703bae-b817-4711-acfb-83fb257f9cdf.hasUrls','true'),('sections.45328b02-47bd-4dc2-9cd0-d5fbca492ca2.siteSettings.a7703bae-b817-4711-acfb-83fb257f9cdf.template','\"_content.twig\"'),('sections.45328b02-47bd-4dc2-9cd0-d5fbca492ca2.siteSettings.a7703bae-b817-4711-acfb-83fb257f9cdf.uriFormat','\"maintainece\"'),('sections.45328b02-47bd-4dc2-9cd0-d5fbca492ca2.type','\"single\"'),('sections.a34c98ef-da5b-4203-ab2a-00134c3d3424.defaultPlacement','\"end\"'),('sections.a34c98ef-da5b-4203-ab2a-00134c3d3424.enableVersioning','true'),('sections.a34c98ef-da5b-4203-ab2a-00134c3d3424.handle','\"homepage\"'),('sections.a34c98ef-da5b-4203-ab2a-00134c3d3424.name','\"Homepage\"'),('sections.a34c98ef-da5b-4203-ab2a-00134c3d3424.propagationMethod','\"all\"'),('sections.a34c98ef-da5b-4203-ab2a-00134c3d3424.siteSettings.a7703bae-b817-4711-acfb-83fb257f9cdf.enabledByDefault','true'),('sections.a34c98ef-da5b-4203-ab2a-00134c3d3424.siteSettings.a7703bae-b817-4711-acfb-83fb257f9cdf.hasUrls','true'),('sections.a34c98ef-da5b-4203-ab2a-00134c3d3424.siteSettings.a7703bae-b817-4711-acfb-83fb257f9cdf.template','\"index.twig\"'),('sections.a34c98ef-da5b-4203-ab2a-00134c3d3424.siteSettings.a7703bae-b817-4711-acfb-83fb257f9cdf.uriFormat','\"__home__\"'),('sections.a34c98ef-da5b-4203-ab2a-00134c3d3424.type','\"single\"'),('siteGroups.52e933c4-1638-4b82-8406-a9e8639fe56d.name','\"WV Trust\"'),('sites.a7703bae-b817-4711-acfb-83fb257f9cdf.baseUrl','\"$PRIMARY_SITE_URL\"'),('sites.a7703bae-b817-4711-acfb-83fb257f9cdf.handle','\"default\"'),('sites.a7703bae-b817-4711-acfb-83fb257f9cdf.hasUrls','true'),('sites.a7703bae-b817-4711-acfb-83fb257f9cdf.language','\"en-US\"'),('sites.a7703bae-b817-4711-acfb-83fb257f9cdf.name','\"WV Trust\"'),('sites.a7703bae-b817-4711-acfb-83fb257f9cdf.primary','true'),('sites.a7703bae-b817-4711-acfb-83fb257f9cdf.siteGroup','\"52e933c4-1638-4b82-8406-a9e8639fe56d\"'),('sites.a7703bae-b817-4711-acfb-83fb257f9cdf.sortOrder','1'),('system.edition','\"solo\"'),('system.live','true'),('system.name','\"WV Trust\"'),('system.schemaVersion','\"3.7.33\"'),('system.timeZone','\"America/Los_Angeles\"'),('users.allowPublicRegistration','false'),('users.defaultGroup','null'),('users.photoSubpath','null'),('users.photoVolumeUid','null'),('users.requireEmailVerification','true'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.fieldLayouts.1edcbe18-0a6a-484e-a01c-c5681fa0d9e7.tabs.0.elements.0.autocapitalize','true'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.fieldLayouts.1edcbe18-0a6a-484e-a01c-c5681fa0d9e7.tabs.0.elements.0.autocomplete','false'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.fieldLayouts.1edcbe18-0a6a-484e-a01c-c5681fa0d9e7.tabs.0.elements.0.autocorrect','true'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.fieldLayouts.1edcbe18-0a6a-484e-a01c-c5681fa0d9e7.tabs.0.elements.0.class','null'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.fieldLayouts.1edcbe18-0a6a-484e-a01c-c5681fa0d9e7.tabs.0.elements.0.disabled','false'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.fieldLayouts.1edcbe18-0a6a-484e-a01c-c5681fa0d9e7.tabs.0.elements.0.id','null'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.fieldLayouts.1edcbe18-0a6a-484e-a01c-c5681fa0d9e7.tabs.0.elements.0.instructions','null'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.fieldLayouts.1edcbe18-0a6a-484e-a01c-c5681fa0d9e7.tabs.0.elements.0.label','null'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.fieldLayouts.1edcbe18-0a6a-484e-a01c-c5681fa0d9e7.tabs.0.elements.0.max','null'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.fieldLayouts.1edcbe18-0a6a-484e-a01c-c5681fa0d9e7.tabs.0.elements.0.min','null'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.fieldLayouts.1edcbe18-0a6a-484e-a01c-c5681fa0d9e7.tabs.0.elements.0.name','null'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.fieldLayouts.1edcbe18-0a6a-484e-a01c-c5681fa0d9e7.tabs.0.elements.0.orientation','null'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.fieldLayouts.1edcbe18-0a6a-484e-a01c-c5681fa0d9e7.tabs.0.elements.0.placeholder','null'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.fieldLayouts.1edcbe18-0a6a-484e-a01c-c5681fa0d9e7.tabs.0.elements.0.readonly','false'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.fieldLayouts.1edcbe18-0a6a-484e-a01c-c5681fa0d9e7.tabs.0.elements.0.requirable','false'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.fieldLayouts.1edcbe18-0a6a-484e-a01c-c5681fa0d9e7.tabs.0.elements.0.size','null'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.fieldLayouts.1edcbe18-0a6a-484e-a01c-c5681fa0d9e7.tabs.0.elements.0.step','null'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.fieldLayouts.1edcbe18-0a6a-484e-a01c-c5681fa0d9e7.tabs.0.elements.0.tip','null'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.fieldLayouts.1edcbe18-0a6a-484e-a01c-c5681fa0d9e7.tabs.0.elements.0.title','null'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.fieldLayouts.1edcbe18-0a6a-484e-a01c-c5681fa0d9e7.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\AssetTitleField\"'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.fieldLayouts.1edcbe18-0a6a-484e-a01c-c5681fa0d9e7.tabs.0.elements.0.warning','null'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.fieldLayouts.1edcbe18-0a6a-484e-a01c-c5681fa0d9e7.tabs.0.elements.0.width','100'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.fieldLayouts.1edcbe18-0a6a-484e-a01c-c5681fa0d9e7.tabs.0.name','\"Content\"'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.fieldLayouts.1edcbe18-0a6a-484e-a01c-c5681fa0d9e7.tabs.0.sortOrder','1'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.handle','\"property\"'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.hasUrls','true'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.name','\"Property\"'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.settings.path','\"@webroot/images/uploads/property\"'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.sortOrder','2'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.titleTranslationKeyFormat','null'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.titleTranslationMethod','null'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.type','\"craft\\\\volumes\\\\Local\"'),('volumes.4691da8f-b71c-465a-a5df-29d41a87e0a5.url','\"@web/images/uploads/property\"'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.fieldLayouts.219cccb7-50d4-4bbe-bf5a-33a900b3010a.tabs.0.elements.0.autocapitalize','true'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.fieldLayouts.219cccb7-50d4-4bbe-bf5a-33a900b3010a.tabs.0.elements.0.autocomplete','false'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.fieldLayouts.219cccb7-50d4-4bbe-bf5a-33a900b3010a.tabs.0.elements.0.autocorrect','true'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.fieldLayouts.219cccb7-50d4-4bbe-bf5a-33a900b3010a.tabs.0.elements.0.class','null'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.fieldLayouts.219cccb7-50d4-4bbe-bf5a-33a900b3010a.tabs.0.elements.0.disabled','false'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.fieldLayouts.219cccb7-50d4-4bbe-bf5a-33a900b3010a.tabs.0.elements.0.id','null'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.fieldLayouts.219cccb7-50d4-4bbe-bf5a-33a900b3010a.tabs.0.elements.0.instructions','null'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.fieldLayouts.219cccb7-50d4-4bbe-bf5a-33a900b3010a.tabs.0.elements.0.label','null'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.fieldLayouts.219cccb7-50d4-4bbe-bf5a-33a900b3010a.tabs.0.elements.0.max','null'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.fieldLayouts.219cccb7-50d4-4bbe-bf5a-33a900b3010a.tabs.0.elements.0.min','null'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.fieldLayouts.219cccb7-50d4-4bbe-bf5a-33a900b3010a.tabs.0.elements.0.name','null'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.fieldLayouts.219cccb7-50d4-4bbe-bf5a-33a900b3010a.tabs.0.elements.0.orientation','null'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.fieldLayouts.219cccb7-50d4-4bbe-bf5a-33a900b3010a.tabs.0.elements.0.placeholder','null'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.fieldLayouts.219cccb7-50d4-4bbe-bf5a-33a900b3010a.tabs.0.elements.0.readonly','false'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.fieldLayouts.219cccb7-50d4-4bbe-bf5a-33a900b3010a.tabs.0.elements.0.requirable','false'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.fieldLayouts.219cccb7-50d4-4bbe-bf5a-33a900b3010a.tabs.0.elements.0.size','null'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.fieldLayouts.219cccb7-50d4-4bbe-bf5a-33a900b3010a.tabs.0.elements.0.step','null'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.fieldLayouts.219cccb7-50d4-4bbe-bf5a-33a900b3010a.tabs.0.elements.0.tip','null'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.fieldLayouts.219cccb7-50d4-4bbe-bf5a-33a900b3010a.tabs.0.elements.0.title','null'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.fieldLayouts.219cccb7-50d4-4bbe-bf5a-33a900b3010a.tabs.0.elements.0.type','\"craft\\\\fieldlayoutelements\\\\AssetTitleField\"'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.fieldLayouts.219cccb7-50d4-4bbe-bf5a-33a900b3010a.tabs.0.elements.0.warning','null'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.fieldLayouts.219cccb7-50d4-4bbe-bf5a-33a900b3010a.tabs.0.elements.0.width','100'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.fieldLayouts.219cccb7-50d4-4bbe-bf5a-33a900b3010a.tabs.0.name','\"Content\"'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.fieldLayouts.219cccb7-50d4-4bbe-bf5a-33a900b3010a.tabs.0.sortOrder','1'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.handle','\"homepage\"'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.hasUrls','true'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.name','\"Homepage\"'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.settings.path','\"@webroot/images/uploads/homepage\"'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.sortOrder','1'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.titleTranslationKeyFormat','null'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.titleTranslationMethod','null'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.type','\"craft\\\\volumes\\\\Local\"'),('volumes.cdc2c8ee-142d-4714-a659-c1b46e254b25.url','\"@web/images/uploads/homepage\"');
/*!40000 ALTER TABLE `projectconfig` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `queue`
--

LOCK TABLES `queue` WRITE;
/*!40000 ALTER TABLE `queue` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `queue` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `relations`
--

LOCK TABLES `relations` WRITE;
/*!40000 ALTER TABLE `relations` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `relations` VALUES (11,15,132,NULL,205,1,'2022-12-01 07:51:27','2022-12-01 07:51:27','b1ff75b7-cc59-4702-a2a9-ec5e92803eb0'),(12,15,221,NULL,205,1,'2023-04-19 02:38:45','2023-04-19 02:38:45','1e14fade-2590-49d2-a825-230336c27ddd');
/*!40000 ALTER TABLE `relations` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `revisions` VALUES (1,2,1,1,NULL),(2,2,1,2,NULL),(3,2,1,3,'Applied “Draft 1”'),(4,2,1,4,'Applied “Draft 1”'),(5,2,1,5,NULL),(6,2,1,6,'Applied “Draft 1”'),(7,2,1,7,'Applied “Draft 1”'),(8,2,1,8,'Applied “Draft 1”'),(9,2,1,9,'Applied “Draft 1”'),(10,30,1,1,NULL),(11,2,1,10,'Applied “Draft 1”'),(12,2,1,11,'Applied “Draft 1”'),(13,2,1,12,'Applied “Draft 1”'),(14,2,1,13,'Applied “Draft 1”'),(15,2,1,14,'Applied “Draft 1”'),(16,76,1,1,''),(17,76,1,2,NULL),(18,76,1,3,''),(19,2,1,15,'Applied “Draft 1”'),(20,76,1,4,NULL),(21,76,1,5,'Applied “Draft 1”'),(22,2,1,16,'Applied “Draft 1”'),(23,76,1,6,'Applied “Draft 1”'),(24,2,1,17,'Applied “Draft 1”'),(25,2,1,18,'Applied “Draft 1”'),(26,76,1,7,'Applied “Draft 1”'),(27,130,1,1,''),(28,132,1,1,''),(29,2,1,19,'Applied “Draft 1”'),(30,2,1,20,''),(31,2,1,21,'Applied “Draft 1”'),(32,2,1,22,'Applied “Draft 1”'),(33,76,1,8,'Applied “Draft 1”');
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `searchindex`
--

LOCK TABLES `searchindex` WRITE;
/*!40000 ALTER TABLE `searchindex` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `searchindex` VALUES (1,'username',0,1,' admin '),(1,'firstname',0,1,''),(1,'lastname',0,1,''),(1,'fullname',0,1,''),(1,'email',0,1,' admin wesvault com '),(1,'slug',0,1,''),(2,'slug',0,1,' homepage '),(2,'title',0,1,' homepage '),(15,'slug',0,1,''),(30,'title',0,1,' contentpage '),(30,'slug',0,1,' contentpage '),(45,'slug',0,1,''),(32,'title',0,1,' maintainece '),(49,'filename',0,1,' logo svg '),(49,'extension',0,1,' svg '),(49,'kind',0,1,' image '),(49,'slug',0,1,''),(49,'title',0,1,' logo '),(32,'slug',0,1,' maintainece '),(216,'slug',0,1,' homepage '),(76,'title',0,1,' billing information for wv trust '),(76,'slug',0,1,' billing information '),(78,'slug',0,1,' temp gohlruyeyhdypdkrlzkxrasbytzhtgxacafz '),(78,'title',0,1,''),(90,'slug',0,1,''),(132,'title',0,1,' 111 medina avenue medina '),(130,'title',0,1,' 1 5 nasmyth road rockingham '),(199,'title',0,1,' 1 5 nasmyth rockingham '),(132,'slug',0,1,' 111 medina '),(150,'slug',0,1,''),(151,'slug',0,1,''),(143,'slug',0,1,''),(144,'slug',0,1,''),(145,'filename',0,1,' mainpage jpg '),(145,'extension',0,1,' jpg '),(145,'kind',0,1,' image '),(145,'slug',0,1,''),(145,'title',0,1,' mainpage '),(188,'slug',0,1,''),(130,'slug',0,1,' 1 5 nasmth '),(199,'slug',0,1,' 1 5 nasmyth rockingham '),(200,'kind',0,1,' image '),(200,'extension',0,1,' jpg '),(200,'filename',0,1,' unit d jpg '),(205,'filename',0,1,' unit d jpg '),(200,'slug',0,1,''),(200,'title',0,1,' 111 medina ave '),(205,'extension',0,1,' jpg '),(205,'kind',0,1,' image '),(205,'slug',0,1,''),(205,'title',0,1,' unit d '),(215,'slug',0,1,''),(216,'title',0,1,' homepage '),(217,'slug',0,1,''),(218,'slug',0,1,''),(214,'slug',0,1,' 1 5 nasmyth rockingham '),(214,'title',0,1,' 1 5 nasmyth rockingham '),(221,'title',0,1,' 111 medina avenue medina '),(221,'slug',0,1,' 111 medina '),(222,'slug',0,1,''),(223,'slug',0,1,'');
/*!40000 ALTER TABLE `searchindex` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `sections`
--

LOCK TABLES `sections` WRITE;
/*!40000 ALTER TABLE `sections` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `sections` VALUES (1,NULL,'Homepage','homepage','single',1,'all','end',NULL,'2022-07-04 02:21:22','2022-07-04 02:21:22',NULL,'a34c98ef-da5b-4203-ab2a-00134c3d3424'),(2,NULL,'ContentPage','contentPage','single',1,'all','end',NULL,'2022-07-04 03:42:17','2022-07-04 03:42:17','2022-07-04 03:43:07','9567cd15-dc23-4471-8546-c8c788cda1c9'),(3,NULL,'Maintainece','maintainece','single',0,'all','end',NULL,'2022-07-04 03:46:59','2022-07-04 03:46:59',NULL,'45328b02-47bd-4dc2-9cd0-d5fbca492ca2'),(4,NULL,'Billing','billing','single',1,'all','end',NULL,'2022-07-07 05:39:06','2022-07-07 05:44:52',NULL,'41182da9-4532-4be7-a64b-ec2fc6dc82d2'),(5,1,'property','property','structure',0,'all','beginning',NULL,'2022-10-29 05:30:14','2022-10-29 06:08:58',NULL,'13906807-3b1b-43fa-b531-55e16707323e');
/*!40000 ALTER TABLE `sections` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `sections_sites`
--

LOCK TABLES `sections_sites` WRITE;
/*!40000 ALTER TABLE `sections_sites` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `sections_sites` VALUES (1,1,1,1,'__home__','index.twig',1,'2022-07-04 02:21:22','2022-07-04 02:21:22','4eaeee97-502c-44d2-af82-952f191f12d0'),(2,2,1,1,'content','content/_entry',1,'2022-07-04 03:42:17','2022-07-04 03:42:17','d6567c88-0e12-4404-9837-755b5cc6fc06'),(3,3,1,1,'maintainece','_content.twig',1,'2022-07-04 03:46:59','2022-07-04 03:46:59','6c48f22e-4719-4358-b6e0-0e9c4a7944f0'),(4,4,1,1,'billing','_content.twig',1,'2022-07-07 05:39:06','2022-07-07 05:46:27','c8e3646b-adcc-4fee-95d0-6ea7003c9d90'),(5,5,1,1,'property/{slug}','property/_entry.twig',1,'2022-10-29 05:30:14','2022-10-29 06:08:58','700a58ea-37be-4009-b18d-d7d8e5243f93');
/*!40000 ALTER TABLE `sections_sites` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `sequences`
--

LOCK TABLES `sequences` WRITE;
/*!40000 ALTER TABLE `sequences` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `sequences` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `shunnedmessages`
--

LOCK TABLES `shunnedmessages` WRITE;
/*!40000 ALTER TABLE `shunnedmessages` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `shunnedmessages` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `sitegroups`
--

LOCK TABLES `sitegroups` WRITE;
/*!40000 ALTER TABLE `sitegroups` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `sitegroups` VALUES (1,'WV Trust','2022-07-04 01:44:27','2022-07-04 01:44:27',NULL,'52e933c4-1638-4b82-8406-a9e8639fe56d');
/*!40000 ALTER TABLE `sitegroups` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `sites`
--

LOCK TABLES `sites` WRITE;
/*!40000 ALTER TABLE `sites` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `sites` VALUES (1,1,1,1,'WV Trust','default','en-US',1,'$PRIMARY_SITE_URL',1,'2022-07-04 01:44:27','2022-07-04 01:44:27',NULL,'a7703bae-b817-4711-acfb-83fb257f9cdf');
/*!40000 ALTER TABLE `sites` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `structureelements`
--

LOCK TABLES `structureelements` WRITE;
/*!40000 ALTER TABLE `structureelements` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `structureelements` VALUES (1,1,NULL,1,1,6,0,'2022-10-29 06:06:57','2022-12-01 07:17:31','65f1550b-2e43-4450-8d62-86527e37539e'),(3,1,132,1,4,5,1,'2022-10-29 06:07:11','2022-12-01 07:17:31','4041f399-57c4-4b94-a536-266ca504b775'),(4,1,199,1,2,3,1,'2022-12-01 07:17:31','2022-12-01 07:17:31','59d6aed6-9bfe-4390-9921-aaa6fc2e6605');
/*!40000 ALTER TABLE `structureelements` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `structures`
--

LOCK TABLES `structures` WRITE;
/*!40000 ALTER TABLE `structures` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `structures` VALUES (1,NULL,'2022-10-29 05:30:14','2022-10-29 05:30:14',NULL,'33317265-c7a2-4710-bc21-c49526dcbc64');
/*!40000 ALTER TABLE `structures` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `systemmessages`
--

LOCK TABLES `systemmessages` WRITE;
/*!40000 ALTER TABLE `systemmessages` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `systemmessages` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `taggroups`
--

LOCK TABLES `taggroups` WRITE;
/*!40000 ALTER TABLE `taggroups` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `taggroups` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `tokens`
--

LOCK TABLES `tokens` WRITE;
/*!40000 ALTER TABLE `tokens` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `tokens` VALUES (13,'oSuR3VBLww0L8pzCBAErGJcMMNC_Svjv','[\"preview/preview\",{\"elementType\":\"craft\\\\elements\\\\Entry\",\"sourceId\":2,\"siteId\":1,\"draftId\":null,\"revisionId\":null,\"userId\":1}]',NULL,NULL,'2023-04-26 01:54:28','2023-04-25 01:54:28','2023-04-25 01:54:28','d9fa0f4b-3476-4bbb-9587-cfbd61d75604'),(14,'T1957xOB7nmFKA3zII95shO3BgMBorxT','[\"preview/preview\",{\"elementType\":\"craft\\\\elements\\\\Entry\",\"sourceId\":199,\"siteId\":1,\"draftId\":null,\"revisionId\":null,\"userId\":1}]',NULL,NULL,'2023-04-26 01:56:57','2023-04-25 01:56:57','2023-04-25 01:56:57','c55c43bd-ad56-4aa5-8215-1cc09734b683');
/*!40000 ALTER TABLE `tokens` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `usergroups`
--

LOCK TABLES `usergroups` WRITE;
/*!40000 ALTER TABLE `usergroups` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `usergroups` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `usergroups_users`
--

LOCK TABLES `usergroups_users` WRITE;
/*!40000 ALTER TABLE `usergroups_users` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `usergroups_users` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `userpermissions`
--

LOCK TABLES `userpermissions` WRITE;
/*!40000 ALTER TABLE `userpermissions` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `userpermissions` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `userpermissions_usergroups`
--

LOCK TABLES `userpermissions_usergroups` WRITE;
/*!40000 ALTER TABLE `userpermissions_usergroups` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `userpermissions_usergroups` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `userpermissions_users`
--

LOCK TABLES `userpermissions_users` WRITE;
/*!40000 ALTER TABLE `userpermissions_users` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `userpermissions_users` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `userpreferences`
--

LOCK TABLES `userpreferences` WRITE;
/*!40000 ALTER TABLE `userpreferences` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `userpreferences` VALUES (1,'{\"language\":\"en-US\"}');
/*!40000 ALTER TABLE `userpreferences` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `users` VALUES (1,'admin',NULL,NULL,NULL,'admin@wesvault.com','$2y$13$Vp0zqC0ctmd./Swk./hm9.SFEkqlyZV9faSGd7BC9HD6nIFN0TD5W',1,0,0,0,'2023-04-25 14:35:43',NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,0,'2022-07-04 01:44:27','2022-07-04 01:44:27','2023-04-25 14:35:43','db16be3c-724b-4ec7-a8aa-b8d295641396');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `volumefolders`
--

LOCK TABLES `volumefolders` WRITE;
/*!40000 ALTER TABLE `volumefolders` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `volumefolders` VALUES (1,NULL,NULL,'Temporary source',NULL,'2022-07-04 03:55:34','2022-07-04 03:55:34','70287e07-4e73-410e-b5b3-b31728adf3cc'),(2,1,NULL,'user_1','user_1/','2022-07-04 03:55:34','2022-07-04 03:55:34','febe8ba7-39da-4da2-8288-7d42cb70b3e9'),(3,NULL,1,'Homepage','','2022-07-04 03:59:56','2022-07-04 03:59:56','a45fe04d-c3c8-45c8-ad17-3b6c521cc457'),(4,NULL,2,'Property','','2022-10-29 06:52:18','2022-10-29 06:52:18','4f7e58b7-03da-4e86-87d4-c3812d739f74'),(5,4,2,'@web','@web/','2022-12-01 07:50:40','2022-12-01 07:50:40','ea60f4ce-5d8a-49d2-b2f8-07827461d7ef'),(6,5,2,'images','@web/images/','2022-12-01 07:50:40','2022-12-01 07:50:40','a1d67d9c-9f9a-43aa-a995-d273e33dd230'),(7,6,2,'uploads','@web/images/uploads/','2022-12-01 07:50:40','2022-12-01 07:50:40','1580eed2-52b0-410c-965b-d785640ca019'),(8,7,2,'property','@web/images/uploads/property/','2022-12-01 07:50:40','2022-12-01 07:50:40','3634aa55-d953-48e2-a107-bb6590134fe6');
/*!40000 ALTER TABLE `volumefolders` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `volumes` VALUES (1,5,'Homepage','homepage','craft\\volumes\\Local',1,'@web/images/uploads/homepage','site',NULL,'{\"path\":\"@webroot/images/uploads/homepage\"}',1,'2022-07-04 03:59:56','2022-07-04 03:59:56',NULL,'cdc2c8ee-142d-4714-a659-c1b46e254b25'),(2,8,'Property','property','craft\\volumes\\Local',1,'@web/images/uploads/property','site',NULL,'{\"path\":\"@webroot/images/uploads/property\"}',2,'2022-10-29 06:52:18','2022-12-01 07:52:59',NULL,'4691da8f-b71c-465a-a5df-29d41a87e0a5');
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `widgets`
--

LOCK TABLES `widgets` WRITE;
/*!40000 ALTER TABLE `widgets` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `widgets` VALUES (1,1,'craft\\widgets\\RecentEntries',1,NULL,'{\"siteId\":1,\"section\":\"*\",\"limit\":10}',1,'2022-07-04 01:48:56','2022-07-04 01:48:56','87062e3f-94c4-4c27-9471-883a323c54b2'),(2,1,'craft\\widgets\\CraftSupport',2,NULL,'[]',1,'2022-07-04 01:48:56','2022-07-04 01:48:56','d04c1358-82f7-4e81-a673-8052a6307794'),(3,1,'craft\\widgets\\Updates',3,NULL,'[]',1,'2022-07-04 01:48:56','2022-07-04 01:48:56','43c4a41b-3fc8-438e-bd4f-7a58f93f9973'),(4,1,'craft\\widgets\\Feed',4,NULL,'{\"url\":\"https://craftcms.com/news.rss\",\"title\":\"Craft News\",\"limit\":5}',1,'2022-07-04 01:48:57','2022-07-04 01:48:57','5e46ca3b-bd49-4c18-a4ed-b465dd4bab71');
/*!40000 ALTER TABLE `widgets` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping routines for database 'addons_wvtrust'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-04-25 22:35:53
